/*
 * Decompiled with CFR 0.152.
 */
package jsbugs.samplesandinterps;

import com.stratadata.model3.well.WellRepository;
import com.stratadata.util.ui.SBDialog;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import jsbugs.userconnect.SbugsExceptionHandler;
import jsbugs.wellheader.DialogSelectWell;
import model3.SBdb;
import model3.Well;
import model3.WellDocument;
import model3.WellDocumentService;

public class DialogWellDocRefs
extends SBDialog {
    private final WellDocument document;
    private final WellDocumentService docService;
    private final WellRepository<Well> wellService;
    private final SBdb sbdb;
    private final DefaultListModel<Well> model = new DefaultListModel();
    private JButton jButtonAddRef;
    private JButton jButtonCancel;
    private JButton jButtonOK;
    private JButton jButtonRemoveRef;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JList<Well> jList1;
    private JScrollPane jScrollPane1;
    private JTextField jTextFieldDocName;
    private JTextField jTextFieldPrimaryWellName;

    public DialogWellDocRefs(Frame parent, boolean modal, WellDocument document, WellDocumentService docService, WellRepository<Well> wellService, SBdb sbdb) throws SQLException {
        super(parent, modal);
        this.document = document;
        this.docService = docService;
        this.wellService = wellService;
        this.sbdb = sbdb;
        this.initComponents();
        this.init();
    }

    private void init() throws SQLException {
        this.setTitle("Well Document : Associated Wells");
        this.jTextFieldDocName.setText(this.document.getDescr());
        this.jTextFieldPrimaryWellName.setText(this.document.getPrimaryWellName());
        Set<Integer> referencedWellIDs = this.docService.getReferencedWellIDs(this.document.getDocID());
        ArrayList<Well> referencedWells = new ArrayList<Well>();
        for (Integer wellID : referencedWellIDs) {
            try {
                referencedWells.add((Well)this.wellService.getWellByID(wellID.intValue()));
            }
            catch (RuntimeException e) {
                SbugsExceptionHandler.showStackError("Error getting well with ID " + wellID, e, (Component)((Object)this));
            }
        }
        Collections.sort(referencedWells);
        this.model.addAll(referencedWells);
    }

    private void initComponents() {
        this.jTextFieldDocName = new JTextField();
        this.jLabel2 = new JLabel();
        this.jTextFieldPrimaryWellName = new JTextField();
        this.jLabel1 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.jList1 = new JList();
        this.jButtonAddRef = new JButton();
        this.jButtonRemoveRef = new JButton();
        this.jButtonOK = new JButton();
        this.jButtonCancel = new JButton();
        this.setDefaultCloseOperation(2);
        this.jTextFieldDocName.setEditable(false);
        this.jTextFieldDocName.setBackground(new Color(255, 255, 204));
        this.jTextFieldDocName.setText("DocumentName.PDF");
        this.jLabel2.setText("Primary well:");
        this.jTextFieldPrimaryWellName.setEditable(false);
        this.jTextFieldPrimaryWellName.setBackground(new Color(255, 255, 204));
        this.jTextFieldPrimaryWellName.setText("Well Name");
        this.jLabel1.setText("Also associated with wells:");
        this.jList1.setModel(this.model);
        this.jList1.setSelectionMode(0);
        this.jScrollPane1.setViewportView(this.jList1);
        this.jButtonAddRef.setText("Add...");
        this.jButtonAddRef.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogWellDocRefs this$0;
            {
                DialogWellDocRefs dialogWellDocRefs = this$0;
                Objects.requireNonNull(dialogWellDocRefs);
                this.this$0 = dialogWellDocRefs;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonAddRefActionPerformed(evt);
            }
        });
        this.jButtonRemoveRef.setText("Remove");
        this.jButtonRemoveRef.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogWellDocRefs this$0;
            {
                DialogWellDocRefs dialogWellDocRefs = this$0;
                Objects.requireNonNull(dialogWellDocRefs);
                this.this$0 = dialogWellDocRefs;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonRemoveRefActionPerformed(evt);
            }
        });
        this.jButtonOK.setText("OK");
        this.jButtonOK.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogWellDocRefs this$0;
            {
                DialogWellDocRefs dialogWellDocRefs = this$0;
                Objects.requireNonNull(dialogWellDocRefs);
                this.this$0 = dialogWellDocRefs;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonOKActionPerformed(evt);
            }
        });
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogWellDocRefs this$0;
            {
                DialogWellDocRefs dialogWellDocRefs = this$0;
                Objects.requireNonNull(dialogWellDocRefs);
                this.this$0 = dialogWellDocRefs;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonCancelActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jTextFieldDocName).addComponent(this.jScrollPane1).addGroup(layout.createSequentialGroup().addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextFieldPrimaryWellName)).addGroup(layout.createSequentialGroup().addComponent(this.jLabel1).addGap(0, 0, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(this.jButtonAddRef).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonRemoveRef).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 45, Short.MAX_VALUE).addComponent(this.jButtonOK).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonCancel))).addContainerGap()));
        layout.linkSize(0, this.jButtonCancel, this.jButtonOK);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jTextFieldDocName, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.jTextFieldPrimaryWellName, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButtonAddRef).addComponent(this.jButtonRemoveRef).addComponent(this.jButtonOK).addComponent(this.jButtonCancel)).addContainerGap()));
        this.pack();
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void jButtonRemoveRefActionPerformed(ActionEvent evt) {
        Well well = this.jList1.getSelectedValue();
        if (well == null) {
            return;
        }
        this.model.removeElement(well);
    }

    private void jButtonAddRefActionPerformed(ActionEvent evt) {
        DialogSelectWell dialog = new DialogSelectWell((JDialog)((Object)this), true, this.sbdb, true, null);
        dialog.setLocationRelativeTo((Component)((Object)this));
        dialog.setVisible(true);
        List<Well> selected = dialog.getSelection();
        for (Well w : selected) {
            if (w.getWellID() == this.document.getPrimaryWellID() || this.model.contains(w)) continue;
            this.model.addElement(w);
        }
    }

    private void jButtonOKActionPerformed(ActionEvent evt) {
        this.setOK();
    }

    public List<Well> getWells() {
        return Collections.list(this.model.elements());
    }
}

