/*
 * Decompiled with CFR 0.152.
 */
package jsbugs.samplesandinterps;

import com.stratadata.model3.well.analysis.Situation;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractCellEditor;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.LineBorder;
import javax.swing.table.TableCellEditor;
import jsbugs.TaxonOccurrenceChanges;
import jsbugs.samplesandinterps.taxonoccurrences.DialogTaxonOccurrences;
import jsbugs.table.AnalysisTaxonTotal;
import jsbugs.uiutil.UIColours;
import jsbugs.userconnect.SbugsSession;
import model3.TaxonOcc;
import model3.TaxonOccCountUpdate;

public class TaxonTotalCellEditor
extends AbstractCellEditor
implements TableCellEditor {
    private final JTextField textField = new JTextField();
    private final JButton button = new JButton();
    private Object value;
    private AnalysisTaxonTotal total;
    private DialogTaxonOccurrences dialog = new DialogTaxonOccurrences((Frame)null, true);

    public TaxonTotalCellEditor() {
        this.textField.setHorizontalAlignment(4);
        this.textField.setBorder(BorderFactory.createLineBorder(Color.black));
        this.button.setBorderPainted(false);
        this.button.setOpaque(true);
        this.button.setContentAreaFilled(false);
        this.button.setFocusable(false);
        this.button.setBackground(UIColours.EDITABLE_CELL_BACKGROUND);
        this.button.setHorizontalAlignment(4);
        this.dialog.setEditor(this);
    }

    @Override
    public boolean isCellEditable(EventObject e) {
        if (e instanceof MouseEvent) {
            return ((MouseEvent)e).getClickCount() >= 2;
        }
        return true;
    }

    @Override
    public boolean stopCellEditing() {
        String s = this.textField.getText().trim();
        boolean validValue = false;
        TaxonOccurrenceChanges changes = new TaxonOccurrenceChanges();
        try {
            if (this.total.isEmptyOccurrences()) {
                if (s.isEmpty()) {
                    this.value = null;
                    validValue = true;
                } else {
                    TaxonOcc.Builder builder = new TaxonOcc.Builder(SbugsSession.getDb(), this.total.getTaxon(), Situation.INSITU, false, 0);
                    if (s.equals("0") || s.equals("+")) {
                        builder.count(0);
                    } else if (this.total.getAbundanceScheme() != null && this.total.getAbundanceScheme().findEntryBySubjAbund(s).isPresent()) {
                        builder.subjAbund(s.toUpperCase());
                    } else {
                        builder.count(Integer.parseInt(s));
                    }
                    changes.addAddition(builder);
                    validValue = true;
                }
            } else if (this.total.isSingleOccurrence()) {
                if (s.isEmpty()) {
                    changes.addDeletion(this.total.getFirstOccurrence());
                    validValue = true;
                } else {
                    int count = 0;
                    String subjectAbund = null;
                    if (s.equals("0") || s.equals("+")) {
                        validValue = true;
                    } else if (this.total.getAbundanceScheme() != null && this.total.getAbundanceScheme().findEntryBySubjAbund(s).isPresent()) {
                        subjectAbund = s.toUpperCase();
                        validValue = true;
                    } else {
                        count = Integer.parseInt(s);
                        validValue = true;
                    }
                    TaxonOcc occ = this.total.getFirstOccurrence();
                    changes.addUpdate(new TaxonOccCountUpdate(occ, 0, count, 0, subjectAbund));
                    validValue = true;
                }
            }
        }
        catch (NumberFormatException e) {
            validValue = false;
        }
        catch (Exception e) {
            validValue = false;
            Logger.getLogger(TaxonTotalCellEditor.class.getName()).log(Level.WARNING, "Exception while trying to generate new cell value", e);
        }
        if (!validValue) {
            this.textField.setBorder(new LineBorder(Color.red));
            return false;
        }
        this.value = changes;
        return super.stopCellEditing();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int rowIndex, int vColIndex) {
        this.value = null;
        if (value == null) {
            return null;
        }
        this.textField.setBorder(BorderFactory.createLineBorder(Color.black));
        if (!(value instanceof AnalysisTaxonTotal)) throw new IllegalArgumentException("TaxonTotalCellEditor requires value to be an instance of AnalysisTaxonTotal.");
        this.total = (AnalysisTaxonTotal)value;
        if (this.total.isEmptyOccurrences()) {
            this.textField.setText("");
            return this.textField;
        } else if (this.total.isSingleOccurrence() && this.total.areAllSubjectAbundance()) {
            this.textField.setText(this.total.getFirstOccurrenceSubjectAbundance());
            return this.textField;
        } else if (this.total.isSingleOccurrence()) {
            this.textField.setText(Integer.toString(this.total.getFirstOccurrenceTotalCount()));
            return this.textField;
        } else {
            SwingUtilities.invokeLater(new Runnable(this){
                final /* synthetic */ TaxonTotalCellEditor this$0;
                {
                    TaxonTotalCellEditor taxonTotalCellEditor = this$0;
                    Objects.requireNonNull(taxonTotalCellEditor);
                    this.this$0 = taxonTotalCellEditor;
                }

                @Override
                public void run() {
                    this.this$0.dialog.setTotal(this.this$0.total);
                    Point p = this.this$0.button.getLocationOnScreen();
                    this.this$0.dialog.pack();
                    this.this$0.dialog.setLocation(p.x - (int)((double)this.this$0.dialog.getSize().width * 0.5), p.y + this.this$0.button.getHeight());
                    this.this$0.dialog.setVisible(true);
                    this.this$0.fireEditingStopped();
                }
            });
            return this.button;
        }
    }

    public void setCellEditorValue(Object value) {
        this.value = value;
    }

    @Override
    public Object getCellEditorValue() {
        return this.value;
    }
}

