/*
 * Decompiled with CFR 0.152.
 */
package jsbugs.samplesandinterps.taxonoccurrences;

import com.stratadata.util.ui.table.TableUtils;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.LayoutStyle;
import javax.swing.table.DefaultTableModel;
import jsbugs.TaxonOccurrenceChanges;
import jsbugs.samplesandinterps.TaxonTotalCellEditor;
import jsbugs.samplesandinterps.taxonoccurrences.TaxonOccurrencesTableModel;
import jsbugs.samplesandinterps.taxonoccurrences.TaxonOccurrencesTableRow;
import jsbugs.table.AnalysisTaxonTotal;
import jsbugs.table.MarkerRenderer;
import jsbugs.table.cell.editor.AllowNullIntegerEditor;
import jsbugs.table.cell.renderer.EditableCellRenderer;
import jsbugs.uiutil.ComboboxItem;
import model3.TaxonOcc;

public class DialogTaxonOccurrences
extends JDialog {
    private TaxonTotalCellEditor editor;
    private AnalysisTaxonTotal total;
    private TaxonOccurrencesTableModel model;
    private final JComboBox semiQuantComboBox = new JComboBox();
    private final DefaultComboBoxModel semiQuantModel = new DefaultComboBoxModel();
    private JButton jButtonCancel;
    private JButton jButtonOK;
    private JScrollPane jScrollPane1;
    private JTable jTableOccurrences;

    public DialogTaxonOccurrences(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        this.semiQuantComboBox.setModel(this.semiQuantModel);
        TableUtils.setTableHeaderBold((JTable)this.jTableOccurrences);
    }

    private void initComponents() {
        this.jButtonOK = new JButton();
        this.jButtonCancel = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.jTableOccurrences = new JTable();
        this.setDefaultCloseOperation(2);
        this.setTitle("Taxon Occurrences");
        this.jButtonOK.setText("OK");
        this.jButtonOK.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogTaxonOccurrences this$0;
            {
                DialogTaxonOccurrences dialogTaxonOccurrences = this$0;
                Objects.requireNonNull(dialogTaxonOccurrences);
                this.this$0 = dialogTaxonOccurrences;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonOKActionPerformed(evt);
            }
        });
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogTaxonOccurrences this$0;
            {
                DialogTaxonOccurrences dialogTaxonOccurrences = this$0;
                Objects.requireNonNull(dialogTaxonOccurrences);
                this.this$0 = dialogTaxonOccurrences;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonCancelActionPerformed(evt);
            }
        });
        this.jTableOccurrences.setModel(new DefaultTableModel(new Object[][]{new Object[0], new Object[0], new Object[0], new Object[0]}, new String[0]));
        this.jScrollPane1.setViewportView(this.jTableOccurrences);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jScrollPane1).addGroup(layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.jButtonOK).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonCancel))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1, -1, 147, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButtonOK).addComponent(this.jButtonCancel)).addContainerGap()));
        this.pack();
    }

    private void jButtonOKActionPerformed(ActionEvent evt) {
        if (this.jTableOccurrences.isEditing()) {
            this.jTableOccurrences.getCellEditor().stopCellEditing();
        }
        if (this.editor != null) {
            this.editor.setCellEditorValue(this.getValue());
        }
        this.setVisible(false);
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        if (this.jTableOccurrences.isEditing()) {
            this.jTableOccurrences.getCellEditor().stopCellEditing();
        }
        this.setVisible(false);
    }

    public void setTotal(AnalysisTaxonTotal total) {
        this.total = total;
        int semiquantCount = 0;
        boolean semiquantPresent = false;
        boolean splitFactorsPresent = false;
        for (TaxonOcc taxonOcc : total.getOccurences()) {
            if (taxonOcc.getFine() != 0 || taxonOcc.getCoarse() != 0) {
                splitFactorsPresent = true;
                continue;
            }
            if (taxonOcc.getSubAbund() == null || taxonOcc.getSubAbund().isEmpty()) continue;
            semiquantPresent = true;
            ++semiquantCount;
        }
        this.model = new TaxonOccurrencesTableModel(splitFactorsPresent, semiquantPresent, semiquantCount == total.getOccurences().size());
        this.jTableOccurrences.setModel(this.model);
        ArrayList<TaxonOccurrencesTableRow> rows = new ArrayList<TaxonOccurrencesTableRow>();
        for (TaxonOcc occ : total.getOccurences()) {
            String specTypeString = "";
            try {
                specTypeString = occ.getSpecTypeString();
            }
            catch (SQLException ex) {
                Logger.getLogger(DialogTaxonOccurrences.class.getName()).log(Level.WARNING, "Error loading occurrences", ex);
            }
            TaxonOccurrencesTableRow row = new TaxonOccurrencesTableRow(occ.getSituation(), occ.getQuestionable(), occ.isMarker(), occ.getSubAbund(), occ.getCoarse(), occ.getMedium(), occ.getFine(), occ.getSpecType(), specTypeString);
            rows.add(row);
        }
        this.model.setRows(rows);
        this.model.setAbundanceScheme(total.getAbundanceScheme());
        this.model.fireTableDataChanged();
        String string = total.getTaxon().toString() + " in " + total.getAnalysis().getSample().toString() + " " + total.getAnalysis().getHeader().getDiscipline().getAbr(true) + " " + total.getAnalysis().getHeader().toString();
        this.setTitle(string);
        if (semiquantPresent && total.getAbundanceScheme() != null) {
            this.semiQuantModel.removeAllElements();
            this.semiQuantModel.addElement(new ComboboxItem<String>(null, ""));
            this.semiQuantModel.addElement(new ComboboxItem<String>("+", "+"));
            total.getAbundanceScheme().getEntries().forEach(entry -> this.semiQuantModel.addElement(new ComboboxItem<String>(entry.abr(), entry.entryName())));
            if (this.model.getSubjectiveColumnIndex() > 0) {
                this.jTableOccurrences.getColumnModel().getColumn(this.model.getSubjectiveColumnIndex()).setCellEditor(new DefaultCellEditor(this.semiQuantComboBox));
                this.jTableOccurrences.getColumnModel().getColumn(this.model.getSubjectiveColumnIndex()).setCellRenderer(new EditableCellRenderer());
            }
        }
        this.jTableOccurrences.setDefaultEditor(Integer.class, new AllowNullIntegerEditor());
        this.jTableOccurrences.setDefaultRenderer(Integer.class, new EditableCellRenderer());
        this.jTableOccurrences.setDefaultRenderer(Boolean.class, new MarkerRenderer());
    }

    public Object getValue() {
        TaxonOccurrenceChanges changes = new TaxonOccurrenceChanges();
        for (TaxonOcc occ : this.total.getOccurences()) {
            TaxonOccurrencesTableRow row = this.model.getCorrespondingRow(occ);
            if (row == null) continue;
            if (row.isDeleted()) {
                changes.addDeletion(occ);
                continue;
            }
            if (!row.hasChanged(occ)) continue;
            changes.addUpdate(row.buildCountUpdate(occ));
        }
        return changes;
    }

    public void setEditor(TaxonTotalCellEditor editor) {
        this.editor = editor;
    }
}

