/*
 * Decompiled with CFR 0.152.
 */
package jsbugs.table;

import com.stratadata.model3.well.analysis.hdr.AbundanceScheme;
import java.util.List;
import java.util.logging.Logger;
import model3.Smpdtl;
import model3.Taxon;
import model3.TaxonOcc;

public class AnalysisTaxonTotal {
    private static Logger log = Logger.getLogger(AnalysisTaxonTotal.class.getName());
    private final Taxon taxon;
    private final List<TaxonOcc> occs;
    private final Smpdtl analysis;
    private final AbundanceScheme abundanceScheme;

    public AnalysisTaxonTotal(Smpdtl analysis, Taxon taxon, List<TaxonOcc> occurrences, AbundanceScheme abundanceScheme) {
        if (analysis == null) {
            throw new IllegalArgumentException("analysis value can't be null.");
        }
        if (taxon == null) {
            throw new IllegalArgumentException("taxon value can't be null.");
        }
        if (occurrences != null) {
            for (TaxonOcc o : occurrences) {
                if (o.getSpecID() == taxon.getSpecID()) continue;
                throw new IllegalArgumentException("The occurrences provided to the AnalysisTaxonTotal must match the provided taxon");
            }
        }
        this.taxon = taxon;
        this.occs = occurrences;
        this.analysis = analysis;
        this.abundanceScheme = abundanceScheme;
    }

    public boolean isEmptyOccurrences() {
        return this.occs.isEmpty();
    }

    public boolean isSingleOccurrence() {
        return this.occs.size() == 1;
    }

    public boolean areAllSubjectAbundance() {
        for (TaxonOcc o : this.occs) {
            if (o.getSubAbund() != null && !o.getSubAbund().isEmpty()) continue;
            return false;
        }
        return true;
    }

    public TaxonOcc getFirstOccurrence() {
        return this.occs.get(0);
    }

    public String getFirstOccurrenceSubjectAbundance() {
        return this.occs.get(0).getSubAbund();
    }

    public int getFirstOccurrenceTotalCount() {
        return this.occs.get(0).getTotalCount();
    }

    public AbundanceScheme getAbundanceScheme() {
        return this.abundanceScheme;
    }

    public List<TaxonOcc> getOccurences() {
        return this.occs;
    }

    public Smpdtl getAnalysis() {
        return this.analysis;
    }

    public Taxon getTaxon() {
        return this.taxon;
    }

    public String getTotalStringValue() {
        if (this.occs == null || this.occs.isEmpty()) {
            return null;
        }
        if (this.occs.size() == 1) {
            TaxonOcc o = this.occs.get(0);
            if (o.isOutsideCount()) {
                return "+";
            }
            if (o.getSubAbund() != null && !o.getSubAbund().isEmpty()) {
                return o.getSubAbund();
            }
            return Integer.toString(o.getTotalCount());
        }
        int total = 0;
        for (TaxonOcc o : this.occs) {
            total += o.getDerivedCount(this.abundanceScheme);
        }
        return Integer.toString(total);
    }
}

