/*
 * Decompiled with CFR 0.152.
 */
package jsbugs.table;

import java.awt.Component;
import java.awt.Frame;
import java.awt.Point;
import java.awt.event.ActionEvent;
import javax.swing.JTable;
import jsbugs.chart.DialogChartCaption;
import jsbugs.table.ButtonEditor;

public class CaptionEditor
extends ButtonEditor {
    private final Frame parentFrame;
    private String caption;

    public CaptionEditor(Frame parentFrame) {
        super("<default>");
        this.parentFrame = parentFrame;
    }

    @Override
    public Object getCellEditorValue() {
        return this.caption;
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        this.caption = (String)value;
        return this.renderer.getTableCellRendererComponent(table, value, isSelected, isSelected, row, column);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        DialogChartCaption dialog = new DialogChartCaption(this.parentFrame, true, this.caption);
        Point p = new Point(this.renderer.getLocationOnScreen().x + 2 * this.renderer.getWidth(), this.renderer.getLocationOnScreen().y);
        if (p.getX() + (double)dialog.getWidth() < (double)(this.parentFrame.getX() + this.parentFrame.getWidth())) {
            dialog.setLocation(p);
        } else {
            dialog.setLocationRelativeTo(this.parentFrame);
        }
        dialog.setVisible(true);
        if (dialog.isOK()) {
            this.caption = dialog.getCaption();
            this.fireEditingStopped();
        } else {
            this.fireEditingCanceled();
        }
    }
}

