/*
 * Decompiled with CFR 0.152.
 */
package jsbugs.table;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.HashSet;
import javax.swing.JFrame;
import javax.swing.JTable;
import jsbugs.DialogCheckList;
import jsbugs.table.ButtonEditor;

abstract class CollectionEditor
extends ButtonEditor {
    private final JFrame parent;
    Collection<Object> collection;

    CollectionEditor(JFrame parent) {
        this.parent = parent;
    }

    CollectionEditor(JFrame parent, String nullString) {
        super(nullString);
        this.parent = parent;
    }

    @Override
    public Object getCellEditorValue() {
        return this.collection;
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        this.collection = (Collection)value;
        return this.renderer.getTableCellRendererComponent(table, value, isSelected, isSelected, row, column);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object[] items = this.getFullList();
        boolean[] checks = new boolean[items.length];
        for (int i = 0; i < items.length; ++i) {
            checks[i] = this.collection == null || this.collection != null && this.collection.contains(items[i]);
        }
        DialogCheckList dialog = new DialogCheckList(this.parent, true, this.getSelectionType(), items, checks);
        dialog.setLocationRelativeTo(this.renderer);
        dialog.setVisible(true);
        if (dialog.isOK()) {
            HashSet<Object> collection_ = new HashSet<Object>();
            for (int i = 0; i < items.length; ++i) {
                if (!checks[i]) continue;
                collection_.add(items[i]);
            }
            if (this.allowNone()) {
                this.collection = collection_.size() == items.length || collection_.isEmpty() ? null : collection_;
            } else {
                if (collection_.isEmpty()) {
                    this.fireEditingCanceled();
                    return;
                }
                this.collection = collection_;
            }
            this.fireEditingStopped();
        } else {
            this.fireEditingCanceled();
        }
    }

    abstract Object[] getFullList();

    abstract String getSelectionType();

    abstract boolean allowNone();
}

