/*
 * Decompiled with CFR 0.152.
 */
package jsbugs.table;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.Box;
import javax.swing.JTable;
import javax.swing.JTextField;
import jsbugs.table.ButtonRenderer;

public class ColourButtonRenderer
extends ButtonRenderer {
    private final JTextField colourField = new JTextField();
    private static final String DEFAULT_NULL_STRING = "Inherited";
    private String nullString = "Inherited";

    public ColourButtonRenderer() {
        Dimension d = new Dimension(12, 12);
        this.colourField.setMaximumSize(d);
        this.colourField.setMinimumSize(d);
        this.colourField.setPreferredSize(d);
        this.canClear(false);
    }

    public ColourButtonRenderer(boolean canClear) {
        Dimension d = new Dimension(12, 12);
        this.colourField.setMaximumSize(d);
        this.colourField.setMinimumSize(d);
        this.colourField.setPreferredSize(d);
        this.canClear(canClear);
    }

    public void setNullString(String nullString) {
        if (nullString == null) {
            nullString = DEFAULT_NULL_STRING;
        }
        this.nullString = nullString;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        this.getPanel().setBackground(isSelected ? table.getSelectionBackground() : table.getBackground());
        if (value != null) {
            this.colourField.setBackground((Color)value);
        }
        this.getPanel().removeAll();
        this.getPanel().add(Box.createHorizontalStrut(3));
        if (value != null) {
            this.getPanel().add(this.colourField);
        } else {
            this.getPanel().add(super.getSuperLabel(table, this.nullString, isSelected, hasFocus, row, column));
        }
        this.getPanel().add(Box.createHorizontalGlue());
        this.getPanel().add(this.getButton());
        if (this.canClear() && value != null) {
            this.getPanel().add(this.getClearButton());
        }
        return this.getPanel();
    }
}

