/*
 * Decompiled with CFR 0.152.
 */
package jsbugs.table;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.Box;
import javax.swing.JTable;
import javax.swing.JTextField;
import jsbchart.util.colour.ColourScale;
import jsbugs.table.ButtonRenderer;

public class ColourScaleRenderer
extends ButtonRenderer {
    private static final String DEFAULT_NULL_STRING = "Not defined";
    private String nullString = "Not defined";

    public ColourScaleRenderer() {
        this.canClear(false);
    }

    public void setNullString(String nullString) {
        if (nullString == null) {
            nullString = DEFAULT_NULL_STRING;
        }
        this.nullString = nullString;
    }

    private JTextField getColourField(Color colour) {
        Dimension d = new Dimension(12, 12);
        JTextField colourField = new JTextField();
        colourField.setMaximumSize(d);
        colourField.setMinimumSize(d);
        colourField.setPreferredSize(d);
        colourField.setBackground(colour);
        return colourField;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        this.getPanel().setBackground(isSelected ? table.getSelectionBackground() : table.getBackground());
        this.getPanel().removeAll();
        this.getPanel().add(Box.createHorizontalStrut(3));
        if (value != null) {
            ColourScale colourScale = (ColourScale)value;
            colourScale.getScale().stream().map(ColourScale.ValueColour::colour).map(this::getColourField).forEach(field -> {
                this.getPanel().add((Component)field);
                this.getPanel().add(Box.createHorizontalStrut(3));
            });
        } else {
            this.getPanel().add(super.getSuperLabel(table, this.nullString, isSelected, hasFocus, row, column));
        }
        this.getPanel().add(Box.createHorizontalGlue());
        this.getPanel().add(this.getButton());
        if (this.canClear() && value != null) {
            this.getPanel().add(this.getClearButton());
        }
        return this.getPanel();
    }
}

