/*
 * Decompiled with CFR 0.152.
 */
package jsbugs.table;

import java.awt.Color;
import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;
import javax.swing.table.TableCellRenderer;

public class ColouredRenderer
extends JLabel
implements TableCellRenderer {
    public static final Color GREY = new Color(220, 220, 220);
    private static final int BORDER_WIDTH = 2;
    private static final Border NOT_SELECTED_BORDER = new LineBorder(GREY, 2);
    private final boolean isBordered;
    private Border selectedBorder = null;

    public ColouredRenderer(boolean isBordered, Color colour) {
        this(isBordered, colour, 10);
    }

    public ColouredRenderer(boolean isBordered, Color colour, int alignment) {
        this(isBordered, colour, alignment, false);
    }

    public ColouredRenderer(boolean isBordered, Color colour, int alignment, boolean boldText) {
        this.isBordered = isBordered;
        this.init(colour, alignment, boldText);
    }

    private void init(Color colour, int alignment, boolean boldText) {
        this.setBackground(colour);
        this.setOpaque(true);
        this.setHorizontalAlignment(alignment);
        if (boldText) {
            this.setFont(this.getFont().deriveFont(1));
        }
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object obj, boolean isSelected, boolean hasFocus, int row, int column) {
        if (obj != null) {
            this.setText(obj.toString());
        }
        if (this.isBordered && !isSelected) {
            this.setBorder(NOT_SELECTED_BORDER);
        } else if (isSelected) {
            if (this.selectedBorder == null) {
                this.selectedBorder = BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(2, 0, 2, 0, table.getSelectionBackground()), BorderFactory.createEmptyBorder(0, 2, 0, 2));
            }
            this.setBorder(this.selectedBorder);
        } else {
            this.setBorder(null);
        }
        return this;
    }
}

