/*
 * Decompiled with CFR 0.152.
 */
package jsbugs.table;

import com.stratadata.util.depth.DepthUnits;
import com.stratadata.util.depth.DepthUtils;
import java.awt.Color;
import java.awt.Component;
import javax.swing.JTable;
import jsbugs.table.ColouredRenderer;
import jsbugs.table.DepthRendererStringFormatter;
import model3.SampleDepth;

public class CorrectedDepthRenderer
extends ColouredRenderer {
    private static final Color CORRECTED_DEPTH_TEXT_COLOUR = Color.red;
    private static final Color UNCORRECTED_DEPTH_TEXT_COLOUR = Color.BLACK;
    private final DepthRendererStringFormatter stringFormatter = new DepthRendererStringFormatter();
    private DepthUnits units = DepthUnits.M;

    public CorrectedDepthRenderer(DepthUnits units) {
        super(false, GREY, 10);
    }

    public void setUnits(DepthUnits units) {
        this.units = units;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object obj, boolean isSelected, boolean hasFocus, int row, int column) {
        super.getTableCellRendererComponent(table, obj, isSelected, hasFocus, row, column);
        if (obj instanceof SampleDepth) {
            SampleDepth depth = (SampleDepth)obj;
            if (depth.hasCorrection()) {
                this.setForeground(CORRECTED_DEPTH_TEXT_COLOUR);
            } else {
                this.setForeground(UNCORRECTED_DEPTH_TEXT_COLOUR);
            }
            double depthInDisplayUnits = DepthUtils.convFromM((double)depth.getCorrectedDepth(), (DepthUnits)this.units);
            this.setText(this.stringFormatter.getFormattedString(depthInDisplayUnits, 2));
        } else {
            this.setText(this.stringFormatter.getFormattedString(obj, 2));
        }
        return this;
    }
}

