/*
 * Decompiled with CFR 0.152.
 */
package jsbugs.table;

import java.awt.Color;
import java.awt.Component;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.border.CompoundBorder;
import javax.swing.table.DefaultTableCellRenderer;
import org.apache.commons.lang3.StringUtils;

public class DecimalRenderer
extends DefaultTableCellRenderer {
    public static final int HORIZONTAL_PADDING = 5;
    NumberFormat formatter = new DecimalFormat("0.000");
    Color editableBackground = new Color(235, 255, 255);
    boolean isEditable = false;
    private CompoundBorder selectedBorder;

    public DecimalRenderer() {
    }

    public DecimalRenderer(boolean isEditable) {
        this.isEditable = isEditable;
    }

    public DecimalRenderer(boolean isEditable, String formatString) {
        this.isEditable = isEditable;
        this.formatter = new DecimalFormat(formatString);
    }

    @Override
    public void setValue(Object value) {
        if (value == null) {
            this.setText("");
            return;
        }
        if (value instanceof Number) {
            this.setText(this.formatter.format(value));
        } else {
            this.setText(StringUtils.stripToEmpty((String)value.toString()));
        }
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        Component cellComponent = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        this.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
        if (this.isEditable && !isSelected) {
            cellComponent.setBackground(this.editableBackground);
        } else if (this.isEditable && isSelected) {
            if (this.selectedBorder == null) {
                this.selectedBorder = BorderFactory.createCompoundBorder();
                this.selectedBorder = BorderFactory.createCompoundBorder(this.selectedBorder, BorderFactory.createMatteBorder(2, 0, 2, 0, table.getSelectionBackground()));
                this.selectedBorder = BorderFactory.createCompoundBorder(this.selectedBorder, BorderFactory.createEmptyBorder(0, 5, 0, 5));
            }
            cellComponent.setBackground(this.editableBackground);
            cellComponent.setForeground(table.getForeground());
            if (cellComponent instanceof JComponent) {
                ((JComponent)cellComponent).setBorder(this.selectedBorder);
            }
        }
        return cellComponent;
    }
}

