/*
 * Decompiled with CFR 0.152.
 */
package jsbugs.table;

import jsbugs.table.DepthRendererStringFormatter;
import org.apache.commons.lang3.StringUtils;
import util.DepthUnits;
import util.status.BaseStatusRenderer;
import util.status.DoubleStatus;

public class DepthStatusRenderer
extends BaseStatusRenderer {
    private final int dps;
    private final DepthRendererStringFormatter formatter = new DepthRendererStringFormatter();
    private Character units = null;

    public DepthStatusRenderer(int dps) {
        this.dps = dps;
    }

    public String getTextFromItem(Object dbItem) {
        Object text = "";
        if (dbItem != null && dbItem instanceof DoubleStatus) {
            DoubleStatus s = (DoubleStatus)dbItem;
            text = this.formatter.getFormattedString(s.getDoubleValue(), this.dps);
            if (this.units != null && StringUtils.isNotEmpty((CharSequence)text)) {
                text = (String)text + DepthUnits.getUnits((char)this.units.charValue()).getAbr();
            }
        } else if (dbItem != null) {
            text = this.formatter.getFormattedString(dbItem, this.dps);
        }
        return text;
    }

    public Character getUnits() {
        return this.units;
    }

    public void setUnits(Character units) {
        this.units = units;
    }
}

