/*
 * Decompiled with CFR 0.152.
 */
package jsbugs.table;

import java.sql.SQLException;
import javax.swing.JComboBox;
import jsbugs.FrameJsbugs;
import jsbugs.table.AllowNullEditor;
import jsbugs.table.ComboEditor;
import jsbugs.table.FillableEditor;
import model3.EnvScheme;
import model3.SBdb;

public class EnvSchEditor
extends ComboEditor
implements FillableEditor,
AllowNullEditor {
    private boolean hasNull = false;

    public EnvSchEditor(SBdb sbdb) {
        super(new JComboBox());
        this.fill(sbdb);
    }

    @Override
    public final void fill(SBdb sbdb) {
        JComboBox combo = (JComboBox)this.editorComponent;
        combo.removeAllItems();
        if (this.hasNull) {
            combo.insertItemAt(null, 0);
        }
        try {
            for (EnvScheme sch : sbdb.getEnvSchemes()) {
                combo.addItem(sch);
            }
        }
        catch (SQLException sql) {
            FrameJsbugs.showStackError("SQL Error", sql, sbdb);
        }
    }

    @Override
    public void allowNullValue(boolean includeNull) {
        if (includeNull == this.hasNull) {
            return;
        }
        if (includeNull) {
            ((JComboBox)this.editorComponent).insertItemAt(null, 0);
        } else {
            ((JComboBox)this.editorComponent).removeItemAt(0);
        }
        this.hasNull = includeNull;
    }

    @Override
    public Object getCellEditorValue() {
        return ((JComboBox)this.getComponent()).getSelectedItem();
    }
}

