/*
 * Decompiled with CFR 0.152.
 */
package jsbugs.table;

import java.awt.Color;
import java.awt.Component;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;

public class HighlightingTable
extends JTable {
    private Map<CellPosition, Color> highlightedCells = new HashMap<CellPosition, Color>();

    public void addHighlight(CellPosition cell, Color color) {
        this.highlightedCells.put(cell, color);
    }

    public void clearHighlights() {
        this.highlightedCells = new HashMap<CellPosition, Color>();
    }

    @Override
    public Component prepareRenderer(TableCellRenderer renderer, int row, int col) {
        Component c = super.prepareRenderer(renderer, row, col);
        int[] selectedRows = this.getSelectedRows();
        Arrays.sort(selectedRows);
        if (Arrays.binarySearch(selectedRows, row) >= 0) {
            c.setBackground(this.getSelectionBackground());
            c.setForeground(this.getSelectionForeground());
        } else {
            int modelCol = this.convertColumnIndexToModel(col);
            int modelRow = this.convertRowIndexToModel(row);
            CellPosition pos = new CellPosition(modelCol, modelRow);
            c.setForeground(this.getForeground());
            if (this.highlightedCells.containsKey(pos)) {
                c.setBackground(this.highlightedCells.get(pos));
            } else {
                c.setBackground(this.getBackground());
            }
        }
        return c;
    }

    public record CellPosition(int column, int row) {
        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            CellPosition other = (CellPosition)obj;
            if (this.column != other.column) {
                return false;
            }
            return this.row == other.row;
        }
    }
}

