/*
 * Decompiled with CFR 0.152.
 */
package jsbugs.table;

import java.awt.Component;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import jsbugs.uiutil.icon.IconFactory;

public class ImageIconRenderer
extends DefaultTableCellRenderer {
    private final Icon icon;
    private final Icon selectedIcon;

    public ImageIconRenderer(Icon icon, Icon selectedIcon) {
        this.icon = icon;
        this.selectedIcon = selectedIcon;
        this.init();
    }

    public static ImageIconRenderer cameraImageIconRenderer() {
        Icon cameraOutlineIcon = IconFactory.getIcon("camera_bw.svg", 14);
        Icon cameraOutlineIconSelected = IconFactory.getIcon("camera_w.svg", 14);
        return new ImageIconRenderer(cameraOutlineIcon, cameraOutlineIconSelected);
    }

    private void init() {
        this.setOpaque(true);
        this.setHorizontalAlignment(0);
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        JLabel label = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        if (value != null && (value.getClass() == Boolean.class && ((Boolean)value).booleanValue() || value.getClass() == Integer.class && (Integer)value > 0)) {
            this.setIcon(isSelected ? this.selectedIcon : this.icon);
        } else {
            this.setIcon(null);
        }
        return label;
    }

    @Override
    public void setValue(Object value) {
        this.setText("");
    }
}

