/*
 * Decompiled with CFR 0.152.
 */
package jsbugs.table;

import com.stratadata.model3.taxon.Taxon;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.sql.SQLException;
import javax.swing.JFrame;
import javax.swing.JTable;
import jsbugs.DialogSelectEvent;
import jsbugs.DialogSelectTaxa;
import jsbugs.table.AllowNullEditor;
import jsbugs.table.ButtonEditor;
import jsbugs.userconnect.SbugsSession;
import jsbugs.util.ItemSelectorDialog;
import model3.Lastval;
import model3.SBEvent;
import model3.SBdb;
import model3.exception.SuppressedSQLException;
import util.SBException;

public abstract class ItemSelectorEditor<T>
extends ButtonEditor
implements AllowNullEditor {
    private final JFrame parent;
    private final SBdb sbdb;
    private T selection;

    public ItemSelectorEditor(JFrame parent, String nullText) {
        super(nullText);
        this.parent = parent;
        this.sbdb = SbugsSession.getDb();
    }

    public T getCellEditorValue() {
        return this.selection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.renderer.getButton()) {
            ItemSelectorDialog<T> dialog = null;
            try {
                dialog = this.getSelectionDialog(this.sbdb);
                dialog.setLocationRelativeTo(this.renderer);
                dialog.setVisible(true);
                if (dialog.isOK()) {
                    this.selection = dialog.getSelectedItem();
                    this.fireEditingStopped();
                }
                this.fireEditingCanceled();
            }
            catch (SQLException sql) {
                throw SuppressedSQLException.withoutRollback(sql);
            }
            catch (RuntimeException | SBException ex) {
                ex.printStackTrace();
            }
            finally {
                if (dialog != null) {
                    dialog.dispose();
                }
            }
        } else if (e.getSource() == this.renderer.getClearButton()) {
            this.selection = null;
            this.fireEditingStopped();
        }
    }

    abstract ItemSelectorDialog<T> getSelectionDialog(SBdb var1) throws SQLException, SBException;

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        this.selection = value;
        return this.renderer.getTableCellRendererComponent(table, value, isSelected, isSelected, row, column);
    }

    @Override
    public void allowNullValue(boolean canClear) {
        this.renderer.canClear(canClear);
    }

    public static ItemSelectorEditor<Taxon> taxonSelectorEditor(final JFrame parent, String nullText) {
        return new ItemSelectorEditor<Taxon>(parent, nullText){

            @Override
            ItemSelectorDialog<Taxon> getSelectionDialog(SBdb sbdb) throws SQLException {
                return new DialogSelectTaxa(parent, true, sbdb, Lastval.getInt(sbdb, "SYNSCHID", 1), true, null);
            }
        };
    }

    public static ItemSelectorEditor<SBEvent> eventSelectorEditor(final JFrame parent, String nullText) {
        return new ItemSelectorEditor<SBEvent>(parent, nullText){

            @Override
            ItemSelectorDialog<SBEvent> getSelectionDialog(SBdb sbdb) throws SQLException, SBException {
                return new DialogSelectEvent(parent, true, sbdb, false, true);
            }
        };
    }
}

