/*
 * Decompiled with CFR 0.152.
 */
package jsbugs.table;

import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.util.List;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import jsbchart.panel.PanelProperties;
import jsbchart.panel.spatial.LayerShapeProperties;
import jsbchart.panel.spatial.MapLabelAttribute;
import jsbchart.panel.spatial.ShapeDataStoreException;
import jsbchart.panel.spatial.ShapeDataStoreProvider;
import jsbugs.chart.spatial.DialogLabelAttributeSelect;
import jsbugs.table.ButtonEditor;

public class LabelAttributeEditor
extends ButtonEditor {
    private static Logger LOGGER = Logger.getLogger(LabelAttributeEditor.class.getName());
    private final Frame parentFrame;
    private final Supplier<PanelProperties> propertiesSupplier;
    private MapLabelAttribute attribute = null;

    public LabelAttributeEditor(Frame parentFrame, Supplier<PanelProperties> getPropertiesSupplier) {
        this.parentFrame = parentFrame;
        this.propertiesSupplier = getPropertiesSupplier;
        this.renderer.canClear(true);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.renderer.getButton()) {
            List<String> attributeNames = this.getAttributeNames();
            if (attributeNames == null || attributeNames.isEmpty()) {
                JOptionPane.showMessageDialog(this.parentFrame, "Shape store and feature type are not selected. Please ensure both are selected before selecting a label attribute.");
                this.fireEditingCanceled();
                return;
            }
            DialogLabelAttributeSelect dialog = new DialogLabelAttributeSelect(this.parentFrame, attributeNames);
            if (this.attribute != null) {
                dialog.setSelectedAttribute(this.attribute);
            }
            dialog.setLocationRelativeTo(this.parentFrame);
            dialog.setVisible(true);
            if (dialog.isOK()) {
                this.attribute = dialog.getAttribute();
                this.fireEditingStopped();
            } else {
                this.fireEditingCanceled();
            }
        } else if (e.getSource() == this.renderer.getClearButton()) {
            this.attribute = null;
            this.fireEditingStopped();
        }
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        if (value instanceof MapLabelAttribute) {
            MapLabelAttribute attValue;
            this.attribute = attValue = (MapLabelAttribute)value;
        }
        return this.renderer.getTableCellRendererComponent(table, value, isSelected, isSelected, row, column);
    }

    @Override
    public Object getCellEditorValue() {
        return this.attribute;
    }

    private List<String> getAttributeNames() {
        LayerShapeProperties lsp;
        List<String> attributeNames = null;
        PanelProperties props = this.propertiesSupplier.get();
        if (props instanceof LayerShapeProperties && (lsp = (LayerShapeProperties)props).getShapeStore() != null && lsp.getFeatureTypeName() != null) {
            try {
                attributeNames = ShapeDataStoreProvider.getFeatureTypeAttributes(lsp.getShapeStore(), lsp.getFeatureTypeName());
            }
            catch (IOException | ShapeDataStoreException ex) {
                LOGGER.log(Level.WARNING, "Error extracting attribute names from shapestore {0} and feature type {1}", new Object[]{lsp.getShapeStore(), lsp.getFeatureTypeName()});
            }
        }
        return attributeNames;
    }
}

