/*
 * Decompiled with CFR 0.152.
 */
package jsbugs.table;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.sql.SQLException;
import javax.swing.JFrame;
import javax.swing.JTable;
import jsbugs.DialogLogDef;
import jsbugs.table.AllowNullEditor;
import jsbugs.table.ButtonEditor;
import model3.LogDef;
import model3.SBdb;

public class LogDefEditor
extends ButtonEditor
implements AllowNullEditor {
    private final JFrame parent;
    private final SBdb sbdb;
    private LogDef logDef;
    private String abr;

    public LogDefEditor(JFrame parent, SBdb sbdb) {
        this.sbdb = sbdb;
        this.parent = parent;
    }

    @Override
    public Object getCellEditorValue() {
        return this.logDef;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.renderer.getButton()) {
            LogDef def;
            if (this.logDef == null) {
                try {
                    def = new LogDef(this.sbdb.getLogDef(this.abr));
                }
                catch (SQLException sql) {
                    sql.printStackTrace();
                    this.fireEditingCanceled();
                    return;
                }
            } else {
                def = this.logDef;
            }
            DialogLogDef dialog = new DialogLogDef(this.parent, true, def, null);
            dialog.setLocationRelativeTo(this.renderer);
            dialog.setVisible(true);
            if (dialog.isOK()) {
                this.logDef = def;
                this.fireEditingStopped();
            } else {
                this.fireEditingCanceled();
            }
        } else if (e.getSource() == this.renderer.getClearButton()) {
            this.logDef = null;
            this.fireEditingStopped();
        }
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        if (value instanceof LogDef) {
            this.logDef = new LogDef((LogDef)value);
            this.abr = null;
        } else {
            this.abr = value.toString();
            this.logDef = null;
            value = null;
        }
        return this.renderer.getTableCellRendererComponent(table, value, isSelected, isSelected, row, column);
    }

    @Override
    public void allowNullValue(boolean canClear) {
        this.renderer.canClear(canClear);
    }
}

