/*
 * Decompiled with CFR 0.152.
 */
package jsbugs.table;

import java.awt.Component;
import javax.swing.AbstractCellEditor;
import javax.swing.JTable;
import javax.swing.table.TableCellEditor;
import jsbchart.graphics.text.MapFill;
import jsbugs.chart.spatial.DialogMapFillSelect;
import jsbugs.table.MapFillButtonRenderer;

public class MapFillButtonEditor
extends AbstractCellEditor
implements TableCellEditor {
    private final MapFillButtonRenderer renderer = new MapFillButtonRenderer();

    public MapFillButtonEditor() {
        this.renderer.getButton().addActionListener(e -> this.buttonPressed());
    }

    private void buttonPressed() {
        DialogMapFillSelect dialog = new DialogMapFillSelect(null, true);
        if (this.renderer.getFill() != null) {
            dialog.setFill(this.renderer.getFill());
        }
        dialog.setLocationRelativeTo(null);
        dialog.setVisible(true);
        if (dialog.isOK()) {
            this.renderer.setFill(dialog.getFill());
            this.fireEditingStopped();
        } else {
            this.fireEditingCanceled();
        }
        dialog.dispose();
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        if (value instanceof MapFill) {
            MapFill fill = (MapFill)value;
            this.renderer.setFill(fill);
        }
        return this.renderer;
    }

    @Override
    public Object getCellEditorValue() {
        return this.renderer.getFill();
    }
}

