/*
 * Decompiled with CFR 0.152.
 */
package jsbugs.table;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.DefaultCellEditor;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.TableCellEditor;
import jsbugs.table.NullableRenderer;

public class NullableStringEditor
extends DefaultCellEditor
implements ActionListener,
TableCellEditor {
    final NullableRenderer renderer;

    public NullableStringEditor(String nullText) {
        super(new JTextField());
        this.renderer = new NullableRenderer(nullText);
        this.init();
    }

    private void init() {
        this.setClickCountToStart(1);
        this.renderer.button.addActionListener(this);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.delegate.setValue(null);
        this.fireEditingStopped();
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        JPanel panel = (JPanel)this.renderer.getTableCellRendererComponent(table, value, isSelected, isSelected, row, column);
        this.delegate.setValue(value);
        panel.removeAll();
        panel.add(this.editorComponent);
        panel.add(Box.createHorizontalGlue());
        panel.add(this.renderer.button);
        return panel;
    }

    @Override
    public Object getCellEditorValue() {
        Object o = this.delegate.getCellEditorValue();
        if (o.toString().isEmpty()) {
            return null;
        }
        return o;
    }
}

