/*
 * Decompiled with CFR 0.152.
 */
package jsbugs.table;

import com.stratadata.model3.Discipline;
import com.stratadata.model3.taxon.Category;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.swing.JFrame;
import javax.swing.JTable;
import jsbugs.chart.properties.taxon.DialogCategorySelect;
import jsbugs.table.AllowNullEditor;
import jsbugs.table.ButtonEditor;
import jsbugs.userconnect.SbugsSession;
import model3.SBdb;

public class PanelEventsCatFilterEditor
extends ButtonEditor
implements AllowNullEditor {
    private final JFrame parent;
    private Discipline disc;
    private final SBdb sbdb;
    private List<Category> filter_cat = new LinkedList<Category>();

    public PanelEventsCatFilterEditor(JFrame parent, String nullText) {
        super(nullText);
        this.parent = parent;
        this.sbdb = SbugsSession.getDb();
    }

    @Override
    public Object getCellEditorValue() {
        if (this.filter_cat.isEmpty()) {
            return null;
        }
        return new HashSet<Category>(this.filter_cat);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.renderer.getButton()) {
            DialogCategorySelect dialog = null;
            try {
                List filteredCats = this.sbdb.getCategoryService().getCategoryList().stream().filter(category -> this.disc == null || category.getDiscipline() == this.disc).collect(Collectors.toCollection(LinkedList::new));
                dialog = new DialogCategorySelect(this.parent, true, true);
                dialog.setLocationRelativeTo(this.renderer);
                dialog.setCategories(filteredCats, this.sbdb.getCategoryService().getCategoryList());
                if (this.filter_cat != null && !this.filter_cat.isEmpty()) {
                    LinkedList<Category> originalSelection = new LinkedList<Category>(this.filter_cat);
                    dialog.setSelectedCategories(originalSelection);
                }
                dialog.setVisible(true);
                if (dialog.isOK()) {
                    this.filter_cat.clear();
                    this.filter_cat.addAll(dialog.getCategories());
                    this.fireEditingStopped();
                }
                this.fireEditingCanceled();
            }
            catch (RuntimeException ex) {
                ex.printStackTrace();
            }
            finally {
                if (dialog != null) {
                    dialog.dispose();
                }
            }
        } else if (e.getSource() == this.renderer.getClearButton()) {
            this.filter_cat = null;
            this.fireEditingStopped();
        }
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        Set cats = (Set)value;
        this.filter_cat.clear();
        if (cats != null) {
            this.filter_cat.addAll(cats);
        }
        return this.renderer.getTableCellRendererComponent(table, value, isSelected, isSelected, row, column);
    }

    @Override
    public void allowNullValue(boolean canClear) {
        this.renderer.canClear(canClear);
    }
}

