/*
 * Decompiled with CFR 0.152.
 */
package jsbugs.table;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.image.BufferedImage;
import java.text.DecimalFormat;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.border.EmptyBorder;
import javax.swing.table.TableCellRenderer;
import jsbugs.table.SampleDistance;
import util.DepthUnits;
import util.DepthUtils;
import util.ImageUtils;

public class SampleDistanceRenderer
implements TableCellRenderer {
    private static final Color SELECTED_BG_COLOUR = new Color(51, 153, 255);
    private static final Color SELECTED_FG_COLOUR = Color.WHITE;
    private static Color HIGHLIGHT_COLOUR = new Color(255, 255, 204);
    private char units;

    public SampleDistanceRenderer(char units) {
        this.units = units;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        if (value == null || !(value instanceof SampleDistance)) {
            return this.buildSimpleLabelForObject(value, isSelected);
        }
        SampleDistance sd = (SampleDistance)value;
        JPanel p = new JPanel(new BorderLayout());
        JLabel label = new JLabel(this.getCellText(sd), 2);
        if (isSelected) {
            label.setBackground(table.getSelectionBackground());
            label.setForeground(table.getSelectionForeground());
        }
        label.setBorder(new EmptyBorder(0, 0, 0, 10));
        p.add((Component)label, "East");
        ImageIcon icon = null;
        if (sd.getDistance() > 0.0) {
            icon = new ImageIcon(this.getClass().getResource("/resources/icon/arrow_down.gif"), "Down arrow");
        } else if (sd.getDistance() < 0.0) {
            icon = new ImageIcon(this.getClass().getResource("/resources/icon/arrow_up.gif"), "Up arrow");
        }
        if (icon != null) {
            if (isSelected) {
                BufferedImage bi = ImageUtils.convertIconToIntARGBBufferedImage((ImageIcon)icon);
                ImageUtils.replaceColourInImage((BufferedImage)bi, (Color)Color.BLACK, (Color)Color.WHITE);
                icon = new ImageIcon(bi);
            }
            JLabel iconLabel = new JLabel(icon, 4);
            iconLabel.setBorder(new EmptyBorder(0, 10, 0, 0));
            p.add((Component)iconLabel, "West");
        }
        if (isSelected) {
            p.setBackground(table.getSelectionBackground());
        } else if (sd.getMultipleNodes() && sd.getDistance() != 0.0) {
            p.setBackground(HIGHLIGHT_COLOUR);
        } else {
            p.setBackground(Color.WHITE);
        }
        return p;
    }

    private String getCellText(SampleDistance sd) {
        if (sd.SingleSampleFound()) {
            Object text = "";
            if (sd.getDistance() != 0.0) {
                DecimalFormat df = new DecimalFormat("+#.##;-#.##");
                double detph = DepthUtils.convFromM((double)sd.getDistance(), (char)this.units);
                text = (String)text + df.format(detph) + DepthUnits.getUnits((char)this.units).getAbr() + " ";
            }
            text = (String)text + "[" + sd.getSample().toString(this.units, true, true, false) + "]";
            return text;
        }
        return "Between two samples";
    }

    private Component buildSimpleLabelForObject(Object value, boolean selected) {
        JLabel label = new JLabel("");
        if (selected) {
            label.setBackground(SELECTED_BG_COLOUR);
            label.setForeground(SELECTED_FG_COLOUR);
        }
        if (value != null) {
            label.setText(value.toString());
        }
        return label;
    }

    public char getUnits() {
        return this.units;
    }

    public void setUnits(char units) {
        this.units = units;
    }
}

