/*
 * Decompiled with CFR 0.152.
 */
package jsbugs.table;

import java.sql.SQLException;
import javax.swing.DefaultComboBoxModel;
import javax.swing.InputVerifier;
import javax.swing.JComboBox;
import jsbchart.block.BlockProperties;
import jsbchart.block.SchemeBlock;
import jsbugs.table.ComboEditor;
import model3.SBdb;
import util.AgeFormat;
import util.SbugsInputVerifier;

public class ScaleEditor
extends ComboEditor {
    private final SbugsInputVerifier depthVerifier = new SbugsInputVerifier(1.0f, 100000.0f, 2000.0f);
    private final SbugsInputVerifier ageVerifier = new SbugsInputVerifier((float)((double)0.1f / AgeFormat.MA.getMultiplyer()), (float)(1000.0 / AgeFormat.MA.getMultiplyer()), 5.0f);
    private float scale;
    private BlockProperties.ScaleType scaleType;

    public ScaleEditor(JComboBox combo) {
        super(combo);
        combo.setEditable(true);
    }

    public void setScale(float scale, SBdb sbdb, BlockProperties.ScaleType scaleType) throws SQLException {
        JComboBox combo = (JComboBox)this.editorComponent;
        this.scale = scale;
        if (this.scaleType != scaleType) {
            switch (scaleType) {
                case MD: 
                case TVD: 
                case SUBSIDENCE: {
                    sbdb.getChartScales((DefaultComboBoxModel)combo.getModel());
                    ((JComboBox)this.editorComponent).setInputVerifier((InputVerifier)this.depthVerifier);
                    break;
                }
                case AGE: {
                    SchemeBlock.fillScaleCombo((DefaultComboBoxModel)combo.getModel());
                    ((JComboBox)this.editorComponent).setInputVerifier((InputVerifier)this.ageVerifier);
                }
            }
            this.scaleType = scaleType;
        }
        DefaultComboBoxModel model = (DefaultComboBoxModel)((JComboBox)this.editorComponent).getModel();
        String sScale = switch (scaleType) {
            case BlockProperties.ScaleType.AGE -> Float.toString(scale);
            default -> Integer.toString((int)scale);
        };
        if (model.getIndexOf(sScale) < 0) {
            model.addElement(sScale);
        }
        model.setSelectedItem(sScale);
    }

    @Override
    public Object getCellEditorValue() {
        JComboBox combo = (JComboBox)this.editorComponent;
        Object o = combo.getSelectedItem();
        try {
            float s = Float.parseFloat(o.toString());
            if (this.scaleType != BlockProperties.ScaleType.AGE) {
                s = (int)s;
            }
            this.scale = s;
        }
        catch (NumberFormatException e) {
            System.out.println(e.getMessage() + " in ScaleEditor");
        }
        return Float.valueOf(this.scale);
    }
}

