/*
 * Decompiled with CFR 0.152.
 */
package jsbugs.table;

import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.swing.JFrame;
import javax.swing.JTable;
import jsbugs.DialogSelectIGDType;
import jsbugs.DialogSelectScheme;
import jsbugs.table.ButtonEditor;
import model3.IGDScheme;
import model3.SBdb;

public class SchemeButtonEditor
extends ButtonEditor {
    private final JFrame parent;
    private final SBdb sbdb;
    private IGDScheme scheme;

    public SchemeButtonEditor(JFrame parent, SBdb sbdb) {
        this.parent = parent;
        this.sbdb = sbdb;
    }

    @Override
    public Object getCellEditorValue() {
        return this.scheme;
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        this.scheme = (IGDScheme)value;
        return this.renderer.getTableCellRendererComponent(table, value, isSelected, isSelected, row, column);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        block7: {
            if (e.getSource() == this.renderer.getButton()) {
                DialogSelectIGDType typeDialog = new DialogSelectIGDType(this.parent, true, false, false, false, false);
                typeDialog.setLocationRelativeTo(this.parent);
                typeDialog.setVisible(true);
                if (!typeDialog.isOK()) {
                    this.scheme = null;
                    this.fireEditingCanceled();
                    return;
                }
                try {
                    DialogSelectScheme dialog = new DialogSelectScheme(this.parent, true, this.sbdb, typeDialog.getIgdType());
                    dialog.setLocationRelativeTo(this.parent);
                    dialog.setVisible(true);
                    if (dialog.getSelection() != null) {
                        this.scheme = dialog.getSelection();
                        this.fireEditingStopped();
                        break block7;
                    }
                    this.scheme = null;
                    this.fireEditingCanceled();
                }
                catch (Exception ex) {
                    this.scheme = null;
                    ex.printStackTrace();
                    this.fireEditingCanceled();
                }
            } else if (e.getSource() == this.renderer.getClearButton()) {
                this.scheme = null;
                this.fireEditingStopped();
            }
        }
    }
}

