/*
 * Decompiled with CFR 0.152.
 */
package jsbugs.table;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import jsbchart.util.colour.ColourSpectrum;
import jsbugs.table.TableCellUtils;

public class SpectrumRenderer
extends JPanel
implements TableCellRenderer {
    private Color[] colors;
    private final JButton button;
    private Color backgroundColour = Color.WHITE;

    public SpectrumRenderer() {
        this.setLayout(new BoxLayout(this, 0));
        this.button = new JButton("...");
        TableCellUtils.setButtonDimensions(this.button);
        this.add(Box.createHorizontalGlue());
        this.add(this.button);
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        if (value instanceof ColourSpectrum) {
            ColourSpectrum spectrum = (ColourSpectrum)value;
            this.colors = spectrum.getColours();
        } else {
            this.colors = null;
        }
        this.backgroundColour = isSelected ? table.getSelectionBackground() : table.getBackground();
        return this;
    }

    @Override
    protected void paintComponent(Graphics g) {
        g.setColor(this.backgroundColour);
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        if (this.colors == null) {
            return;
        }
        int thisWidth = this.getWidth() - this.button.getWidth();
        int sectionWidth = thisWidth / 12;
        int margin = thisWidth - sectionWidth * 12;
        margin /= 2;
        for (int i = 0; i < 12; ++i) {
            g.setColor(this.colors[i]);
            g.fillRect(margin + i * sectionWidth, margin, sectionWidth, this.getHeight() - margin * 2);
        }
    }

    JButton getButton() {
        return this.button;
    }
}

