/*
 * Decompiled with CFR 0.152.
 */
package jsbugs.table;

import com.stratadata.model3.taxon.Taxon;
import java.awt.Color;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.plaf.basic.BasicLabelUI;
import javax.swing.table.TableCellRenderer;
import jsbugs.table.TableCellUtils;
import jsbugs.uiutil.icon.IconFactory;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.apache.commons.text.WordUtils;

public class TaxonNameRenderer
extends JPanel
implements TableCellRenderer,
ListCellRenderer<Taxon> {
    private static final Icon referencesIcon = IconFactory.getIcon("scroll.svg", 15);
    private final JLabel label = new JLabel();
    private final JButton referencesButton = new JButton(referencesIcon);
    private final Predicate<Taxon> boldFontPredicate;
    private Rectangle cellRect;

    public TaxonNameRenderer(Predicate<Taxon> boldFontPredicate) {
        this.setLayout(new BoxLayout(this, 0));
        this.referencesButton.setBorderPainted(false);
        this.referencesButton.setContentAreaFilled(false);
        this.label.setUI(new BasicLabelUI(this){
            private final Pattern pattern;
            {
                Objects.requireNonNull(this$0);
                this.pattern = Pattern.compile("<(.*?)>");
            }

            @Override
            protected String layoutCL(JLabel label, FontMetrics fontMetrics, String text, Icon icon, Rectangle viewR, Rectangle iconR, Rectangle textR) {
                if ((text = StringEscapeUtils.unescapeXml((String)text)).startsWith("<html>")) {
                    String stripped = this.pattern.matcher(text).replaceAll("");
                    int before = stripped.length();
                    label.setText(stripped);
                    String s = super.layoutCL(label, fontMetrics, stripped, icon, viewR, iconR, textR);
                    int after = s.length();
                    if (after < before) {
                        Matcher m = this.pattern.matcher(text);
                        int totalTagChars = 0;
                        String toReturn = null;
                        while (m.find()) {
                            int start = m.start();
                            if (start - totalTagChars > after) {
                                int diff = start - totalTagChars - after;
                                toReturn = text.substring(0, Math.max(start - diff - 3, 0)).trim() + "...";
                            }
                            int end = m.end();
                            if (toReturn != null) {
                                toReturn = toReturn + text.substring(start, end);
                                continue;
                            }
                            totalTagChars += end - start;
                        }
                        label.setText(toReturn);
                        return super.layoutCL(label, fontMetrics, toReturn, icon, viewR, iconR, textR);
                    }
                    label.setText(text);
                }
                return super.layoutCL(label, fontMetrics, text, icon, viewR, iconR, textR);
            }
        });
        this.boldFontPredicate = Objects.requireNonNull(boldFontPredicate);
    }

    public TaxonNameRenderer() {
        this.setLayout(new BoxLayout(this, 0));
        this.referencesButton.setBorderPainted(false);
        this.referencesButton.setContentAreaFilled(false);
        this.label.setUI(new /* invalid duplicate definition of identical inner class */);
        this.boldFontPredicate = taxon -> false;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        this.cellRect = table.getCellRect(row, column, true);
        return this.getRendererComponent(value, isSelected, table.getSelectionBackground(), table.getBackground(), table.getSelectionForeground(), table.getForeground());
    }

    @Override
    public Component getListCellRendererComponent(JList<? extends Taxon> list, Taxon value, int index, boolean isSelected, boolean cellHasFocus) {
        return this.getRendererComponent(value, isSelected, list.getSelectionBackground(), list.getBackground(), list.getSelectionForeground(), list.getForeground());
    }

    private Component getRendererComponent(Object value, boolean isSelected, Color selectionBackground, Color background, Color selectionForeground, Color foreground) {
        this.setBackground(isSelected ? selectionBackground : background);
        this.label.setForeground(isSelected ? selectionForeground : foreground);
        String text = "";
        String referenceTooltip = null;
        if (value != null) {
            if (value instanceof model3.Taxon) {
                model3.Taxon taxon = (model3.Taxon)value;
                Taxon taxonCopy = taxon.getTaxonCopy();
                text = TaxonNameRenderer.getHtmlFormattedTaxonName(taxonCopy, this.boldFontPredicate.test(taxonCopy));
            } else if (value instanceof Taxon) {
                Taxon domainTaxon = (Taxon)value;
                text = TaxonNameRenderer.getHtmlFormattedTaxonName(domainTaxon, this.boldFontPredicate.test(domainTaxon));
                referenceTooltip = this.getRefNotesTooltip(domainTaxon);
            } else {
                text = value.toString();
            }
        }
        this.label.setBorder(TableCellUtils.getEmptyBorder());
        this.label.setText(text);
        this.referencesButton.setToolTipText(referenceTooltip);
        this.removeAll();
        this.add(this.label);
        if (!StringUtils.isBlank((CharSequence)referenceTooltip)) {
            this.add(Box.createHorizontalGlue());
            this.add(this.referencesButton);
        }
        return this;
    }

    private String getRefNotesTooltip(Taxon taxon) {
        String fragment = TaxonNameRenderer.getRefNotesTooltipHtmlFragment(taxon.getReference(), taxon.getNotes());
        if (fragment == null) {
            return null;
        }
        return "<html>" + fragment + "</html>";
    }

    public static String getRefNotesTooltipHtmlFragment(String reference, String notes) {
        if (StringUtils.isBlank((CharSequence)reference) && StringUtils.isBlank((CharSequence)notes)) {
            return null;
        }
        ArrayList<String> list = new ArrayList<String>();
        if (!StringUtils.isBlank((CharSequence)reference)) {
            list.add(WordUtils.wrap((String)("<b>Reference:</b> " + StringEscapeUtils.escapeHtml4((String)reference)), (int)100, (String)"<br>", (boolean)false));
        }
        if (!StringUtils.isBlank((CharSequence)notes)) {
            list.add(WordUtils.wrap((String)("<b>Notes:</b> " + StringEscapeUtils.escapeHtml4((String)notes)), (int)100, (String)"<br>", (boolean)false));
        }
        return StringUtils.join(list, (String)"<br>");
    }

    @Override
    public String getToolTipText(MouseEvent event) {
        if (this.cellRect == null) {
            return null;
        }
        this.setBounds(this.cellRect);
        this.validate();
        Point p = event.getPoint();
        Component c = SwingUtilities.getDeepestComponentAt(this, p.x, p.y);
        if (!(c instanceof JComponent) || c == this) {
            return null;
        }
        p = SwingUtilities.convertPoint(this, p, c);
        MouseEvent newEvent = new MouseEvent(c, event.getID(), event.getWhen(), event.getModifiersEx(), p.x, p.y, event.getXOnScreen(), event.getYOnScreen(), event.getClickCount(), event.isPopupTrigger(), 0);
        return ((JComponent)c).getToolTipText(newEvent);
    }

    public static String getHtmlFormattedTaxonName(Taxon taxon, boolean boldFont) {
        Object text = taxon.toString(true, false);
        String author = taxon.getAuthorString(true).trim();
        if (!author.isEmpty()) {
            author = StringEscapeUtils.escapeHtml4((String)author);
            text = StringEscapeUtils.escapeHtml4((String)text);
            int start = ((String)text).lastIndexOf(author);
            int end = start + author.length();
            text = "<html>" + (boldFont ? "<b>" : "") + ((String)text).substring(0, start) + "<font color='gray'>" + ((String)text).substring(start, end) + "</font>" + ((String)text).substring(end) + (boldFont ? "</b>" : "") + "</html>";
            text = ((String)text).replaceAll("&lt;", "&LT;");
        } else if (boldFont) {
            text = StringEscapeUtils.escapeHtml4((String)text);
            text = ((String)text).replaceAll("&lt;", "&LT;");
            text = "<html><b>" + (String)text + "</b></html>";
        }
        return text;
    }
}

