/*
 * Decompiled with CFR 0.152.
 */
package jsbugs.table;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.util.Objects;
import java.util.Optional;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JToolBar;
import jsbchart.core.PanelTemplate;
import jsbchart.panel.PanelType;
import jsbugs.table.RolloverMouseAdapter;
import jsbugs.table.TitleRenderer;
import jsbugs.uiutil.icon.IconFactory;

public class TitleButtonRenderer
extends TitleRenderer {
    public static final int BUTTON_SIZE = 24;
    private static final Icon saveIcon = IconFactory.getIcon("save24");
    private static final Icon saveRollIcon = IconFactory.getIcon("save24rollover");
    private static final Icon restoreIcon = IconFactory.getIcon("restore24");
    private static final Icon restoreRollIcon = IconFactory.getIcon("restore24");
    private final JPanel panel;
    private final JToolBar toolbar;
    private final JButton button;
    private final RolloverMouseAdapter adapter;

    public TitleButtonRenderer(RolloverMouseAdapter adapter, Color background, Color foreground) {
        super(background, foreground);
        this.adapter = adapter;
        this.panel = new JPanel();
        this.panel.setLayout(new BoxLayout(this.panel, 0));
        this.button = new JButton(saveIcon);
        this.button.setRolloverEnabled(true);
        this.button.setMaximumSize(new Dimension(24, 100));
        this.button.setMinimumSize(new Dimension(24, 100));
        this.button.setPreferredSize(new Dimension(24, 10));
        this.button.setOpaque(false);
        this.button.setBorderPainted(false);
        this.toolbar = new JToolBar();
        this.toolbar.setOpaque(false);
        this.toolbar.setFloatable(false);
        this.toolbar.add(this.button);
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        Optional<PanelTemplate> panelTemplate = Optional.ofNullable(value instanceof PanelTemplate ? (PanelTemplate)value : null);
        boolean isEditing = false;
        Object labelText = Objects.toString(value);
        if (panelTemplate.isPresent()) {
            PanelTemplate template = panelTemplate.get();
            labelText = template.getType().typeString() + " properties";
            if (template.isVisible()) {
                labelText = (String)labelText + " [" + template.getName() + "]";
            }
            isEditing = template.isEditing();
        }
        JLabel oLabel = (JLabel)super.getTableCellRendererComponent(table, labelText, isSelected, hasFocus, row, column);
        Dimension d = new Dimension(table.getWidth() - this.toolbar.getPreferredSize().width - 1, 16);
        oLabel.setPreferredSize(d);
        this.panel.setBackground(oLabel.getBackground());
        this.panel.removeAll();
        this.panel.add(oLabel);
        if (isEditing) {
            oLabel.setFont(oLabel.getFont().deriveFont(1));
        }
        if (panelTemplate.isPresent()) {
            PanelTemplate template = panelTemplate.get();
            oLabel.setIcon(template.getType().getIcon());
            if (isEditing && !PanelType.isTaxonPanel(template.getType())) {
                this.panel.add(Box.createHorizontalGlue());
                this.panel.add(this.toolbar);
                if (template.isVisible()) {
                    this.button.setIcon(this.adapter.isRolloverCell(row, column) ? saveRollIcon : saveIcon);
                } else {
                    this.button.setIcon(this.adapter.isRolloverCell(row, column) ? restoreRollIcon : restoreIcon);
                }
            }
        }
        return this.panel;
    }
}

