/*
 * Decompiled with CFR 0.152.
 */
package jsbugs.uiutil;

import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;
import jsbugs.uiutil.IDocumentInsertErrorListener;

public class ByteLimitedLengthDocument
extends PlainDocument {
    private static final Logger LOGGER = Logger.getLogger(ByteLimitedLengthDocument.class.getName());
    private final int maxByteLength;
    private final String encoding;
    private IDocumentInsertErrorListener listener = null;

    public ByteLimitedLengthDocument(int maxByteLength, String encoding) {
        this.encoding = encoding;
        this.maxByteLength = maxByteLength;
    }

    public ByteLimitedLengthDocument(int maxLength, String encoding, IDocumentInsertErrorListener listener) {
        this.maxByteLength = maxLength;
        this.encoding = encoding;
        this.listener = listener;
    }

    @Override
    public void insertString(int offset, String str, AttributeSet attr) throws BadLocationException {
        int newBytes;
        int existingBytes;
        if (str == null) {
            return;
        }
        try {
            existingBytes = this.getContent().getString(0, this.getLength()).getBytes(this.encoding).length;
            newBytes = str.getBytes(this.encoding).length;
        }
        catch (UnsupportedEncodingException e) {
            LOGGER.log(Level.WARNING, "Error while trying to decode string.", e);
            existingBytes = this.getLength();
            newBytes = str.length();
        }
        if (existingBytes + newBytes <= this.maxByteLength) {
            super.insertString(offset, str, attr);
        } else if (existingBytes < this.maxByteLength) {
            int space = this.maxByteLength - existingBytes;
            try {
                String reducedString = this.truncateStrToBytes(str, space);
                super.insertString(offset, reducedString, attr);
            }
            catch (CharacterCodingException e) {
                LOGGER.log(Level.WARNING, "Error splitting decoding string.", e);
            }
            this.notifyOfInsertError();
        } else {
            this.notifyOfInsertError();
        }
    }

    private String truncateStrToBytes(String str, int bytesToReturn) throws CharacterCodingException {
        Charset CHARSET = Charset.forName(this.encoding);
        byte[] bytes = str.getBytes(CHARSET);
        CharsetDecoder decoder = CHARSET.newDecoder();
        decoder.onMalformedInput(CodingErrorAction.IGNORE);
        decoder.reset();
        CharBuffer decoded = decoder.decode(ByteBuffer.wrap(bytes, 0, bytesToReturn));
        return decoded.toString();
    }

    private void notifyOfInsertError() {
        if (this.listener != null) {
            this.listener.notifyOfInsertError();
        }
    }
}

