/*
 * Decompiled with CFR 0.152.
 */
package jsbugs.uiutil;

import java.util.Objects;
import javax.swing.JComboBox;

public class ComboboxItem<T> {
    private final T value;
    private final String label;

    public ComboboxItem(T value, String label) {
        this.value = value;
        this.label = label;
    }

    public T getValue() {
        return this.value;
    }

    public String getLabel() {
        return this.label;
    }

    public String toString() {
        return this.label;
    }

    public int hashCode() {
        int hash = 5;
        hash = 97 * hash + Objects.hashCode(this.value);
        hash = 97 * hash + Objects.hashCode(this.label);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ComboboxItem other = (ComboboxItem)obj;
        if (!Objects.equals(this.label, other.label)) {
            return false;
        }
        return Objects.equals(this.value, other.value);
    }

    public static <T> void setComboBoxItemByValue(JComboBox combo, T value) {
        for (int i = 0; i < combo.getItemCount(); ++i) {
            Object o = combo.getItemAt(i);
            if (o == null || !(o instanceof ComboboxItem)) continue;
            ComboboxItem item = (ComboboxItem)o;
            if (value == null && item.getValue() == null) {
                combo.setSelectedIndex(i);
                break;
            }
            if (value != item.getValue()) continue;
            combo.setSelectedIndex(i);
            break;
        }
    }
}

