/*
 * Decompiled with CFR 0.152.
 */
package jsbugs.uiutil;

import com.stratadata.model3.image.ImageLoader;
import com.stratadata.model3.image.ImageRecordService;
import com.stratadata.model3.image.ImageSet;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Point;
import java.util.HashMap;
import javax.swing.ImageIcon;
import javax.swing.JTable;
import jsbugs.uiutil.ImageTooltip;

public class ImageCacheTooltip
extends ImageTooltip {
    private static final int MAX_IMG_SIZE = 150;
    private final ImageRecordService imageRecordService;
    private final ImageLoader imageLoader;
    private final JTable jTable;
    private final int imageColumnIndex;
    private final HashMap<Integer, ImageIcon> images = new HashMap();

    private ImageIcon getImageIcon(int imageSetID) {
        if (imageSetID == 0) {
            return null;
        }
        if (this.images.containsKey(imageSetID)) {
            return this.images.get(imageSetID);
        }
        ImageSet imageSet = new ImageSet(imageSetID);
        Image image = imageSet.getFirstImage(this.imageRecordService, this.imageLoader, new Dimension(150, 150));
        if (image == null) {
            return null;
        }
        ImageIcon imageIcon = new ImageIcon(image);
        this.images.put(imageSetID, imageIcon);
        return imageIcon;
    }

    public ImageCacheTooltip(JTable jTable, int imageColumnIndex, ImageRecordService imageRecordService, ImageLoader imageLoader) {
        super(jTable);
        this.jTable = jTable;
        this.imageColumnIndex = imageColumnIndex;
        this.imageRecordService = imageRecordService;
        this.imageLoader = imageLoader;
    }

    @Override
    protected void refreshBalloonTip(Point p) {
        ImageIcon image = null;
        Point positionerLocation = new Point();
        int row = this.jTable.rowAtPoint(p);
        int column = this.jTable.columnAtPoint(p);
        if (row > -1 && column > -1) {
            Object value;
            int index = this.jTable.convertRowIndexToModel(row);
            if (this.jTable.convertColumnIndexToModel(column) == this.imageColumnIndex && (value = this.jTable.getValueAt(row, column)) instanceof Integer) {
                Integer imageSetID = (Integer)value;
                image = this.getImageIcon(imageSetID);
                positionerLocation.x = p.x + 5;
                positionerLocation.y = p.y + 5;
            }
        }
        super.updateTip(image, positionerLocation);
    }

    public void clearImageSet(int imageSetID) {
        this.images.remove(imageSetID);
    }
}

