/*
 * Decompiled with CFR 0.152.
 */
package jsbugs.uiutil;

import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;
import jsbugs.uiutil.IDocumentInsertErrorListener;

public class LimitedLengthDocument
extends PlainDocument {
    private final int maxLength;
    private IDocumentInsertErrorListener listener = null;

    public LimitedLengthDocument(int maxLength) {
        this.maxLength = maxLength;
    }

    public LimitedLengthDocument(int maxLength, IDocumentInsertErrorListener listener) {
        this.maxLength = maxLength;
        this.listener = listener;
    }

    @Override
    public void insertString(int offset, String str, AttributeSet attr) throws BadLocationException {
        if (str == null) {
            return;
        }
        if (this.getLength() + str.length() <= this.maxLength) {
            super.insertString(offset, str, attr);
        } else if (this.getLength() < this.maxLength) {
            int space = this.maxLength - this.getLength();
            super.insertString(offset, str.substring(0, space), attr);
            this.notifyOfInsertError();
        } else {
            this.notifyOfInsertError();
        }
    }

    private void notifyOfInsertError() {
        if (this.listener != null) {
            this.listener.notifyOfInsertError();
        }
    }
}

