/*
 * Decompiled with CFR 0.152.
 */
package jsbugs.uiutil;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import jsbchart.core.LithologyPattern;
import jsbchart.graphics.SBGraphics;
import model3.Lithology;

public class LithologyComboRenderer
extends JLabel
implements ListCellRenderer {
    private Font warningFont;
    HashMap<Lithology, ImageIcon> iconCache = new HashMap();
    private int width = 60;
    private int height = 30;

    public LithologyComboRenderer() {
        this.setOpaque(true);
        this.setHorizontalAlignment(2);
        this.setVerticalAlignment(0);
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        if (isSelected) {
            this.setBackground(list.getSelectionBackground());
            this.setForeground(list.getSelectionForeground());
        } else {
            this.setBackground(list.getBackground());
            this.setForeground(list.getForeground());
        }
        if (value == null) {
            if (!this.iconCache.containsKey(null)) {
                this.iconCache.put(null, this.makeIcon(null));
            }
            ImageIcon icon = this.iconCache.get(null);
            this.setText("(empty)");
            this.setIcon(icon);
        } else if (value instanceof Lithology) {
            Lithology l = (Lithology)value;
            if (!this.iconCache.containsKey(value)) {
                this.iconCache.put(l, this.makeIcon(l));
            }
            ImageIcon icon = this.iconCache.get(l);
            String text = l.toString();
            this.setIcon(icon);
            this.setFont(list.getFont());
            if (icon != null) {
                this.setText(text);
            } else {
                this.setWarningText(text + " (no image available)", list.getFont());
            }
        } else if (value != null) {
            this.setText(value.toString());
        }
        return this;
    }

    protected void setWarningText(String uhOhText, Font normalFont) {
        if (this.warningFont == null) {
            this.warningFont = normalFont.deriveFont(2);
        }
        this.setFont(this.warningFont);
        this.setText(uhOhText);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ImageIcon makeIcon(Lithology lithology) {
        BufferedImage bufferedImage = new BufferedImage(this.width, this.height, 1);
        Graphics2D g2d = null;
        try {
            g2d = bufferedImage.createGraphics();
            if (lithology != null) {
                AffineTransform tnf = new AffineTransform();
                tnf.scale(0.028346456587314606, 0.028346456587314606);
                g2d.transform(tnf);
                LithologyPattern.draw(lithology, new SBGraphics(g2d, null, true, true), 0.0f, 0.0f, (float)this.width / 2.8346457f, (float)this.height / 2.8346457f, false, false);
            } else {
                g2d.setColor(Color.WHITE);
                g2d.fillRect(0, 0, this.width, this.height);
            }
        }
        finally {
            if (g2d != null) {
                g2d.dispose();
            }
        }
        return new ImageIcon(bufferedImage);
    }
}

