/*
 * Decompiled with CFR 0.152.
 */
package jsbugs.uiutil;

import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Objects;
import javax.swing.AbstractAction;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import jsbugs.uiutil.SBTabbedPane;

public class TabTitleContextMenuMouseListener
extends MouseAdapter {
    private int indexUnderPopupTrigger = -1;
    private final SBTabbedPane tabbedPane;
    private final JPopupMenu popup;

    public TabTitleContextMenuMouseListener(SBTabbedPane tabbedPane, boolean includeCloseAll) {
        this.tabbedPane = tabbedPane;
        this.popup = this.buildTabContextMenu(includeCloseAll);
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.updateIndexUnderPopupTrigger(e.getX(), e.getY());
            this.popup.show(this.tabbedPane, e.getX(), e.getY());
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.updateIndexUnderPopupTrigger(e.getX(), e.getY());
            this.popup.show(this.tabbedPane, e.getX(), e.getY());
        }
    }

    private void updateIndexUnderPopupTrigger(int x, int y) {
        Point p = new Point(x, y);
        this.indexUnderPopupTrigger = -1;
        for (int i = 0; i < this.tabbedPane.getTabCount(); ++i) {
            if (!this.tabbedPane.getBoundsAt(i).contains(p)) continue;
            this.indexUnderPopupTrigger = i;
            break;
        }
    }

    private JPopupMenu buildTabContextMenu(boolean includeCloseAll) {
        JPopupMenu tabContextMenu = new JPopupMenu();
        JMenuItem closeCurrentTab = new JMenuItem(new AbstractAction(this, "Close"){
            final /* synthetic */ TabTitleContextMenuMouseListener this$0;
            {
                TabTitleContextMenuMouseListener tabTitleContextMenuMouseListener = this$0;
                Objects.requireNonNull(tabTitleContextMenuMouseListener);
                this.this$0 = tabTitleContextMenuMouseListener;
                super(arg0);
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                if (this.this$0.indexUnderPopupTrigger >= 0) {
                    this.this$0.tabbedPane.closeTabAt(this.this$0.indexUnderPopupTrigger, false);
                }
            }
        });
        JMenuItem closeOtherTabs = new JMenuItem(new AbstractAction(this, "Close other tabs"){
            final /* synthetic */ TabTitleContextMenuMouseListener this$0;
            {
                TabTitleContextMenuMouseListener tabTitleContextMenuMouseListener = this$0;
                Objects.requireNonNull(tabTitleContextMenuMouseListener);
                this.this$0 = tabTitleContextMenuMouseListener;
                super(arg0);
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                if (this.this$0.indexUnderPopupTrigger >= 0) {
                    this.this$0.tabbedPane.closeAllTabs(this.this$0.indexUnderPopupTrigger);
                }
            }
        });
        tabContextMenu.add(closeCurrentTab);
        tabContextMenu.add(closeOtherTabs);
        if (includeCloseAll) {
            JMenuItem closeAllTabs = new JMenuItem(new AbstractAction(this, "Close all tabs"){
                final /* synthetic */ TabTitleContextMenuMouseListener this$0;
                {
                    TabTitleContextMenuMouseListener tabTitleContextMenuMouseListener = this$0;
                    Objects.requireNonNull(tabTitleContextMenuMouseListener);
                    this.this$0 = tabTitleContextMenuMouseListener;
                    super(arg0);
                }

                @Override
                public void actionPerformed(ActionEvent e) {
                    this.this$0.tabbedPane.closeAllTabs();
                }
            });
            tabContextMenu.add(closeAllTabs);
        }
        return tabContextMenu;
    }
}

