/*
 * Decompiled with CFR 0.152.
 */
package jsbugs.uiutil.icon;

import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.SwingWorker;
import jsbugs.uiutil.icon.MultiResImageHelper;
import jsbugs.userconnect.SbugsSession;

public class IconFactory {
    public static final String DEFAULT_ICON_PATH = "/resources/icon/";
    public static final int LARGE_ICON_SIZE = 24;
    public static final int SMALL_ICON_SIZE = 16;
    private static final HashMap<String, IconFactory> instanceMap = new HashMap();
    private final String rootPath;
    private final HashMap<String, Icon> iconMap = new HashMap();

    private IconFactory(String rootPath) {
        this.rootPath = rootPath;
    }

    public static Icon getIcon(String iconName) {
        return IconFactory.getIcon(DEFAULT_ICON_PATH, iconName, null);
    }

    public static Icon getIcon(String iconName, Integer iconSize) {
        return IconFactory.getIcon(DEFAULT_ICON_PATH, iconName, iconSize);
    }

    public static Icon getIcon(String rootPath, String iconName) {
        if (iconName == null) {
            return null;
        }
        return IconFactory.getInstance(rootPath).getCachedIcon(iconName, null);
    }

    public static Icon getIcon(String rootPath, String iconName, Integer iconSize) {
        if (iconName == null) {
            return null;
        }
        return IconFactory.getInstance(rootPath).getCachedIcon(iconName, iconSize);
    }

    private static IconFactory getInstance(String rootPath) {
        IconFactory factory = instanceMap.get(rootPath);
        if (factory == null) {
            factory = new IconFactory(rootPath);
            instanceMap.put(rootPath, factory);
        }
        return factory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Icon getCachedIcon(String iconName, Integer iconSize) {
        Icon imageIcon;
        if (!((String)(iconName = ((String)iconName).trim())).contains(".")) {
            iconName = (String)iconName + ".png";
        }
        Object mapKey = iconName;
        if (iconSize != null) {
            mapKey = (String)mapKey + "_" + iconSize;
        }
        if ((imageIcon = this.iconMap.get(mapKey)) == null) {
            IconFactory iconFactory = this;
            synchronized (iconFactory) {
                try {
                    if (((String)iconName).toUpperCase(Locale.UK).endsWith(".SVG")) {
                        int size = 24;
                        String pngIconName = ((String)iconName).substring(0, ((String)iconName).length() - 3) + "png";
                        ImageIcon pngIcon = null;
                        try {
                            pngIcon = new ImageIcon(IconFactory.class.getResource(this.rootPath + pngIconName));
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        if (iconSize != null) {
                            size = iconSize;
                        } else if (pngIcon != null) {
                            size = Math.max(pngIcon.getIconWidth(), pngIcon.getIconHeight());
                        }
                        try {
                            imageIcon = new ImageIcon(MultiResImageHelper.buildMultiResIcon(this.rootPath + (String)iconName, size));
                        }
                        catch (Exception e) {
                            if (pngIcon != null) {
                                Logger.getLogger(IconFactory.class.getName()).log(Level.CONFIG, "Exception building svg icon (using png alternative): {0}", e.getMessage());
                                imageIcon = pngIcon;
                            }
                            throw e;
                        }
                    } else {
                        imageIcon = new ImageIcon(IconFactory.class.getResource(this.rootPath + (String)iconName));
                    }
                    this.iconMap.put((String)mapKey, imageIcon);
                }
                catch (Exception e) {
                    Logger.getLogger(IconFactory.class.getName()).log(Level.CONFIG, "Exception building svg icon {0}: {1}", new Object[]{iconName, e.getMessage()});
                    imageIcon = null;
                }
            }
        }
        return imageIcon;
    }

    public static Icon getPrefIcon(String iconName) {
        if (SbugsSession.getSession().useHiResIcons()) {
            iconName = (String)iconName + ".svg";
        }
        return IconFactory.getIcon((String)iconName);
    }

    public static Icon getIconGlobal() {
        return IconFactory.getPrefIcon("global");
    }

    public static Icon getIconGlobalLocked() {
        return IconFactory.getPrefIcon("panelGlobalLocked");
    }

    public static Icon getIconGlobalUnlocked() {
        return IconFactory.getPrefIcon("panelGlobalUnlocked");
    }

    public static Icon getIconProject() {
        return IconFactory.getPrefIcon("panelProject");
    }

    public static Icon getIconProjectLocked() {
        return IconFactory.getPrefIcon("panelProjectLocked");
    }

    public static Icon getIconProjectUnlocked() {
        return IconFactory.getPrefIcon("panelProjectUnlocked");
    }

    public static Icon getLockedIcon() {
        return IconFactory.getIcon("linked.png");
    }

    public static Icon getUnlockedIcon() {
        return IconFactory.getIcon("unlink.png");
    }

    public static Icon getOverriddenIcon() {
        return IconFactory.getPrefIcon("override");
    }

    public static Icon getCameraSmallIcon() {
        return IconFactory.getIcon("camera.svg", 16);
    }

    public static void setButtonIconsInBackground(final List<ButtonIconInfo> tasks) {
        new SwingWorker(){

            protected Object doInBackground() throws Exception {
                tasks.parallelStream().forEach(info -> info.button().setIcon(IconFactory.getIcon(info.rootPath, info.iconName, info.iconSize)));
                return null;
            }
        }.execute();
    }

    static {
        instanceMap.put(DEFAULT_ICON_PATH, new IconFactory(DEFAULT_ICON_PATH));
    }

    public record ButtonIconInfo(AbstractButton button, String rootPath, String iconName, Integer iconSize) {
        public ButtonIconInfo(AbstractButton button, String iconName) {
            this(button, IconFactory.DEFAULT_ICON_PATH, iconName, null);
        }

        public ButtonIconInfo(AbstractButton button, String iconName, Integer iconSize) {
            this(button, IconFactory.DEFAULT_ICON_PATH, iconName, iconSize);
        }
    }
}

