/*
 * Decompiled with CFR 0.152.
 */
package jsbugs.uiutil.icon;

import java.awt.Image;
import java.awt.image.AbstractMultiResolutionImage;
import java.awt.image.BaseMultiResolutionImage;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.imageio.ImageIO;
import javax.swing.AbstractButton;
import javax.swing.ImageIcon;
import jsbugs.uiutil.SVGHelper;

public class MultiResImageHelper {
    private static final Logger LOGGER = Logger.getLogger(MultiResImageHelper.class.getName());

    public static void setMultiResIcon(AbstractButton b, String iconPath) {
        List<String> imagePaths = MultiResImageHelper.getIconImageList(iconPath);
        try {
            ArrayList<BufferedImage> images = new ArrayList<BufferedImage>();
            for (String path : imagePaths) {
                images.add(ImageIO.read(MultiResImageHelper.class.getResource(path)));
            }
            Image[] imageList = (Image[])images.toArray(Image[]::new);
            b.setIcon(new ImageIcon(new BaseMultiResolutionImage(imageList)));
        }
        catch (IOException ex) {
            Logger.getLogger(MultiResImageHelper.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private static List<String> getIconImageList(String iconPath) {
        int lastDirIndex = iconPath.lastIndexOf("/");
        String resourceDirName = iconPath.substring(0, lastDirIndex);
        File dir = new File(MultiResImageHelper.class.getResource(resourceDirName).getPath());
        String coreFileName = dir.getPath() + System.getProperty("file.separator") + iconPath.substring(iconPath.lastIndexOf("/") + 1, iconPath.lastIndexOf("_"));
        System.out.println(coreFileName);
        List<String> result = dir.isDirectory() ? Arrays.stream(dir.listFiles()).filter(f -> f.getPath().startsWith(coreFileName)).map(File::getPath).filter(f -> MultiResImageHelper.compareIconPaths(f, iconPath) >= 1).map(p -> resourceDirName + "/" + p.substring(dir.getPath().length() + 1)).sorted((a, b) -> MultiResImageHelper.compareIconPaths(a, b)).collect(Collectors.toList()) : new ArrayList<String>();
        return result;
    }

    private static int compareIconPaths(String a, String b) {
        if (a == null) {
            return b == null ? 0 : 1;
        }
        if (b == null) {
            return 1;
        }
        try {
            String aNum = a.substring(a.lastIndexOf("_") + 1, a.lastIndexOf(46));
            String bNum = b.substring(b.lastIndexOf("_") + 1, b.lastIndexOf(46));
            int aInt = Integer.parseInt(aNum);
            int bInt = Integer.parseInt(bNum);
            return Integer.compare(aInt, bInt);
        }
        catch (Exception e) {
            System.out.println("Error comparing icon paths " + a + " and " + b);
            Logger.getLogger(MultiResImageHelper.class.getName()).log(Level.SEVERE, null, e);
            return a.compareTo(b);
        }
    }

    public static AbstractMultiResolutionImage buildMultiResIcon(String svgResourcePath, int baseSize) {
        long stime = System.currentTimeMillis();
        URL resource = MultiResImageHelper.class.getResource(svgResourcePath);
        if (resource == null) {
            throw new RuntimeException("Could not create multires icon because of missing resource: " + svgResourcePath);
        }
        URL svgFile = resource;
        Image[] images = (Image[])MultiResImageHelper.getSizes(baseSize).stream().map(s -> SVGHelper.buildPngImage(svgFile, s)).filter(i -> i != null).sorted((a, b) -> Integer.compare(a.getWidth(null), b.getWidth(null))).toArray(Image[]::new);
        if (images.length > 0) {
            LOGGER.log(Level.FINE, "Generated {0} images from {1} in {2}ms", new Object[]{images.length, svgResourcePath, System.currentTimeMillis() - stime});
            return new BaseMultiResolutionImage(images);
        }
        return null;
    }

    public static void buildMultiResIcon(AbstractButton button, String svgResourcePath, int baseSize) {
        AbstractMultiResolutionImage multiResIcon = MultiResImageHelper.buildMultiResIcon(svgResourcePath, baseSize);
        if (multiResIcon != null) {
            button.setIcon(new ImageIcon(multiResIcon));
        }
    }

    private static Set<Integer> getSizes(int baseSize) {
        Stream<Double> ratios = Stream.of(1.0, 1.25, 1.5, 1.75, 2.0, 2.25, 2.5, 3.0, 3.5);
        return ratios.map(r -> (int)((double)baseSize * r)).collect(Collectors.toSet());
    }
}

