/*
 * Decompiled with CFR 0.152.
 */
package jsbugs.util;

import com.stratadata.util.process.AbstractMultiStageProcess;
import com.stratadata.util.process.ProcessMessage;
import java.awt.Component;
import java.awt.Cursor;
import javax.swing.JOptionPane;

public class BasicMultiStageProcessHandler {
    private final AbstractMultiStageProcess process;
    private final Component messageParent;
    private final String messageTitle;

    public BasicMultiStageProcessHandler(AbstractMultiStageProcess process, Component messageParent, String messageTitle) {
        this.process = process;
        this.messageParent = messageParent;
        this.messageTitle = messageTitle;
    }

    public void runProcess() {
        while (this.process.isReady()) {
            try {
                this.messageParent.setCursor(Cursor.getPredefinedCursor(3));
                this.process.go();
            }
            finally {
                this.messageParent.setCursor(Cursor.getDefaultCursor());
            }
            if (this.process.getCurrentMessage() == null) continue;
            int opt = JOptionPane.showConfirmDialog(this.messageParent, this.process.getCurrentMessage().message, this.messageTitle, 0, 3);
            if (opt == 0) {
                this.process.setResponse(ProcessMessage.Response.YES);
                continue;
            }
            this.process.setResponse(ProcessMessage.Response.CANCEL);
        }
        int messageType = switch (this.process.getResult().result()) {
            default -> throw new MatchException(null, null);
            case AbstractMultiStageProcess.ResultType.SUCCESS -> 1;
            case AbstractMultiStageProcess.ResultType.FAIL -> 2;
        };
        JOptionPane.showMessageDialog(this.messageParent, this.process.getResult().resultMessage(), this.messageTitle, messageType);
    }
}

