/*
 * Decompiled with CFR 0.152.
 */
package jsbugs.util;

import java.io.File;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import jsbchart.graphics.map.CrsCode;
import jsbugs.FrameWellsSession;
import model3.Lastval;
import model3.SBdb;
import org.apache.commons.lang3.StringUtils;
import util.NumberUtils;

public class UserPrefsHelper {
    private final SBdb sb;
    private static Logger LOGGER = Logger.getLogger(UserPrefsHelper.class.getName());

    public UserPrefsHelper(SBdb sb) {
        this.sb = sb;
    }

    public boolean getUseCoreSampleCorrections() {
        String useCoreString = Lastval.tryGetString(this.sb, "USECORECOR");
        return Boolean.valueOf(useCoreString);
    }

    public void setUseCoreSampleCorrections(boolean value) {
        Lastval.tryPutString(this.sb, "USECORECOR", Boolean.toString(value));
    }

    public boolean getUseCuttingSampleCorrections() {
        String useCoreString = Lastval.tryGetString(this.sb, "USECUTTCOR");
        return Boolean.valueOf(useCoreString);
    }

    public void setUseCuttingSampleCorrections(boolean value) {
        Lastval.tryPutString(this.sb, "USECUTTCOR", Boolean.toString(value));
    }

    public boolean getDisplayCuttingCorrections() {
        String useCoreString = Lastval.tryGetString(this.sb, "SHOWCUTCOR");
        return Boolean.valueOf(useCoreString);
    }

    public boolean getUseUncorrectedDepths() {
        String useCoreString = Lastval.tryGetString(this.sb, "USEUNCOR");
        return Boolean.valueOf(useCoreString);
    }

    public void setUseUncorrectedDepths(boolean value) {
        Lastval.tryPutString(this.sb, "USEUNCOR", Boolean.toString(value));
    }

    public void setDisplayCuttingCorrections(boolean value) {
        Lastval.tryPutString(this.sb, "SHOWCUTCOR", Boolean.toString(value));
    }

    public boolean getDuplicateDepths() {
        String useCoreString = Lastval.tryGetString(this.sb, "DUPLDEPT");
        return Boolean.valueOf(useCoreString);
    }

    public void setDuplicateDepths(boolean value) {
        Lastval.tryPutString(this.sb, "DUPLDEPT", Boolean.toString(value));
    }

    public boolean getUseHiResIcons() {
        String s = Lastval.tryGetString(this.sb, "HIRESICON");
        if (s == null || s.isEmpty()) {
            return true;
        }
        return Boolean.valueOf(s);
    }

    public void setUseHiResIcons(boolean value) {
        Lastval.tryPutString(this.sb, "HIRESICON", Boolean.toString(value));
    }

    public File getLastPaleoImportFile() {
        String path = Lastval.tryGetString(this.sb, "W_PALIFILE", "U_PALIFILE");
        if (StringUtils.isWhitespace((CharSequence)path)) {
            return null;
        }
        return new File(path);
    }

    public void setLastPaleoImportFile(File value) {
        if (value != null) {
            Lastval.tryPutString(this.sb, "W_PALIFILE", "U_PALIFILE", value.getPath());
        }
    }

    public File getLastLithologyImportFile() {
        String path = Lastval.tryGetString(this.sb, "W_LTHIFILE", "U_LTHIFILE");
        if (StringUtils.isWhitespace((CharSequence)path)) {
            return null;
        }
        return new File(path);
    }

    public void setLastLithologyImportFile(File value) {
        if (value != null) {
            Lastval.tryPutString(this.sb, "W_LTHIFILE", "U_LTHIFILE", value.getPath());
        }
    }

    public File getLastListFile() {
        String path = Lastval.tryGetString(this.sb, "JLISTFILE");
        if (StringUtils.isWhitespace((CharSequence)path)) {
            return null;
        }
        return new File(path);
    }

    public void setLastListFile(File value) {
        if (value != null) {
            Lastval.tryPutString(this.sb, "JLISTFILE", value.getPath());
        }
    }

    public Integer getLastCompositeStandardIDSelected() {
        String lastId = Lastval.tryGetString(this.sb, "LAST_CSID");
        if (StringUtils.isEmpty((CharSequence)lastId)) {
            return null;
        }
        return Integer.valueOf(lastId);
    }

    public void setLastCompositeStandardIDSelected(int value) {
        Lastval.tryPutString(this.sb, "LAST_CSID", Integer.toString(value));
    }

    public double getLastNodeSnapAgeRange(double defaultValue) {
        String lastValue = Lastval.tryGetString(this.sb, "L_NDESNPA");
        return this.getDoubleValueFromString(lastValue, defaultValue);
    }

    public void setLastNodeSnapAgeRange(double value) {
        Lastval.tryPutString(this.sb, "L_NDESNPA", Double.toString(value));
    }

    public double getLastNodeSnapDepthRange(double defaultValue) {
        String lastValue = Lastval.tryGetString(this.sb, "L_NDESNPD");
        return this.getDoubleValueFromString(lastValue, defaultValue);
    }

    public void setLastNodeSnapDepthRange(double value) {
        Lastval.tryPutString(this.sb, "L_NDESNPD", Double.toString(value));
    }

    private double getDoubleValueFromString(String stringValue, double defaultValue) {
        Double value = null;
        if (!StringUtils.isEmpty((CharSequence)stringValue)) {
            value = NumberUtils.tryParseDouble((String)stringValue);
        }
        if (value == null) {
            return defaultValue;
        }
        return value;
    }

    public File getLastExportFolder() {
        File f = this.getFile("WINEXPFOL", "UNXEXPFOL");
        if (f != null) {
            if (!f.exists()) {
                return null;
            }
            if (!f.isDirectory()) {
                f = f.getAbsoluteFile().getParentFile();
            }
        }
        return f;
    }

    public File getLastIGDXLSWorkbookFile() {
        return this.getFile("WINIGDWBF", "UNXIGDWBF");
    }

    public void setLastIGDXLSWorkbookFile(File value) {
        this.setFile(value, "WINIGDWBF", "UNXIGDWBF");
    }

    public File getLastInterpSummaryFile() {
        return this.getFile("WINCSVFILE", "UNXCSVFILE");
    }

    public void setLastInterpSummaryFile(File value) {
        this.setFile(value, "WINCSVFILE", "UNXCSVFILE");
    }

    public File getLastOrganiserReportFile() {
        return this.getFile("WINORPFILE", "UNXORPFILE");
    }

    public void setLastOrganiserReportFile(File value) {
        this.setFile(value, "WINORPFILE", "UNXORPFILE");
    }

    public File getLastSampleDetailsFile() {
        return this.getFile("WINSPDFILE", "UNXSPDFILE");
    }

    public void setLastSampleDetailsFile(File value) {
        this.setFile(value, "WINSPDFILE", "UNXSPDFILE");
    }

    public File getLastExportShapefileFile() {
        return this.getFile("WINFILE", "UNXFILE");
    }

    public void setLastExportFolder(File value) {
        this.setFile(value, "WINEXPFOL", "UNXEXPFOL");
    }

    private void setFile(File value, String win, String unix) {
        if (value != null) {
            Lastval.tryPutString(this.sb, win, unix, value.getPath());
        }
    }

    private File getFile(String win, String unix) {
        String path = Lastval.tryGetString(this.sb, win, unix);
        if (StringUtils.isWhitespace((CharSequence)path)) {
            return null;
        }
        return new File(path);
    }

    public Integer getWellSelectionMapBackgroundTemplateId(Integer projectID) {
        String lastId = null;
        if (projectID != null) {
            lastId = Lastval.tryGetString(this.sb, "WSMBGID" + projectID);
        }
        if (StringUtils.isEmpty(lastId)) {
            lastId = Lastval.tryGetString(this.sb, "WSMBGID");
        }
        if (StringUtils.isEmpty(lastId)) {
            return null;
        }
        return Integer.valueOf(lastId);
    }

    public void setWellSelectionMapBackgroundTemplateId(Integer value, Integer projectID) {
        if (value == null) {
            try {
                Lastval.delete(this.sb, "WSMBGID");
                if (projectID != null) {
                    Lastval.delete(this.sb, "WSMBGID" + projectID);
                }
                this.sb.commit();
            }
            catch (SQLException ex) {
                LOGGER.log(Level.WARNING, "Error trying to delete user prefs value 'WSMBGID' from database.", ex);
            }
        } else {
            Lastval.tryPutString(this.sb, "WSMBGID", Integer.toString(value));
            if (projectID != null) {
                Lastval.tryPutString(this.sb, "WSMBGID" + projectID, Integer.toString(value));
            }
        }
    }

    public void setWellSelectionMapProjection(CrsCode value, Integer projectID) {
        Lastval.tryPutString(this.sb, "WSMPROJ", value.toString());
        if (projectID != null) {
            Lastval.tryPutString(this.sb, "WSMPROJ" + projectID, value.toString());
        }
    }

    public CrsCode getWellSelectionMapProjection(Integer projectID) {
        String lastCode = null;
        if (projectID != null) {
            lastCode = Lastval.tryGetString(this.sb, "WSMPROJ" + projectID);
        }
        if (StringUtils.isEmpty(lastCode)) {
            lastCode = Lastval.tryGetString(this.sb, "WSMPROJ");
        }
        if (StringUtils.isEmpty(lastCode)) {
            return null;
        }
        CrsCode code = null;
        try {
            code = CrsCode.valueOf(lastCode);
        }
        catch (Exception ex) {
            LOGGER.log(Level.WARNING, "Error getting CRS code from value {0}", lastCode);
        }
        return code;
    }

    public FrameWellsSession getFrameWellsSession() {
        FrameWellsSession session = null;
        try {
            String sessionParams = Lastval.getString(this.sb, "WELLSESSION");
            if (sessionParams != null && !sessionParams.isEmpty()) {
                session = FrameWellsSession.decodeSession(sessionParams);
            }
        }
        catch (Exception ex) {
            LOGGER.log(Level.WARNING, "Error restoring session", ex);
        }
        return session;
    }

    public void setFrameWellsSession(FrameWellsSession session) {
        Lastval.tryPutString(this.sb, "WELLSESSION", session.encodeSession());
    }
}

