/*
 * Decompiled with CFR 0.152.
 */
package jsbugs.webservices;

import com.stratadata.model3.external.WebServiceDescription;
import com.stratadata.model3.external.WebServiceDescriptionService;
import com.stratadata.model3.external.WebServiceType;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.LayoutStyle;
import jsbugs.userconnect.SbugsExceptionHandler;
import jsbugs.util.ItemSelectorDialog;
import jsbugs.webservices.DialogWebService;

public class DialogWebServices
extends ItemSelectorDialog<WebServiceDescription> {
    private final DefaultListModel model = new DefaultListModel();
    private final WebServiceDescriptionService webServiceDescriptionService;
    private final WebServiceType wsType;
    private WebServiceDescription selection = null;
    private JButton jButtonAdd;
    private JButton jButtonCancel;
    private JButton jButtonDelete;
    private JButton jButtonEdit;
    private JButton jButtonOK;
    private JList<String> jListWS;
    private JScrollPane jScrollPane1;

    public DialogWebServices(JDialog parent, boolean modal, WebServiceDescriptionService webServiceDescriptionService, WebServiceType wsType) {
        super(parent, modal);
        this.webServiceDescriptionService = webServiceDescriptionService;
        this.wsType = wsType;
        this.initComponents();
        this.setTitle("External Web Services : " + String.valueOf(wsType));
        this.init();
    }

    private void init() {
        this.model.clear();
        for (WebServiceDescription ws : this.webServiceDescriptionService.getServiceDescriptions(this.wsType)) {
            this.model.addElement(ws);
        }
        this.jListWS.repaint();
        if (this.model.size() == 1) {
            this.jListWS.setSelectedIndex(0);
        }
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.jListWS = new JList();
        this.jButtonAdd = new JButton();
        this.jButtonEdit = new JButton();
        this.jButtonDelete = new JButton();
        this.jButtonOK = new JButton();
        this.jButtonCancel = new JButton();
        this.setDefaultCloseOperation(2);
        this.setMinimumSize(new Dimension(300, 200));
        this.jListWS.setModel(this.model);
        this.jScrollPane1.setViewportView(this.jListWS);
        this.jButtonAdd.setText("Add...");
        this.jButtonAdd.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogWebServices this$0;
            {
                DialogWebServices dialogWebServices = this$0;
                Objects.requireNonNull(dialogWebServices);
                this.this$0 = dialogWebServices;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonAddActionPerformed(evt);
            }
        });
        this.jButtonEdit.setText("Edit...");
        this.jButtonEdit.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogWebServices this$0;
            {
                DialogWebServices dialogWebServices = this$0;
                Objects.requireNonNull(dialogWebServices);
                this.this$0 = dialogWebServices;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonEditActionPerformed(evt);
            }
        });
        this.jButtonDelete.setText("Delete");
        this.jButtonDelete.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogWebServices this$0;
            {
                DialogWebServices dialogWebServices = this$0;
                Objects.requireNonNull(dialogWebServices);
                this.this$0 = dialogWebServices;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonDeleteActionPerformed(evt);
            }
        });
        this.jButtonOK.setText("OK");
        this.jButtonOK.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogWebServices this$0;
            {
                DialogWebServices dialogWebServices = this$0;
                Objects.requireNonNull(dialogWebServices);
                this.this$0 = dialogWebServices;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonOKActionPerformed(evt);
            }
        });
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogWebServices this$0;
            {
                DialogWebServices dialogWebServices = this$0;
                Objects.requireNonNull(dialogWebServices);
                this.this$0 = dialogWebServices;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonCancelActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1, -1, 318, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jButtonAdd).addComponent(this.jButtonEdit).addComponent(this.jButtonDelete)).addGroup(GroupLayout.Alignment.TRAILING, layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jButtonOK).addComponent(this.jButtonCancel))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jButtonAdd).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonEdit).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonDelete).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 101, Short.MAX_VALUE).addComponent(this.jButtonOK).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonCancel)).addComponent(this.jScrollPane1)).addContainerGap()));
        this.pack();
    }

    private void jButtonEditActionPerformed(ActionEvent evt) {
        int index = this.jListWS.getSelectedIndex();
        if (index < 0) {
            JOptionPane.showMessageDialog((Component)((Object)this), "Select an external service to edit", this.getTitle(), 1);
            return;
        }
        this.selection = (WebServiceDescription)this.model.getElementAt(index);
        DialogWebService dialog = new DialogWebService((JDialog)((Object)this), true, this.wsType, this.selection);
        dialog.setLocationRelativeTo((Component)((Object)this));
        dialog.setVisible(true);
        if (dialog.isOK()) {
            WebServiceDescription newDetails = dialog.getWebServiceDetails();
            try {
                this.webServiceDescriptionService.updateServiceDescription(this.selection.ID(), newDetails);
                this.init();
            }
            catch (IllegalArgumentException iEx) {
                JOptionPane.showMessageDialog((Component)((Object)this), iEx.getMessage(), "Edit External Service", 2);
            }
            catch (RuntimeException ex) {
                SbugsExceptionHandler.showStackError(ex, (Component)((Object)this));
            }
        }
    }

    private void jButtonOKActionPerformed(ActionEvent evt) {
        int index = this.jListWS.getSelectedIndex();
        if (index < 0) {
            JOptionPane.showMessageDialog((Component)((Object)this), "No selection", this.getTitle(), 1);
            return;
        }
        this.selection = (WebServiceDescription)this.model.getElementAt(index);
        this.dispose();
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.selection = null;
        this.dispose();
    }

    private void jButtonAddActionPerformed(ActionEvent evt) {
        DialogWebService dialog = new DialogWebService((JDialog)((Object)this), true, this.wsType, null);
        dialog.setLocationRelativeTo((Component)((Object)this));
        dialog.setVisible(true);
        if (dialog.isOK()) {
            WebServiceDescription newDetails = dialog.getWebServiceDetails();
            try {
                this.webServiceDescriptionService.addServiceDescription(newDetails);
                this.init();
            }
            catch (RuntimeException ex) {
                SbugsExceptionHandler.showStackError(ex, (Component)((Object)this));
            }
        }
    }

    private void jButtonDeleteActionPerformed(ActionEvent evt) {
        int index = this.jListWS.getSelectedIndex();
        if (index < 0) {
            JOptionPane.showMessageDialog((Component)((Object)this), "No selection", this.getTitle(), 1);
            return;
        }
        WebServiceDescription selected = (WebServiceDescription)this.model.getElementAt(index);
        int opt = JOptionPane.showConfirmDialog((Component)((Object)this), "Really delete this service?", "Delete External Service", 0);
        if (opt != 0) {
            return;
        }
        try {
            this.webServiceDescriptionService.deleteServiceDescription(selected.ID());
            this.init();
        }
        catch (RuntimeException ex) {
            SbugsExceptionHandler.showStackError(ex, (Component)((Object)this));
        }
    }

    public WebServiceDescription getSelection() {
        return this.selection;
    }

    @Override
    public List<WebServiceDescription> getSelectedItems() {
        if (this.selection == null) {
            return Collections.emptyList();
        }
        return List.of(this.selection);
    }
}

