/*
 * Decompiled with CFR 0.152.
 */
package jsbugs.webservices;

import com.stratadata.model3.taxon.CategoryService;
import com.stratadata.model3.taxon.GenusService;
import com.stratadata.model3.taxon.Taxon;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import jsbugs.webservices.WebCitationQuery;
import jsbugs.webservices.mikrotax.MikrotaxQuery;
import jsbugs.webservices.pbdb.PbdbQuery;
import jsbugs.webservices.worms.WoRMSQuery;
import org.apache.commons.lang3.StringUtils;

public class WebCitationService {
    public static final int MIKROTAX = 0;
    public static final int WORMS = 1;
    public static final int PBDB = 2;
    public static final String[] SERVICE_NAMES = new String[]{"Mikrotax/Nannotax", "WoRMS", "Paleobiology Database"};
    private static final Logger LOGGER = Logger.getLogger(WebCitationService.class.getName());
    private HashMap<Integer, Boolean> services;
    private final CategoryService categoryService;
    private final GenusService genusService;
    private ServiceStatus statusMonitor = new ServiceStatus();

    public WebCitationService(String prefString, CategoryService categoryService, GenusService genusService) {
        this.categoryService = categoryService;
        this.genusService = genusService;
        this.updateServices(prefString);
        this.statusMonitor.status = "Ready to query " + this.getSelectedServiceNames();
    }

    public void updateServices(String prefString) {
        this.services = new HashMap();
        this.services.put(0, true);
        this.services.put(1, true);
        this.services.put(2, true);
        if (prefString == null) {
            prefString = "";
        }
        String[] srvs = prefString.split(",");
        for (int i = 0; i < srvs.length && i < SERVICE_NAMES.length; ++i) {
            try {
                int selected = Integer.parseInt(srvs[i]);
                this.services.put(i, selected > 0);
                continue;
            }
            catch (NumberFormatException pe) {
                LOGGER.warning("Error parsing boolean from " + srvs[i]);
            }
        }
    }

    public String getStatus() {
        return this.statusMonitor.status;
    }

    public String getSelectedServiceNames() {
        return StringUtils.join(this.getSelectedServices().stream().map(serviceID -> SERVICE_NAMES[serviceID]).toList(), (String)", ");
    }

    private List<Integer> getSelectedServices() {
        return this.services.entrySet().stream().filter(entry -> entry.getValue() == Boolean.TRUE).map(Map.Entry::getKey).toList();
    }

    public WebCitation wsQueryTaxon(Taxon taxon) throws IOException {
        return WebCitationService.wsQueryTaxon(this.getSelectedServices(), taxon);
    }

    public static WebCitation wsQueryTaxon(List<Integer> services, Taxon taxon) throws IOException {
        for (WebCitationQuery query : WebCitationService.getQueries(services)) {
            WebCitation citation = query.queryTaxon(taxon);
            if (citation == null) continue;
            return citation;
        }
        return null;
    }

    private static List<WebCitationQuery> getQueries(List<Integer> services) {
        ArrayList<WebCitationQuery> queries = new ArrayList<WebCitationQuery>();
        for (int service : services) {
            switch (service) {
                case 0: {
                    queries.add(new MikrotaxQuery("main"));
                    queries.add(new MikrotaxQuery("cat"));
                    break;
                }
                case 1: {
                    queries.add(new WoRMSQuery());
                    break;
                }
                case 2: {
                    queries.add(new PbdbQuery());
                }
            }
        }
        return queries;
    }

    public List<CitedTaxon> findTaxa(String queryTerm) throws IOException {
        return WebCitationService.findTaxa(this.getSelectedServices(), this.statusMonitor, queryTerm, this.categoryService, this.genusService);
    }

    public static List<CitedTaxon> findTaxa(List<Integer> services, ServiceStatus statusMonitor, String queryTerm, CategoryService categoryService, GenusService genusService) throws IOException {
        if (statusMonitor == null) {
            statusMonitor = new ServiceStatus();
        }
        ArrayList<CitedTaxon> taxa = new ArrayList<CitedTaxon>();
        for (WebCitationQuery query : WebCitationService.getQueries(services)) {
            taxa.addAll(query.findTaxa(queryTerm, statusMonitor, categoryService, genusService));
        }
        return taxa;
    }

    public static class ServiceStatus {
        String status = "";
    }

    public record WebCitation(int serviceID, String source, String reference, String url) {
    }

    public record CitedTaxon(Taxon taxon, WebCitation ciation) {
    }
}

