/*
 * Decompiled with CFR 0.152.
 */
package jsbugs.webservices.mikrotax;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.stratadata.model3.taxon.Taxon;
import com.stratadata.model3.taxon.TaxonFactory;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.List;
import jsbugs.webservices.WebCitationQuery;
import jsbugs.webservices.WebCitationService;
import jsbugs.webservices.mikrotax.Data;
import jsbugs.webservices.mikrotax.MikrotaxQueryResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringEscapeUtils;

public class MikrotaxQuery
extends WebCitationQuery {
    private final String dbSource;

    public MikrotaxQuery(String dbSource) {
        this.dbSource = dbSource;
    }

    @Override
    public String getCitationQueryUrl(Taxon taxon) {
        return "https://www.mikrotax.org/system/api.php?name=" + MikrotaxQuery.getUrlTaxonName(taxon) + "&db=" + this.dbSource;
    }

    @Override
    public String getSearchQueryUrl(Taxon taxon) {
        if (taxon.getGenus().getGenusName().endsWith(".")) {
            taxon.getGenus().setGenusName(taxon.getGenus().getGenusName().substring(0, taxon.getGenus().getGenusName().length() - 1));
        }
        taxon.getGenus().setGenusName(taxon.getGenus().getGenusName() + "%");
        if (taxon.getSpecies().isEmpty()) {
            taxon.setSpecies("%");
        }
        return "https://www.mikrotax.org/system/api.php?name=" + MikrotaxQuery.getUrlTaxonName(taxon) + "&db=" + this.dbSource;
    }

    @Override
    public WebCitationService.WebCitation parseCitation(InputStream queryResponse) throws IOException {
        WebCitationService.CitedTaxon citedTaxon = this.parseTaxon(queryResponse);
        if (citedTaxon != null) {
            return citedTaxon.ciation();
        }
        return null;
    }

    @Override
    public List<WebCitationService.CitedTaxon> parseTaxa(InputStream queryResponse) throws IOException {
        WebCitationService.CitedTaxon citedTaxon = this.parseTaxon(queryResponse);
        if (citedTaxon != null) {
            citedTaxon.taxon().setAuthor(citedTaxon.ciation().reference());
            citedTaxon.taxon().setUrl(citedTaxon.ciation().url());
            return List.of(citedTaxon);
        }
        return Collections.EMPTY_LIST;
    }

    private WebCitationService.CitedTaxon parseTaxon(InputStream queryResponse) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        MikrotaxQueryResponse q = (MikrotaxQueryResponse)mapper.readValue(queryResponse, MikrotaxQueryResponse.class);
        if (q.getStatus() == 200) {
            if (q.getStatusMessage().contains("Not Found")) {
                return null;
            }
            Data d = q.getData();
            Taxon taxon = TaxonFactory.parse((String)d.getTaxon());
            String citation = d.getCitation();
            if (!StringUtils.isBlank((CharSequence)citation) && citation.contains(">")) {
                citation = citation.substring(citation.lastIndexOf(">") + 1).trim();
                if ((citation = StringEscapeUtils.unescapeHtml4((String)citation)).isEmpty()) {
                    citation = "(no citation)";
                }
            } else if (d.getTaxon() != null) {
                citation = "(no citation)";
            }
            Object source = "Mikrotax";
            if (this.dbSource.equals("cat")) {
                source = (String)source + " (orig. catalogue)";
            }
            Object citationUrl = "";
            if (d.getId() != null && !d.getId().isEmpty()) {
                citationUrl = "https://www.mikrotax.org/pforams/index.php?id=" + d.getId();
                taxon.setUrl((String)citationUrl);
            }
            WebCitationService.WebCitation webCitation = new WebCitationService.WebCitation(0, (String)source, citation, (String)citationUrl);
            return new WebCitationService.CitedTaxon(taxon, webCitation);
        }
        return null;
    }
}

