/*
 * Decompiled with CFR 0.152.
 */
package jsbugs.webservices.worms;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.stratadata.model3.taxon.Taxon;
import com.stratadata.model3.taxon.TaxonFactory;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import jsbugs.webservices.WebCitationQuery;
import jsbugs.webservices.WebCitationService;
import jsbugs.webservices.worms.AphiaRecord;
import jsbugs.webservices.worms.WoRMSDetails;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringEscapeUtils;

public class WoRMSQuery
extends WebCitationQuery {
    @Override
    public String getCitationQueryUrl(Taxon taxon) {
        return "https://www.marinespecies.org/rest/AphiaIDByName/" + WoRMSQuery.getUrlTaxonName(taxon) + "?marine_only=false&extant_only=false";
    }

    @Override
    public WebCitationService.WebCitation parseCitation(InputStream inputStream) throws IOException {
        byte[] b = new byte[20];
        inputStream.read(b);
        String aphiaString = new String(b, StandardCharsets.UTF_8);
        int aphiaID = Integer.parseInt(aphiaString.trim());
        String idQueryString = "https://www.marinespecies.org/rest/AphiaAttributesByAphiaID/" + aphiaID + "?include_inherited=true";
        HttpURLConnection idQueryResponse = WoRMSQuery.doQuery(idQueryString);
        if (idQueryResponse == null) {
            return null;
        }
        ObjectMapper mapper = new ObjectMapper();
        WoRMSDetails[] a = (WoRMSDetails[])mapper.readValue(idQueryResponse.getInputStream(), WoRMSDetails[].class);
        String reference = null;
        for (WoRMSDetails q : a) {
            if (reference == null) {
                reference = q.getReference();
                if (!StringUtils.isBlank((CharSequence)reference)) {
                    reference = reference.trim();
                } else if (q.getAphiaID() != null) {
                    reference = "(no citation)";
                }
            }
            if (q.getMeasurementType() == null || !q.getMeasurementType().equals("Fossil range") || q.getMeasurementValue() == null) continue;
            reference = q.getMeasurementValue();
        }
        String source = "WoRMS";
        String webUrl = "https://www.marinespecies.org/aphia.php?p=taxdetails&id=" + aphiaID;
        return new WebCitationService.WebCitation(1, source, reference, webUrl);
    }

    @Override
    public String getSearchQueryUrl(Taxon taxon) {
        if (taxon.getGenus().getGenusName().endsWith("%") || taxon.getGenus().getGenusName().endsWith(".")) {
            String genusName = taxon.getGenus().getGenusName();
            taxon.getGenus().setGenusName(genusName.substring(0, genusName.length() - 1));
        }
        String queryName = taxon.toString(false, false).trim().replaceAll(" ", "%20");
        return "https://www.marinespecies.org/rest/AphiaRecordsByName/" + queryName + "?like=true&marine_only=false&extant_only=false";
    }

    @Override
    public List<WebCitationService.CitedTaxon> parseTaxa(InputStream inputStream) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        AphiaRecord[] a = (AphiaRecord[])mapper.readValue(inputStream, AphiaRecord[].class);
        ArrayList<WebCitationService.CitedTaxon> taxa = new ArrayList<WebCitationService.CitedTaxon>();
        for (AphiaRecord record : a) {
            if (!"Species".equals(record.getRank())) continue;
            String taxonName = record.getScientificName();
            Taxon taxon = TaxonFactory.parse((String)taxonName);
            taxon.setAuthor(StringEscapeUtils.unescapeHtml4((String)record.getAuthority()));
            String webUrl = "https://www.marinespecies.org/aphia.php?p=taxdetails&id=" + record.getAphiaID();
            taxon.setUrl(webUrl);
            taxa.add(new WebCitationService.CitedTaxon(taxon, new WebCitationService.WebCitation(1, WebCitationService.SERVICE_NAMES[1], null, webUrl)));
        }
        return taxa;
    }
}

