/*
 * Decompiled with CFR 0.152.
 */
package jsbugs.wellheader;

import com.stratadata.model3.validation.FieldLengthProperties;
import com.stratadata.model3.validation.SbugsValidator;
import com.stratadata.model3.well.DegreesMinutesSecondsCoordinate;
import com.stratadata.model3.well.GeoDatum;
import com.stratadata.model3.well.SectionType;
import com.stratadata.model3.well.WellDatum;
import com.stratadata.model3.well.WellHeader;
import com.stratadata.util.DateUtils;
import com.stratadata.util.depth.DepthUnits;
import com.stratadata.util.depth.DepthUtils;
import com.stratadata.util.ui.DialogBase;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.SQLException;
import java.time.LocalDate;
import java.time.format.DateTimeParseException;
import java.util.List;
import java.util.Objects;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import jsbugs.DialogList;
import jsbugs.uiutil.DepthStringUtils;
import jsbugs.uiutil.TextFieldUtils;
import jsbugs.uiutil.audit.AuditUiUtilities;
import jsbugs.uiutil.audit.JPanelAuditColumn;
import jsbugs.userconnect.SbugsExceptionHandler;
import jsbugs.util.UserPrefsHelper;
import jsbugs.wellheader.DialogSelectWell;
import jsbugs.wellheader.DialogSelectWellMaster;
import model3.Lastval;
import model3.SBdb;
import model3.Well;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang3.StringUtils;
import util.InvalidFieldException;
import util.SB;
import util.SBException;
import util.SBPermissionException;

public class DialogWell
extends DialogBase {
    private static final int WELL_NAME_LEN = FieldLengthProperties.getFieldLength(WellHeader.class, (String)"wellName", (int)80);
    private static final int WELL_ALT_NAME_LEN = FieldLengthProperties.getFieldLength(WellHeader.class, (String)"wellAltName", (int)80);
    private static final int WELL_CODE_LEN = FieldLengthProperties.getFieldLength(WellHeader.class, (String)"wellCode", (int)80);
    private static final int OPERATOR_LEN = FieldLengthProperties.getFieldLength(WellHeader.class, (String)"operator", (int)50);
    private static final int CLIENT_LEN = FieldLengthProperties.getFieldLength(WellHeader.class, (String)"client", (int)100);
    private static final int COUNTRY_LEN = FieldLengthProperties.getFieldLength(WellHeader.class, (String)"country", (int)40);
    private static final int COUNTY_LEN = FieldLengthProperties.getFieldLength(WellHeader.class, (String)"county", (int)30);
    private static final int OCS_LEN = FieldLengthProperties.getFieldLength(WellHeader.class, (String)"ocs", (int)40);
    private static final int FIELD_LEN = FieldLengthProperties.getFieldLength(WellHeader.class, (String)"field", (int)40);
    private static final int BASIN_LEN = FieldLengthProperties.getFieldLength(WellHeader.class, (String)"basin", (int)80);
    private static final int AREA_LEN = FieldLengthProperties.getFieldLength(WellHeader.class, (String)"area", (int)80);
    private static final int STATE_LEN = FieldLengthProperties.getFieldLength(WellHeader.class, (String)"state", (int)40);
    private static final int UTM_ZONE_LEN = FieldLengthProperties.getFieldLength(WellHeader.class, (String)"utmZone", (int)80);
    private static final int COMMENT_LEN = FieldLengthProperties.getFieldLength(WellHeader.class, (String)"description", (int)1000);
    private final ResourceBundle resources = ResourceBundle.getBundle("locale/UiText");
    private final DefaultComboBoxModel scaleModel = new DefaultComboBoxModel();
    private final DefaultComboBoxModel getDatumModel = new DefaultComboBoxModel();
    private final SBdb sbdb;
    private Well well;
    private Well parentWell;
    private JTabbedPane jTabbedPane1;
    private JPanel jPanelDetails;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JTextField jTextFieldWellName;
    private JButton jButtonCopyToCode;
    private JTextField jTextFieldWellCode;
    private JLabel jLabel3;
    private JTextField jTextFieldOperator;
    private JLabel jLabel4;
    private JPanel jPanel5;
    private JRadioButton jRadioButtonWell;
    private JRadioButton jRadioButtonOutcrop;
    private JTextField jTextFieldOCS;
    private JLabel jLabel5;
    private JTextField jTextFieldSpud;
    private JLabel jLabel7;
    private JTextField jTextFieldCompletion;
    private JScrollPane jScrollPane1;
    private JTextArea jTextAreaComment;
    private JButton jButtonMakeCode;
    private JLabel jLabel31;
    private JButton jButtonSelectMaster;
    private JLabel jLabel13;
    private JTextField jTextFieldWellAltName;
    private JLabel label1;
    private JTextField jTextFieldParent;
    private JButton jButtonSelectParent;
    private JButton jButtonClearParent;
    private JLabel jLabel34;
    private JTextField jTextFieldClient;
    private JPanel jPanel9;
    private JButton jButtonColour;
    private JTextField jTextFieldColour;
    private JPanelAuditColumn jPanelAudit;
    private JPanel jPanelLocation;
    private JLabel jLabel9;
    private JLabel jLabel10;
    private JLabel jLabel11;
    private JTextField jTextFieldCountry;
    private JTextField jTextFieldCounty;
    private JTextField jTextFieldField;
    private JLabel jLabel24;
    private JLabel jLabel25;
    private JTextField jTextFieldGridX;
    private JTextField jTextFieldGridY;
    private JPanel jPanel1;
    private JRadioButton jRadioButtonDMS;
    private JRadioButton jRadioButtonDecimalDegrees;
    private JLabel jLabel16;
    private JTextField jTextFieldLatDeg;
    private JLabel jLabel18;
    private JTextField jTextFieldLatMin;
    private JLabel jLabel19;
    private JTextField jTextFieldLatSec;
    private JLabel jLabel23;
    private JComboBox<String> jComboBoxLat;
    private JLabel jLabel17;
    private JTextField jTextFieldLongDeg;
    private JLabel jLabel21;
    private JTextField jTextFieldLongMin;
    private JLabel jLabel22;
    private JTextField jTextFieldLongSec;
    private JLabel jLabel20;
    private JComboBox<String> jComboBoxLong;
    private JLabel jLabel28;
    private JTextField jTextFieldLatDec;
    private JLabel jLabel29;
    private JTextField jTextFieldLongDec;
    private JLabel jLabel15;
    private JComboBox<String> jComboBoxGeoDatum;
    private JButton jButtonCountry;
    private JLabel jLabel26;
    private JTextField jTextFieldBasin;
    private JLabel jLabel27;
    private JTextField jTextFieldArea;
    private JLabel jLabel30;
    private JTextField jTextFieldState;
    private JLabel jLabel32;
    private JTextField jTextFieldUTMZone;
    private JPanel jPanelDepths;
    private JPanel jPanel6;
    private JRadioButton jRadioButtonMetres;
    private JRadioButton jRadioButtonFeet;
    private JPanel jPanel7;
    private JTextField jTextFieldRTE;
    private JTextField jTextFieldSL;
    private JTextField jTextFieldSB;
    private JLabel jLabelKickOff;
    private JLabel jLabelTD;
    private JTextField jTextFieldKO;
    private JTextField jTextFieldTD;
    private JLabel jLabelRTE;
    private JLabel jLabelSL;
    private JLabel jLabelDSB;
    private JPanel jPanel8;
    private JRadioButton jRadioButtonRTE;
    private JRadioButton jRadioButtonSL;
    private JRadioButton jRadioButtonSB;
    private JLabel jLabel33;
    private JComboBox<String> jComboBoxChartScale;
    private ButtonGroup buttonGroupType;
    private ButtonGroup buttonGroupCoordinates;
    private ButtonGroup buttonGroupDepthUnits;
    private ButtonGroup buttonGroupDatum;

    public DialogWell(Frame parent, boolean modal, SBdb sbdb, Well well) throws SQLException {
        super((Window)parent);
        this.sbdb = sbdb;
        this.well = well;
        this.initComponents();
        this.init(null);
        DialogBase.centreWindow((Window)((Object)this));
    }

    public DialogWell(JDialog parent, boolean modal, SBdb sbdb, Well well) throws SQLException {
        super((Window)parent);
        this.sbdb = sbdb;
        if (well != null && well.getDataModel() == sbdb) {
            this.well = well;
            well = null;
        }
        this.initComponents();
        this.init(well);
        this.pack();
    }

    private void initComponents() {
        ResourceBundle bundle = ResourceBundle.getBundle("locale.UiText");
        this.jTabbedPane1 = new JTabbedPane();
        this.jPanelDetails = new JPanel();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jTextFieldWellName = TextFieldUtils.buildLimitedLengthTextField(WELL_NAME_LEN);
        this.jButtonCopyToCode = new JButton();
        this.jTextFieldWellCode = TextFieldUtils.buildLimitedLengthTextField(WELL_CODE_LEN);
        this.jLabel3 = new JLabel();
        this.jTextFieldOperator = TextFieldUtils.buildLimitedLengthTextField(OPERATOR_LEN);
        this.jLabel4 = new JLabel();
        this.jPanel5 = new JPanel();
        this.jRadioButtonWell = new JRadioButton();
        this.jRadioButtonOutcrop = new JRadioButton();
        this.jTextFieldOCS = TextFieldUtils.buildLimitedLengthTextField(OCS_LEN);
        this.jLabel5 = new JLabel();
        this.jTextFieldSpud = new JTextField();
        this.jLabel7 = new JLabel();
        this.jTextFieldCompletion = new JTextField();
        this.jScrollPane1 = new JScrollPane();
        this.jTextAreaComment = TextFieldUtils.buildLimitedLengthTextArea(COMMENT_LEN);
        this.jButtonMakeCode = new JButton();
        this.jLabel31 = new JLabel();
        this.jButtonSelectMaster = new JButton();
        this.jLabel13 = new JLabel();
        this.jTextFieldWellAltName = TextFieldUtils.buildLimitedLengthTextField(WELL_ALT_NAME_LEN);
        this.label1 = new JLabel();
        this.jTextFieldParent = new JTextField();
        this.jButtonSelectParent = new JButton();
        this.jButtonClearParent = new JButton();
        this.jLabel34 = new JLabel();
        this.jTextFieldClient = TextFieldUtils.buildLimitedLengthTextField(CLIENT_LEN);
        this.jPanel9 = new JPanel();
        this.jButtonColour = new JButton();
        this.jTextFieldColour = new JTextField();
        this.jPanelAudit = new JPanelAuditColumn();
        this.jPanelLocation = new JPanel();
        this.jLabel9 = new JLabel();
        this.jLabel10 = new JLabel();
        this.jLabel11 = new JLabel();
        this.jTextFieldCountry = TextFieldUtils.buildLimitedLengthTextField(COUNTRY_LEN);
        this.jTextFieldCounty = TextFieldUtils.buildLimitedLengthTextField(COUNTY_LEN);
        this.jTextFieldField = TextFieldUtils.buildLimitedLengthTextField(FIELD_LEN);
        this.jLabel24 = new JLabel();
        this.jLabel25 = new JLabel();
        this.jTextFieldGridX = TextFieldUtils.buildDecimalOnlyTextField(true, 9999999.999, 3);
        this.jTextFieldGridY = TextFieldUtils.buildDecimalOnlyTextField(true, 9999999.999, 3);
        this.jPanel1 = new JPanel();
        this.jRadioButtonDMS = new JRadioButton();
        this.jRadioButtonDecimalDegrees = new JRadioButton();
        this.jLabel16 = new JLabel();
        this.jTextFieldLatDeg = TextFieldUtils.buildIntegerOnlyTextField(false, 90L);
        this.jLabel18 = new JLabel();
        this.jTextFieldLatMin = TextFieldUtils.buildIntegerOnlyTextField(false, 60L);
        this.jLabel19 = new JLabel();
        this.jTextFieldLatSec = TextFieldUtils.buildDecimalOnlyTextField(false, 60.0, 3);
        this.jLabel23 = new JLabel();
        this.jComboBoxLat = new JComboBox();
        this.jComboBoxLat.putClientProperty("JComboBox.isPopDown", Boolean.TRUE);
        this.jLabel17 = new JLabel();
        this.jTextFieldLongDeg = TextFieldUtils.buildIntegerOnlyTextField(false, 180L);
        this.jLabel21 = new JLabel();
        this.jTextFieldLongMin = TextFieldUtils.buildIntegerOnlyTextField(false, 60L);
        this.jLabel22 = new JLabel();
        this.jTextFieldLongSec = TextFieldUtils.buildDecimalOnlyTextField(false, 60.0, 3);
        this.jLabel20 = new JLabel();
        this.jComboBoxLong = new JComboBox();
        this.jComboBoxLong.putClientProperty("JComboBox.isPopDown", Boolean.TRUE);
        this.jLabel28 = new JLabel();
        this.jTextFieldLatDec = TextFieldUtils.buildDecimalOnlyTextField(true, 90.0, 6);
        this.jLabel29 = new JLabel();
        this.jTextFieldLongDec = TextFieldUtils.buildDecimalOnlyTextField(true, 180.0, 6);
        this.jLabel15 = new JLabel();
        this.jComboBoxGeoDatum = new JComboBox();
        this.jButtonCountry = new JButton();
        this.jButtonCountry.putClientProperty("JComponent.sizeVariant", "small");
        this.jLabel26 = new JLabel();
        this.jTextFieldBasin = TextFieldUtils.buildLimitedLengthTextField(BASIN_LEN);
        this.jLabel27 = new JLabel();
        this.jTextFieldArea = TextFieldUtils.buildLimitedLengthTextField(AREA_LEN);
        this.jLabel30 = new JLabel();
        this.jTextFieldState = TextFieldUtils.buildLimitedLengthTextField(STATE_LEN);
        this.jLabel32 = new JLabel();
        this.jTextFieldUTMZone = TextFieldUtils.buildLimitedLengthTextField(UTM_ZONE_LEN);
        this.jPanelDepths = new JPanel();
        this.jPanel6 = new JPanel();
        this.jRadioButtonMetres = new JRadioButton();
        this.jRadioButtonFeet = new JRadioButton();
        this.jPanel7 = new JPanel();
        this.jTextFieldRTE = DialogWell.buildWellHeaderDepthField();
        this.jTextFieldSL = DialogWell.buildWellHeaderDepthField();
        this.jTextFieldSB = DialogWell.buildWellHeaderDepthField();
        this.jLabelKickOff = new JLabel();
        this.jLabelTD = new JLabel();
        this.jTextFieldKO = DialogWell.buildWellHeaderDepthField();
        this.jTextFieldTD = DialogWell.buildWellHeaderDepthField();
        this.jLabelRTE = new JLabel();
        this.jLabelSL = new JLabel();
        this.jLabelDSB = new JLabel();
        this.jPanel8 = new JPanel();
        this.jRadioButtonRTE = new JRadioButton();
        this.jRadioButtonSL = new JRadioButton();
        this.jRadioButtonSB = new JRadioButton();
        this.jLabel33 = new JLabel();
        this.jComboBoxChartScale = new JComboBox();
        this.buttonGroupType = new ButtonGroup();
        this.buttonGroupCoordinates = new ButtonGroup();
        this.buttonGroupDepthUnits = new ButtonGroup();
        this.buttonGroupDatum = new ButtonGroup();
        this.setDefaultCloseOperation(2);
        this.setResizable(false);
        this.setHelpLocation("dialogwell.html#dialogwell");
        JPanel contentPanel = this.getContentPanel();
        contentPanel.setLayout(new FlowLayout());
        this.jPanelDetails.setLayout((LayoutManager)new MigLayout("insets panel,hidemode 3,gap 5 5", "[right]rel[grow,fill][fill]rel[fill]", "rel[fill][fill][fill]rel[]unrel[fill][fill][fill][fill][fill]unrel[41,fill]rel[fill][fill]unrel[fill]"));
        this.jLabel1.setForeground(new Color(0xCC0000));
        this.jLabel1.setText(bundle.getString("label.name"));
        this.jPanelDetails.add((Component)this.jLabel1, "cell 0 0");
        this.jLabel2.setForeground(new Color(0xCC0000));
        this.jLabel2.setText(bundle.getString("DialogWell.details.code.label"));
        this.jPanelDetails.add((Component)this.jLabel2, "cell 0 2");
        this.jPanelDetails.add((Component)this.jTextFieldWellName, "cell 1 0 2 1");
        this.jButtonCopyToCode.setText(bundle.getString("DialogWell.details.button.copynametocode"));
        this.jButtonCopyToCode.addActionListener(e -> this.jButtonCopyToCodeActionPerformed());
        this.jPanelDetails.add((Component)this.jButtonCopyToCode, "cell 3 0");
        this.jPanelDetails.add((Component)this.jTextFieldWellCode, "cell 1 2 2 1");
        this.jLabel3.setText(bundle.getString("DialogWell.details.operator"));
        this.jPanelDetails.add((Component)this.jLabel3, "cell 0 4");
        this.jPanelDetails.add((Component)this.jTextFieldOperator, "cell 1 4 3 1");
        this.jLabel4.setText(bundle.getString("DialogWell.details.OCS"));
        this.jPanelDetails.add((Component)this.jLabel4, "cell 0 6");
        this.jPanel5.setBorder(new TitledBorder(bundle.getString("DialogWell.details.sectiontype")));
        this.jRadioButtonWell.setSelected(true);
        this.jRadioButtonWell.setText(bundle.getString("DialogWell.details.well"));
        this.jRadioButtonWell.setBorder(BorderFactory.createEmptyBorder());
        this.jRadioButtonWell.setMargin(new Insets(0, 0, 0, 0));
        this.jRadioButtonWell.addActionListener(e -> this.jRadioButtonWellActionPerformed(e));
        this.jRadioButtonOutcrop.setText(bundle.getString("DialogWell.details.outcrop"));
        this.jRadioButtonOutcrop.setBorder(BorderFactory.createEmptyBorder());
        this.jRadioButtonOutcrop.setMargin(new Insets(0, 0, 0, 0));
        this.jRadioButtonOutcrop.addActionListener(e -> this.jRadioButtonOutcropActionPerformed(e));
        GroupLayout jPanel5Layout = new GroupLayout(this.jPanel5);
        this.jPanel5.setLayout(jPanel5Layout);
        jPanel5Layout.setHorizontalGroup(jPanel5Layout.createParallelGroup().addGroup(jPanel5Layout.createSequentialGroup().addContainerGap().addComponent(this.jRadioButtonWell).addGap(17, 17, 17).addComponent(this.jRadioButtonOutcrop).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel5Layout.setVerticalGroup(jPanel5Layout.createParallelGroup().addGroup(jPanel5Layout.createSequentialGroup().addContainerGap().addGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jRadioButtonWell).addComponent(this.jRadioButtonOutcrop)).addContainerGap(-1, Short.MAX_VALUE)));
        this.jPanelDetails.add((Component)this.jPanel5, "cell 0 9 2 1,growx");
        this.jPanelDetails.add((Component)this.jTextFieldOCS, "cell 1 6 3 1");
        this.jLabel5.setText(bundle.getString("DialogWell.details.spud"));
        this.jPanelDetails.add((Component)this.jLabel5, "cell 0 7");
        this.jTextFieldSpud.setToolTipText("DD-Mon-YYYY");
        this.jPanelDetails.add((Component)this.jTextFieldSpud, "cell 1 7 3 1");
        this.jLabel7.setText(bundle.getString("DialogWell.details.completion"));
        this.jPanelDetails.add((Component)this.jLabel7, "cell 0 8");
        this.jTextFieldCompletion.setToolTipText("DD-Mon-YYYY");
        this.jPanelDetails.add((Component)this.jTextFieldCompletion, "cell 1 8 3 1");
        this.jTextAreaComment.setColumns(20);
        this.jTextAreaComment.setFont(this.jTextAreaComment.getFont());
        this.jTextAreaComment.setLineWrap(true);
        this.jTextAreaComment.setRows(5);
        this.jTextAreaComment.setWrapStyleWord(true);
        this.jScrollPane1.setViewportView(this.jTextAreaComment);
        this.jPanelDetails.add((Component)this.jScrollPane1, "cell 0 11 4 1,growx");
        this.jButtonMakeCode.setText(bundle.getString("DialogWell.details.button.makecode"));
        this.jButtonMakeCode.setToolTipText(bundle.getString("DialogWell.details.button.makecode.tooltipText"));
        this.jButtonMakeCode.addActionListener(e -> this.jButtonMakeCodeActionPerformed(e));
        this.jPanelDetails.add((Component)this.jButtonMakeCode, "cell 3 2");
        this.jLabel31.setForeground(new Color(0x3366CC));
        this.jLabel31.setText(bundle.getString("label.comments"));
        this.jPanelDetails.add((Component)this.jLabel31, "cell 0 10,alignx left,growx 0");
        this.jButtonSelectMaster.setText(bundle.getString("button.select"));
        this.jButtonSelectMaster.addActionListener(e -> this.jButtonSelectMasterActionPerformed(e));
        this.jPanelDetails.add((Component)this.jButtonSelectMaster, "cell 3 2");
        this.jLabel13.setText(bundle.getString("DialogWell.details.alternate"));
        this.jPanelDetails.add((Component)this.jLabel13, "cell 0 1");
        this.jPanelDetails.add((Component)this.jTextFieldWellAltName, "cell 1 1 3 1");
        this.label1.setText("Parent well:");
        this.label1.setToolTipText("For sidetracks, select the original wellbore here");
        this.jPanelDetails.add((Component)this.label1, "cell 0 3");
        this.jPanelDetails.add((Component)this.jTextFieldParent, "cell 1 3 3 1");
        this.jButtonSelectParent.setText(bundle.getString("ellipsis"));
        this.jButtonSelectParent.setPreferredSize(new Dimension(30, 22));
        this.jButtonSelectParent.addActionListener(e -> this.jButtonSelectParentActionPerformed());
        this.jPanelDetails.add((Component)this.jButtonSelectParent, "cell 1 3 3 1,alignx right,growx 0");
        this.jButtonClearParent.setText(bundle.getString("button.clear"));
        this.jButtonClearParent.addActionListener(e -> this.jButtonClearParentActionPerformed());
        this.jPanelDetails.add((Component)this.jButtonClearParent, "cell 1 3 3 1,alignx right,growx 0");
        this.jLabel34.setHorizontalAlignment(11);
        this.jLabel34.setText(bundle.getString("DialogWell.details.client"));
        this.jPanelDetails.add((Component)this.jLabel34, "cell 0 5");
        this.jTextFieldClient.setToolTipText(bundle.getString("DialogWell.details.client.toolTipText"));
        this.jPanelDetails.add((Component)this.jTextFieldClient, "cell 1 5 3 1");
        this.jPanel9.setBorder(new TitledBorder(bundle.getString("title.colour")));
        this.jButtonColour.setText(bundle.getString("ellipsis"));
        this.jButtonColour.setToolTipText("More colours");
        this.jButtonColour.setPreferredSize(new Dimension(30, 22));
        this.jButtonColour.addActionListener(e -> this.jButtonColourActionPerformed(e));
        this.jTextFieldColour.setBackground(Color.black);
        this.jTextFieldColour.setFocusable(false);
        GroupLayout jPanel9Layout = new GroupLayout(this.jPanel9);
        this.jPanel9.setLayout(jPanel9Layout);
        jPanel9Layout.setHorizontalGroup(jPanel9Layout.createParallelGroup().addGroup(jPanel9Layout.createSequentialGroup().addContainerGap().addComponent(this.jTextFieldColour, -2, 24, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonColour, -2, 30, -2).addContainerGap(34, Short.MAX_VALUE)));
        jPanel9Layout.setVerticalGroup(jPanel9Layout.createParallelGroup().addGroup(jPanel9Layout.createSequentialGroup().addContainerGap().addGroup(jPanel9Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTextFieldColour, -2, -1, -2).addComponent(this.jButtonColour, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        this.jPanelDetails.add((Component)this.jPanel9, "cell 2 9,growx");
        this.jPanelAudit.setBorder(new EtchedBorder());
        this.jPanelAudit.setNameFormat(AuditUiUtilities.UserNameFormat.FULL);
        this.jPanelDetails.add((Component)this.jPanelAudit, "cell 0 12 4 1,growx");
        this.jTabbedPane1.addTab(bundle.getString("DialogWell.details.tab"), this.jPanelDetails);
        this.jPanelLocation.setLayout((LayoutManager)new MigLayout("insets panel,hidemode 3,gap 5 5", "[right][134,grow,fill]unrel[241,grow,fill][shrink 0,left]", "rel[fill][fill][fill][fill][fill][fill]unrel[fill]unrel[fill][fill]"));
        this.jLabel9.setForeground(new Color(0xCC0000));
        this.jLabel9.setText(bundle.getString("DialogWell.location.country.label"));
        this.jPanelLocation.add((Component)this.jLabel9, "cell 0 0,alignx right,growx 0");
        this.jLabel10.setText(bundle.getString("DialogWell.location.county"));
        this.jPanelLocation.add((Component)this.jLabel10, "cell 0 1,alignx right,growx 0");
        this.jLabel11.setText(bundle.getString("DialogWell.location.field"));
        this.jPanelLocation.add((Component)this.jLabel11, "cell 0 3,alignx right,growx 0");
        this.jTextFieldCountry.getInputMap(0).put(KeyStroke.getKeyStroke(32, 128), "country");
        this.jTextFieldCountry.getActionMap().put("country", new AbstractAction(this){
            final /* synthetic */ DialogWell this$0;
            {
                DialogWell dialogWell = this$0;
                Objects.requireNonNull(dialogWell);
                this.this$0 = dialogWell;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                this.this$0.jButtonCountryActionPerformed(e);
                this.this$0.jTextFieldCountry.setText(this.this$0.jTextFieldCountry.getText().trim());
            }
        });
        this.jPanelLocation.add((Component)this.jTextFieldCountry, "cell 1 0 2 1");
        this.jPanelLocation.add((Component)this.jTextFieldCounty, "cell 1 1 2 1");
        this.jPanelLocation.add((Component)this.jTextFieldField, "cell 1 3 2 1");
        this.jLabel24.setText(bundle.getString("DialogWell.location.gridx"));
        this.jPanelLocation.add((Component)this.jLabel24, "cell 0 7");
        this.jLabel25.setText(bundle.getString("DialogWell.location.gridy"));
        this.jPanelLocation.add((Component)this.jLabel25, "cell 0 8");
        this.jPanelLocation.add((Component)this.jTextFieldGridX, "cell 1 7");
        this.jPanelLocation.add((Component)this.jTextFieldGridY, "cell 1 8");
        this.jPanel1.setBorder(new TitledBorder(bundle.getString("DialogWell.location.coords.panel")));
        this.jPanel1.setLayout((LayoutManager)new MigLayout("insets 0 5 5 5,hidemode 3,gap 5 5", "[fill][fill][fill][left][48,fill][left][85,fill][left][97,fill]", "rel[fill][fill][fill][fill][fill][fill][fill]"));
        this.jRadioButtonDMS.setText(bundle.getString("DialogWell.location.coords.dms"));
        this.jRadioButtonDMS.addActionListener(e -> this.jRadioButtonDMSActionPerformed(e));
        this.jPanel1.add((Component)this.jRadioButtonDMS, "cell 0 0 5 1");
        this.jRadioButtonDecimalDegrees.setText(bundle.getString("DialogWell.location.coords.dd"));
        this.jRadioButtonDecimalDegrees.setSelected(true);
        this.jRadioButtonDecimalDegrees.addActionListener(e -> this.jRadioButtonDecimalDegreesActionPerformed(e));
        this.jPanel1.add((Component)this.jRadioButtonDecimalDegrees, "cell 0 3 2 1");
        this.jLabel16.setText(bundle.getString("DialogWell.location.latitude"));
        this.jPanel1.add((Component)this.jLabel16, "cell 0 1,alignx right,growx 0");
        this.jPanel1.add((Component)this.jTextFieldLatDeg, "cell 1 1 2 1");
        this.jLabel18.setText("d");
        this.jPanel1.add((Component)this.jLabel18, "cell 3 1");
        this.jPanel1.add((Component)this.jTextFieldLatMin, "cell 4 1");
        this.jLabel19.setText("m");
        this.jPanel1.add((Component)this.jLabel19, "cell 5 1");
        this.jPanel1.add((Component)this.jTextFieldLatSec, "cell 6 1");
        this.jLabel23.setText("s");
        this.jPanel1.add((Component)this.jLabel23, "cell 7 1");
        this.jComboBoxLat.setModel(new DefaultComboBoxModel<String>(new String[]{"North", "South"}));
        this.jPanel1.add(this.jComboBoxLat, "cell 8 1");
        this.jLabel17.setText(bundle.getString("DialogWell.location.longitude"));
        this.jPanel1.add((Component)this.jLabel17, "cell 0 2,alignx right,growx 0");
        this.jPanel1.add((Component)this.jTextFieldLongDeg, "cell 1 2 2 1,growx");
        this.jLabel21.setText("d");
        this.jPanel1.add((Component)this.jLabel21, "cell 3 2");
        this.jPanel1.add((Component)this.jTextFieldLongMin, "cell 4 2");
        this.jLabel22.setText("m");
        this.jPanel1.add((Component)this.jLabel22, "cell 5 2");
        this.jPanel1.add((Component)this.jTextFieldLongSec, "cell 6 2");
        this.jLabel20.setText("s");
        this.jPanel1.add((Component)this.jLabel20, "cell 7 2");
        this.jComboBoxLong.setModel(new DefaultComboBoxModel<String>(new String[]{"East", "West"}));
        this.jPanel1.add(this.jComboBoxLong, "cell 8 2");
        this.jLabel28.setText(bundle.getString("DialogWell.location.latitude"));
        this.jPanel1.add((Component)this.jLabel28, "cell 0 4,alignx right,growx 0");
        this.jPanel1.add((Component)this.jTextFieldLatDec, "cell 1 4 8 1");
        this.jLabel29.setText(bundle.getString("DialogWell.location.longitude"));
        this.jPanel1.add((Component)this.jLabel29, "cell 0 5,alignx right,growx 0");
        this.jPanel1.add((Component)this.jTextFieldLongDec, "cell 1 5 8 1");
        this.jLabel15.setText(bundle.getString("DialogWell.location.geodatum"));
        this.jPanel1.add((Component)this.jLabel15, "cell 0 6 2 1");
        this.jComboBoxGeoDatum.setModel(this.getDatumModel);
        this.jComboBoxGeoDatum.setEditable(true);
        this.jPanel1.add(this.jComboBoxGeoDatum, "cell 2 6 5 1");
        this.jPanelLocation.add((Component)this.jPanel1, "cell 0 6 4 1,growx");
        this.jButtonCountry.setText(bundle.getString("ellipsis"));
        this.jButtonCountry.setToolTipText(bundle.getString("DialogWell.location.country.toolTipText"));
        this.jButtonCountry.setPreferredSize(new Dimension(30, 22));
        this.jButtonCountry.addActionListener(e -> this.jButtonCountryActionPerformed(e));
        this.jPanelLocation.add((Component)this.jButtonCountry, "cell 3 0");
        this.jLabel26.setText(bundle.getString("DialogWell.location.basin"));
        this.jPanelLocation.add((Component)this.jLabel26, "cell 0 4");
        this.jPanelLocation.add((Component)this.jTextFieldBasin, "cell 1 4 2 1");
        this.jLabel27.setText(bundle.getString("DialogWell.location.area"));
        this.jPanelLocation.add((Component)this.jLabel27, "cell 0 5");
        this.jPanelLocation.add((Component)this.jTextFieldArea, "cell 1 5 2 1");
        this.jLabel30.setHorizontalAlignment(11);
        this.jLabel30.setText(bundle.getString("DialogWell.location.state"));
        this.jLabel30.setToolTipText("");
        this.jPanelLocation.add((Component)this.jLabel30, "cell 0 2,alignx right,growx 0");
        this.jPanelLocation.add((Component)this.jTextFieldState, "cell 1 2 2 1");
        this.jLabel32.setText(bundle.getString("DialogWell.location.utm"));
        this.jPanelLocation.add((Component)this.jLabel32, "pad 0,cell 2 7 2 1,alignx label,growx 0");
        this.jPanelLocation.add((Component)this.jTextFieldUTMZone, "cell 2 7 2 1");
        this.jTabbedPane1.addTab(bundle.getString("DialogWell.location.tab"), this.jPanelLocation);
        this.jPanelDepths.setLayout((LayoutManager)new MigLayout("insets panel,hidemode 3,gap 5 5", "[fill][57,fill][fill]", "rel[fill][fill]unrel[fill]"));
        this.jPanel6.setBorder(new TitledBorder(bundle.getString("DialogWell.depths.depthunits.panel")));
        this.jRadioButtonMetres.setText(bundle.getString("depth.units.m"));
        this.jRadioButtonMetres.setBorder(BorderFactory.createEmptyBorder());
        this.jRadioButtonMetres.setMargin(new Insets(0, 0, 0, 0));
        this.jRadioButtonFeet.setText(bundle.getString("depth.units.f"));
        this.jRadioButtonFeet.setBorder(BorderFactory.createEmptyBorder());
        this.jRadioButtonFeet.setMargin(new Insets(0, 0, 0, 0));
        GroupLayout jPanel6Layout = new GroupLayout(this.jPanel6);
        this.jPanel6.setLayout(jPanel6Layout);
        jPanel6Layout.setHorizontalGroup(jPanel6Layout.createParallelGroup().addGroup(jPanel6Layout.createSequentialGroup().addContainerGap().addGroup(jPanel6Layout.createParallelGroup().addComponent(this.jRadioButtonMetres).addComponent(this.jRadioButtonFeet)).addContainerGap(94, Short.MAX_VALUE)));
        jPanel6Layout.setVerticalGroup(jPanel6Layout.createParallelGroup().addGroup(jPanel6Layout.createSequentialGroup().addContainerGap().addComponent(this.jRadioButtonMetres).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jRadioButtonFeet).addContainerGap(46, Short.MAX_VALUE)));
        this.jPanelDepths.add((Component)this.jPanel6, "cell 0 0 2 1");
        this.jPanel7.setBorder(new TitledBorder(bundle.getString("DialogWell.depths.refpoints.panel")));
        this.jPanel7.setLayout((LayoutManager)new MigLayout("insets panel,hidemode 3,gap 5 5", "[right][162,grow,fill]", "[fill][fill][fill][fill][fill]"));
        this.jTextFieldRTE.setPreferredSize(new Dimension(60, 20));
        this.jTextFieldRTE.setToolTipText(bundle.getString("DialogWell.jTextFieldRTE.toolTipTextWell"));
        this.jPanel7.add((Component)this.jTextFieldRTE, "cell 1 0");
        this.jTextFieldSL.setPreferredSize(new Dimension(60, 20));
        this.jTextFieldSL.setToolTipText(bundle.getString("DialogWell.jTextFieldSL.toolTipTextWell"));
        this.jPanel7.add((Component)this.jTextFieldSL, "cell 1 1");
        this.jTextFieldSB.setPreferredSize(new Dimension(60, 20));
        this.jTextFieldSB.setToolTipText(bundle.getString("DialogWell.jTextFieldSB.toolTipTextWell"));
        this.jPanel7.add((Component)this.jTextFieldSB, "cell 1 2");
        this.jLabelKickOff.setText(bundle.getString("DialogWell.depths.refpoints.kickoff"));
        this.jPanel7.add((Component)this.jLabelKickOff, "cell 0 3");
        this.jLabelTD.setForeground(new Color(0xCC0000));
        this.jLabelTD.setText(bundle.getString("DialogWell.depths.refpoints.td.label"));
        this.jPanel7.add((Component)this.jLabelTD, "cell 0 4");
        this.jTextFieldKO.setPreferredSize(new Dimension(60, 20));
        this.jTextFieldKO.setToolTipText(bundle.getString("DialogWell.jTextFieldKO.toolTipTextWell"));
        this.jPanel7.add((Component)this.jTextFieldKO, "cell 1 3");
        this.jTextFieldTD.setPreferredSize(new Dimension(60, 20));
        this.jTextFieldTD.setToolTipText(bundle.getString("DialogWell.jTextFieldTD.toolTipTextWell"));
        this.jPanel7.add((Component)this.jTextFieldTD, "cell 1 4");
        this.jLabelRTE.setText(bundle.getString("DialogWell.depths.refpoints.rte"));
        this.jPanel7.add((Component)this.jLabelRTE, "cell 0 0");
        this.jLabelSL.setText(bundle.getString("DialogWell.depths.refpoints.rigelevation"));
        this.jPanel7.add((Component)this.jLabelSL, "cell 0 1");
        this.jLabelDSB.setText(bundle.getString("DialogWell.depths.refpoints.sbdepth"));
        this.jPanel7.add((Component)this.jLabelDSB, "cell 0 2");
        this.jPanelDepths.add((Component)this.jPanel7, "cell 0 1 3 1");
        this.jPanel8.setBorder(new TitledBorder(bundle.getString("DialogWell.depths.depthdatum.panel")));
        this.jPanel8.setToolTipText("The point from which the sample depths are measured");
        this.jRadioButtonRTE.setSelected(true);
        this.jRadioButtonRTE.setText(bundle.getString("DialogWell.depths.depthdatum.rt"));
        this.jRadioButtonRTE.setBorder(BorderFactory.createEmptyBorder());
        this.jRadioButtonRTE.setMargin(new Insets(0, 0, 0, 0));
        this.jRadioButtonSL.setText(bundle.getString("DialogWell.depths.depthdatum.sl"));
        this.jRadioButtonSL.setBorder(BorderFactory.createEmptyBorder());
        this.jRadioButtonSL.setMargin(new Insets(0, 0, 0, 0));
        this.jRadioButtonSB.setText(bundle.getString("DialogWell.depths.depthdatum.sb"));
        this.jRadioButtonSB.setBorder(BorderFactory.createEmptyBorder());
        this.jRadioButtonSB.setMargin(new Insets(0, 0, 0, 0));
        GroupLayout jPanel8Layout = new GroupLayout(this.jPanel8);
        this.jPanel8.setLayout(jPanel8Layout);
        jPanel8Layout.setHorizontalGroup(jPanel8Layout.createParallelGroup().addGroup(jPanel8Layout.createSequentialGroup().addContainerGap().addGroup(jPanel8Layout.createParallelGroup().addComponent(this.jRadioButtonRTE).addComponent(this.jRadioButtonSL).addComponent(this.jRadioButtonSB)).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel8Layout.linkSize(0, this.jRadioButtonRTE, this.jRadioButtonSB, this.jRadioButtonSL);
        jPanel8Layout.setVerticalGroup(jPanel8Layout.createParallelGroup().addGroup(jPanel8Layout.createSequentialGroup().addContainerGap().addComponent(this.jRadioButtonRTE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jRadioButtonSL).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jRadioButtonSB).addContainerGap(22, Short.MAX_VALUE)));
        this.jPanelDepths.add((Component)this.jPanel8, "cell 2 0");
        this.jLabel33.setText(bundle.getString("DialogWell.depths.defaultscale"));
        this.jPanelDepths.add((Component)this.jLabel33, "cell 0 2,gapx 5");
        this.jComboBoxChartScale.setModel(this.scaleModel);
        this.jComboBoxChartScale.setEditable(true);
        this.jPanelDepths.add(this.jComboBoxChartScale, "cell 1 2 2 1");
        this.jTabbedPane1.addTab(bundle.getString("DialogWell.depths.tab"), this.jPanelDepths);
        contentPanel.add(this.jTabbedPane1);
        this.pack();
        this.setLocationRelativeTo(this.getOwner());
        this.buttonGroupType.add(this.jRadioButtonWell);
        this.buttonGroupType.add(this.jRadioButtonOutcrop);
        this.buttonGroupCoordinates.add(this.jRadioButtonDMS);
        this.buttonGroupCoordinates.add(this.jRadioButtonDecimalDegrees);
        this.buttonGroupDepthUnits.add(this.jRadioButtonMetres);
        this.buttonGroupDepthUnits.add(this.jRadioButtonFeet);
        this.buttonGroupDatum.add(this.jRadioButtonRTE);
        this.buttonGroupDatum.add(this.jRadioButtonSL);
        this.buttonGroupDatum.add(this.jRadioButtonSB);
    }

    private void init(Well initOnly) throws SQLException {
        model3.WellHeader header;
        block18: {
            header = null;
            this.jTextFieldWellName.requestFocusInWindow();
            if (!this.sbdb.hasWellsMaster()) {
                this.jButtonSelectMaster.setVisible(false);
            }
            super.addOkButtonActionListener(new ActionListener(this){
                final /* synthetic */ DialogWell this$0;
                {
                    DialogWell dialogWell = this$0;
                    Objects.requireNonNull(dialogWell);
                    this.this$0 = dialogWell;
                }

                @Override
                public void actionPerformed(ActionEvent e) {
                    this.this$0.jButtonOKActionPerformed();
                }
            });
            List<Integer> chartScales = this.sbdb.getChartScales();
            this.scaleModel.removeAllElements();
            for (Integer iScale : chartScales) {
                this.scaleModel.addElement(iScale.toString());
            }
            this.scaleModel.setSelectedItem("2000.0");
            this.getDatumModel.removeAllElements();
            this.getDatumModel.addElement("");
            for (GeoDatum g : GeoDatum.values()) {
                this.getDatumModel.addElement(g.getName());
            }
            if (this.well == null) {
                this.setTitle("Well : Add");
                if (initOnly != null) {
                    header = initOnly.getHeader();
                } else {
                    try {
                        char units = Lastval.getChar(this.sbdb, "WELL_UNITS");
                        if (units == 'F') {
                            this.jRadioButtonFeet.setSelected(true);
                        } else {
                            this.jRadioButtonMetres.setSelected(true);
                        }
                        char sectionType = Lastval.getChar(this.sbdb, "WELL_TYPE");
                        if (sectionType == 'O') {
                            this.jRadioButtonOutcrop.setSelected(true);
                            break block18;
                        }
                        this.jRadioButtonWell.setSelected(true);
                    }
                    catch (SQLException ex) {
                        ex.printStackTrace();
                    }
                }
            } else {
                this.setTitle("Well : Edit : " + this.well.getWellName());
                if (!this.well.canWrite(this.sbdb, null)) {
                    super.enbaleOkButton(false, this.well.getDeniedReason(this.sbdb, "well", false));
                }
                header = this.well.getHeader();
            }
        }
        if (header != null) {
            WellHeader domainHeader = header.getWellHeaderCopy();
            this.initDetails(domainHeader, false);
            this.jPanelAudit.setAuditText(header.getCreator(), header.getCreated(), header.getModifier(), header.getModified());
            if (domainHeader.getParentWellID() != null) {
                try {
                    this.parentWell = this.sbdb.getWell(domainHeader.getParentWellID());
                    this.jTextFieldParent.setText(this.parentWell.toString());
                }
                catch (RuntimeException | SQLException | SBException ex) {
                    SbugsExceptionHandler.showStackError("Could not load parent well", ex, (Component)((Object)this));
                }
            }
        }
        this.setCoordinateControls(false);
        this.setDepthLabels();
        if (!this.sbdb.isConnected()) {
            this.jButtonCountry.setEnabled(false);
        }
    }

    private void initDetails(WellHeader header, boolean isParent) {
        if (!isParent) {
            this.jTextFieldWellName.setText(header.getWellName());
            this.jTextFieldWellAltName.setText(header.getWellAltName());
            this.jTextFieldWellCode.setText(header.getWellCode());
            this.jTextFieldSpud.setText(header.getSpudDate() == null ? "" : header.getSpudDate().format(DateUtils.DISPLAY_FORMAT));
            this.jTextFieldCompletion.setText(header.getCompletionDate() == null ? "" : header.getCompletionDate().format(DateUtils.DISPLAY_FORMAT));
            this.jTextAreaComment.setText(header.getDescription());
            this.jTextFieldColour.setBackground(header.getColour());
        }
        this.jTextFieldOCS.setText(header.getOcs());
        this.jTextFieldOperator.setText(header.getOperator());
        this.jTextFieldClient.setText(header.getClient());
        this.jRadioButtonWell.setSelected(header.getSectionType() == SectionType.WELL);
        this.jRadioButtonOutcrop.setSelected(header.getSectionType() == SectionType.OUTCROP);
        this.jTextFieldCountry.setText(header.getCountry());
        this.jTextFieldCounty.setText(header.getCounty());
        this.jTextFieldField.setText(header.getField());
        this.jTextFieldState.setText(header.getLocState());
        this.jTextFieldBasin.setText(header.getBasin());
        this.jTextFieldArea.setText(header.getArea());
        this.jComboBoxGeoDatum.setSelectedItem(header.getGeoDatum());
        DegreesMinutesSecondsCoordinate lat = header.getLatitudeCoordinate();
        if (lat != null) {
            this.jTextFieldLatDeg.setText(String.valueOf(lat.degrees()));
            this.jTextFieldLatMin.setText(String.valueOf(lat.minutes()));
            this.jTextFieldLatSec.setText(SB.floatString((float)lat.seconds(), (int)3).trim());
            Double latDec = header.getLat_dec();
            if (latDec != null) {
                latDec = BigDecimal.valueOf(latDec).setScale(6, RoundingMode.HALF_UP).doubleValue();
            }
            this.jTextFieldLatDec.setText(String.valueOf(latDec));
        }
        this.jComboBoxLat.setSelectedIndex(lat != null && lat.ind() == 'N' ? 0 : 1);
        DegreesMinutesSecondsCoordinate longC = header.getLongitudeCoordinate();
        if (longC != null) {
            this.jTextFieldLongDeg.setText(String.valueOf(longC.degrees()));
            this.jTextFieldLongMin.setText(String.valueOf(longC.minutes()));
            this.jTextFieldLongSec.setText(SB.floatString((float)longC.seconds(), (int)3).trim());
            Double longDec = header.getLong_dec();
            if (longDec != null) {
                longDec = BigDecimal.valueOf(longDec).setScale(6, RoundingMode.HALF_UP).doubleValue();
            }
            this.jTextFieldLongDec.setText(String.valueOf(longDec));
        }
        this.jComboBoxLong.setSelectedIndex(longC != null && longC.ind() == 'E' ? 0 : 1);
        if (header.getGridX() != 0.0) {
            this.jTextFieldGridX.setText(String.valueOf(header.getGridX()));
        }
        if (header.getGridY() != 0.0) {
            this.jTextFieldGridY.setText(String.valueOf(header.getGridY()));
        }
        this.jTextFieldUTMZone.setText(header.getUtmZone());
        this.jTextFieldRTE.setText(DepthStringUtils.getDepthStringValueOrEmpty(header.getRotaryTableElevation(), header.getUnits()));
        this.jTextFieldSL.setText(DepthStringUtils.getDepthStringValueOrEmpty(header.getSeaLevel(), header.getUnits()));
        this.jTextFieldSB.setText(DepthStringUtils.getDepthStringValueOrEmpty(header.getSeaBed(), header.getUnits()));
        if (!isParent) {
            this.jTextFieldTD.setText(DepthStringUtils.getDepthStringValueOrEmpty(header.getTerminalDepth(), header.getUnits(), header.getSectionType()));
            this.jTextFieldKO.setText(DepthStringUtils.getDepthStringValueOrEmpty(header.getKickOff(), header.getUnits(), header.getSectionType()));
        }
        this.buttonGroupDepthUnits.setSelected(header.getUnits() == DepthUnits.F ? this.jRadioButtonFeet.getModel() : this.jRadioButtonMetres.getModel(), true);
        switch (header.getDatum()) {
            default: {
                this.buttonGroupDatum.setSelected(this.jRadioButtonRTE.getModel(), true);
                break;
            }
            case SEA_LEVEL: {
                this.buttonGroupDatum.setSelected(this.jRadioButtonSL.getModel(), true);
                break;
            }
            case SEA_BED: {
                this.buttonGroupDatum.setSelected(this.jRadioButtonSB.getModel(), true);
            }
        }
        if (header.getDefaultChartScale() > 0.0f) {
            String sScale = Integer.toString((int)header.getDefaultChartScale());
            if (this.scaleModel.getIndexOf(sScale) < 0) {
                this.scaleModel.addElement(sScale);
            }
            this.scaleModel.setSelectedItem(sScale);
        }
    }

    private void jButtonSelectParentActionPerformed() {
        DialogSelectWell dialog = new DialogSelectWell((JDialog)((Object)this), true, this.sbdb, false, this.jTextFieldWellName.getText().trim());
        dialog.setLocationRelativeTo((Component)((Object)this));
        dialog.setVisible(true);
        if (dialog.getReturnCode() != DialogBase.ReturnCode.SUCCESS) {
            return;
        }
        this.parentWell = dialog.getSelected();
        this.jTextFieldParent.setText(this.parentWell.toString());
        int opt = JOptionPane.showConfirmDialog((Component)((Object)this), "Copy header data from parent?", "Select Parent Well", 0, 3);
        if (opt == 0) {
            this.initDetails(this.parentWell.getHeader().getWellHeaderCopy(), true);
        }
    }

    private void jButtonClearParentActionPerformed() {
        this.parentWell = null;
        this.jTextFieldParent.setText("");
    }

    private void saveDefaults() throws SQLException {
        if (this.sbdb.isConnected()) {
            Lastval.putChar(this.sbdb, "WELL_UNITS", this.jRadioButtonFeet.isSelected() ? (char)'F' : 'M');
            Lastval.putChar(this.sbdb, "WELL_TYPE", this.jRadioButtonOutcrop.isSelected() ? (char)'O' : 'W');
        }
    }

    private LocalDate parseDate(String s) {
        LocalDate d;
        try {
            d = !s.isEmpty() ? LocalDate.parse(s, DateUtils.DISPLAY_FORMAT) : null;
        }
        catch (DateTimeParseException e) {
            try {
                d = LocalDate.parse(s, DateUtils.DISPLAY_FORMAT_UK);
            }
            catch (DateTimeParseException e2) {
                JOptionPane.showMessageDialog((Component)((Object)this), "Can't parse date: " + s + ".\n\nExample format: " + LocalDate.parse("2024-09-01").format(DateUtils.DISPLAY_FORMAT), this.getTitle(), 1);
                throw e;
            }
        }
        return d;
    }

    private WellHeader getFieldDataAsDomain() throws DateTimeParseException {
        WellHeader header = new WellHeader();
        header.setWellName(this.jTextFieldWellName.getText().trim());
        header.setWellCode(this.jTextFieldWellCode.getText().trim().toUpperCase());
        header.setWellAltName(this.jTextFieldWellAltName.getText().trim());
        header.setOcs(this.jTextFieldOCS.getText().trim());
        header.setOperator(this.jTextFieldOperator.getText().trim());
        header.setClient(this.jTextFieldClient.getText().trim());
        header.setSectionType(this.jRadioButtonWell.isSelected() ? SectionType.WELL : SectionType.OUTCROP);
        if (this.parentWell != null) {
            header.setParentWellID(Integer.valueOf(this.parentWell.getWellID()));
        }
        header.setSpudDate(this.parseDate(this.jTextFieldSpud.getText().trim()));
        header.setCompletionDate(this.parseDate(this.jTextFieldCompletion.getText().trim()));
        header.setCountry(this.sbdb.allowCountryCase() ? this.jTextFieldCountry.getText() : this.jTextFieldCountry.getText().toUpperCase());
        header.setCounty(this.jTextFieldCounty.getText().trim());
        header.setField(this.jTextFieldField.getText().trim());
        header.setLocState(this.jTextFieldState.getText().trim());
        header.setBasin(this.jTextFieldBasin.getText().trim());
        header.setArea(this.jTextFieldArea.getText().trim());
        header.setGeoDatum(this.jComboBoxGeoDatum.getSelectedItem().toString());
        if (this.jRadioButtonDecimalDegrees.isSelected()) {
            if (!this.jTextFieldLatDec.getText().isBlank()) {
                double latValue = Double.parseDouble(this.jTextFieldLatDec.getText().trim());
                header.setLat_dec(Double.valueOf(latValue));
            } else {
                header.setLat_dec(null);
            }
            if (!this.jTextFieldLongDec.getText().isBlank()) {
                double longValue = Double.parseDouble(this.jTextFieldLongDec.getText());
                header.setLong_dec(Double.valueOf(longValue));
            } else {
                header.setLong_dec(null);
            }
        } else {
            String latDegStr = this.jTextFieldLatDeg.getText();
            String latMinStr = this.jTextFieldLatMin.getText();
            String latSecStr = this.jTextFieldLatSec.getText();
            if (!(latDegStr.isBlank() && latMinStr.isBlank() && latSecStr.isBlank())) {
                short latDeg = Short.parseShort(DialogWell.nullNumber(latDegStr));
                short latMin = Short.parseShort(DialogWell.nullNumber(latMinStr));
                float latSec = Float.parseFloat(DialogWell.nullNumber(latSecStr));
                double decimalLat = new DegreesMinutesSecondsCoordinate(latDeg, latMin, latSec, this.jComboBoxLat.getSelectedIndex() == 0 ? (char)'N' : 'S').getDecimalDegrees();
                if (header.getLat_dec() == null || Math.abs(decimalLat - header.getLat_dec()) > 1.0E-5) {
                    header.setLat_dec(Double.valueOf(decimalLat));
                }
            } else if (header.getLat_dec() != null) {
                header.setLat_dec(null);
            }
            String longDegStr = this.jTextFieldLongDeg.getText();
            String longMinStr = this.jTextFieldLongMin.getText();
            String longSecStr = this.jTextFieldLongSec.getText();
            if (!(longDegStr.isBlank() && longMinStr.isBlank() && longSecStr.isBlank())) {
                short longDeg = Short.parseShort(DialogWell.nullNumber(longDegStr));
                short longMin = Short.parseShort(DialogWell.nullNumber(longMinStr));
                float longSec = Float.parseFloat(DialogWell.nullNumber(longSecStr));
                double decimalLong = new DegreesMinutesSecondsCoordinate(longDeg, longMin, longSec, this.jComboBoxLong.getSelectedIndex() == 0 ? (char)'E' : 'W').getDecimalDegrees();
                if (header.getLong_dec() == null || Math.abs(decimalLong - header.getLong_dec()) > 1.0E-5) {
                    header.setLong_dec(Double.valueOf(decimalLong));
                }
            } else if (header.getLong_dec() != null) {
                header.setLong_dec(null);
            }
        }
        header.setGridX(Double.parseDouble(DialogWell.nullNumber(this.jTextFieldGridX.getText())));
        header.setGridY(Double.parseDouble(DialogWell.nullNumber(this.jTextFieldGridY.getText())));
        header.setUtmZone(this.jTextFieldUTMZone.getText());
        header.setUnits(this.jRadioButtonFeet.isSelected() ? DepthUnits.F : DepthUnits.M);
        header.setTerminalDepth(DepthUtils.convToM((double)Double.parseDouble(DialogWell.nullNumber(this.jTextFieldTD.getText())), (DepthUnits)header.getUnits(), (SectionType)header.getSectionType()));
        header.setKickOff(DepthStringUtils.getNullableDepthFromString(this.jTextFieldKO.getText(), header.getUnits(), header.getSectionType()));
        header.setRotaryTableElevation(DepthStringUtils.getNullableDepthFromString(this.jTextFieldRTE.getText(), header.getUnits()));
        header.setSeaLevel(DepthStringUtils.getNullableDepthFromString(this.jTextFieldSL.getText(), header.getUnits()));
        header.setSeaBed(DepthStringUtils.getNullableDepthFromString(this.jTextFieldSB.getText(), header.getUnits()));
        if (this.jRadioButtonRTE.isSelected()) {
            header.setDatum(WellDatum.ROTARY_TABLE);
        } else if (this.jRadioButtonSL.isSelected()) {
            header.setDatum(WellDatum.SEA_LEVEL);
        } else if (this.jRadioButtonSB.isSelected()) {
            header.setDatum(WellDatum.SEA_BED);
        }
        header.setDefaultChartScale(Float.parseFloat(this.jComboBoxChartScale.getSelectedItem().toString()));
        header.setDescription(this.jTextAreaComment.getText());
        header.setColour(this.jTextFieldColour.getBackground());
        return header;
    }

    private void jButtonOKActionPerformed() {
        int result;
        int opt;
        WellHeader fieldData;
        if (this.jRadioButtonWell.isSelected() && this.jTextFieldTD.getText().trim().isEmpty()) {
            JOptionPane.showMessageDialog((Component)((Object)this), this.resources.getString("DialogWell.message.musthaveentry") + " " + this.resources.getString("DialogWell.depths.refpoints.td"), this.getTitle(), 1);
            return;
        }
        try {
            fieldData = this.getFieldDataAsDomain();
        }
        catch (DateTimeParseException e) {
            return;
        }
        SbugsValidator validator = SbugsValidator.validate((Object)fieldData, (SbugsValidator.ValidationStrategy)SbugsValidator.ValidationStrategy.IGNORE_ID);
        if (!validator.isValid()) {
            String message = "Invalid data: \n" + StringUtils.join((Iterable)validator.getMessages(), (String)"\n");
            JOptionPane.showMessageDialog((Component)((Object)this), message, this.getTitle(), 0);
            return;
        }
        if (this.parentWell != null && fieldData.getKickOff() > this.parentWell.getTD()) {
            String message = "Kick-off depth should be above the parent well's terminal depth (" + DepthUtils.depthString((double)this.parentWell.getTD(), (DepthUnits)fieldData.getUnits(), (int)2, (SectionType)SectionType.WELL, (boolean)true).trim() + ")";
            JOptionPane.showMessageDialog((Component)((Object)this), message, this.getTitle(), 0);
            return;
        }
        String geoDatum = this.jComboBoxGeoDatum.getSelectedItem().toString();
        if (!geoDatum.isBlank() && GeoDatum.parseEpsgCode((String)geoDatum, (boolean)false).isBlank() && ((opt = JOptionPane.showConfirmDialog((Component)((Object)this), "Warning: coordinate reference system (geo datum): " + geoDatum + " is not recognised.\nContinue to use this value?", "Well Header", 0, 3)) == 1 || opt == 2)) {
            return;
        }
        if ((fieldData.getLat_dec() != null && Math.abs(fieldData.getLat_dec()) < 1.0E-7 || fieldData.getLong_dec() != null && Math.abs(fieldData.getLong_dec()) < 1.0E-7) && (result = JOptionPane.showConfirmDialog((Component)((Object)this), "The latitude or longitude is set to 0, are you sure you want to continue?", this.getTitle(), 0, 3)) != 0) {
            return;
        }
        try {
            if (this.well == null) {
                this.well = this.sbdb.addWell(fieldData);
            } else {
                if (fieldData.getUnits() != this.well.getHeader().getDepthUnits() && this.well.hasDepthData()) {
                    String leaveString;
                    String convString;
                    if (this.well.getWellUnits() == 'M') {
                        convString = "1m becomes 1ft";
                        leaveString = "1m becomes 3.28ft";
                    } else {
                        convString = "1ft becomes 1m";
                        leaveString = "1ft becomes 0.38m";
                    }
                    Object strg = "You have changed the depth units.";
                    strg = (String)strg + "\nDo you want to convert existing samples and well data, e.g. " + convString + "?\n(Press NO to not convert, and leave existing data e.g. " + leaveString + ")";
                    int opt2 = JOptionPane.showConfirmDialog((Component)((Object)this), strg, this.getTitle(), 1, 3);
                    if (opt2 == 2 || opt2 == -1) {
                        return;
                    }
                    if (opt2 == 0) {
                        this.well.updateDepthUnits();
                    }
                }
                this.well.update(fieldData);
            }
            if (this.sbdb.isConnected()) {
                this.sbdb.commit();
                this.well.getHeader().updateFromMaster(this.sbdb, true, this.well.getWellID());
                this.well.getCasing().updateFromMaster(this.well.getWellID(), this.well.getWellCode());
                this.well.getCores().updateFromMaster(this.well.getWellID(), this.well.getWellCode());
                this.well.getMarkers().updateFromMaster(this.well.getWellID(), this.well.getWellCode());
                this.saveDefaults();
                this.sbdb.commit();
            }
            super.returnWithCode(DialogBase.ReturnCode.SUCCESS);
        }
        catch (RuntimeException | SQLException | InvalidFieldException | SBException | SBPermissionException e) {
            SbugsExceptionHandler.showStackError(e, (Component)((Object)this));
        }
    }

    private void jButtonCountryActionPerformed(ActionEvent evt) {
        try {
            List<String> list = model3.WellHeader.getCountries(this.sbdb);
            DialogList<String> dialog = new DialogList<String>((JDialog)((Object)this), true, "Select Country", new UserPrefsHelper(this.sbdb), list, true, false);
            dialog.setLocationRelativeTo((Component)((Object)this));
            dialog.setVisible(true);
            if (dialog.getSelection() != null) {
                this.jTextFieldCountry.setText(dialog.getSelection());
            }
        }
        catch (SQLException ex) {
            SbugsExceptionHandler.showStackError(ex, (Component)((Object)this));
        }
    }

    private void jRadioButtonDecimalDegreesActionPerformed(ActionEvent evt) {
        this.setCoordinateControls(false);
    }

    private void jRadioButtonDMSActionPerformed(ActionEvent evt) {
        this.setCoordinateControls(true);
    }

    private void jButtonColourActionPerformed(ActionEvent evt) {
        Color colour = JColorChooser.showDialog((Component)((Object)this), "Colour : Select", this.jTextFieldColour.getBackground());
        if (colour != null) {
            this.jTextFieldColour.setBackground(colour);
        }
    }

    private void jButtonSelectMasterActionPerformed(ActionEvent evt) {
        DialogSelectWellMaster dialog = new DialogSelectWellMaster((JDialog)((Object)this), true, this.sbdb, this.jTextFieldWellName.getText());
        dialog.setLocationRelativeTo((Component)((Object)this));
        dialog.setVisible(true);
        if (dialog.selectedWellCode != null) {
            try {
                WellHeader fieldData = this.getFieldDataAsDomain();
                fieldData.setWellCode(dialog.selectedWellCode);
                model3.WellHeader.updateFromMaster(this.sbdb, fieldData);
                this.initDetails(fieldData, false);
            }
            catch (RuntimeException | SQLException ex) {
                SbugsExceptionHandler.showStackError(ex, (Component)((Object)this));
            }
        }
    }

    private void jButtonMakeCodeActionPerformed(ActionEvent evt) {
        this.jTextFieldWellCode.setText(Well.makeCode(this.jTextFieldWellCode.getText()));
    }

    private void jButtonCopyToCodeActionPerformed() {
        this.jTextFieldWellCode.setText(this.jTextFieldWellName.getText());
    }

    private void jRadioButtonOutcropActionPerformed(ActionEvent evt) {
        this.setDepthLabels();
    }

    private void jRadioButtonWellActionPerformed(ActionEvent evt) {
        this.setDepthLabels();
    }

    private void setDepthLabels() {
        Color red = new Color(240, 0, 0);
        this.jLabelTD.setText(this.resources.getString(this.jRadioButtonOutcrop.isSelected() ? "DialogWell.depths.refpoints.tdbase" : "DialogWell.depths.refpoints.td.label"));
        this.jLabelTD.setForeground(this.jRadioButtonOutcrop.isSelected() ? Color.BLACK : red);
        this.jLabelKickOff.setText(this.resources.getString(this.jRadioButtonOutcrop.isSelected() ? "DialogWell.depths.refpoints.topofsection.label" : "DialogWell.depths.refpoints.kickoff"));
        this.jLabelKickOff.setForeground(this.jRadioButtonOutcrop.isSelected() ? red : Color.BLACK);
        this.jLabelRTE.setEnabled(!this.jRadioButtonOutcrop.isSelected());
        this.jTextFieldRTE.setEnabled(!this.jRadioButtonOutcrop.isSelected());
        this.jLabelDSB.setEnabled(!this.jRadioButtonOutcrop.isSelected());
        this.jTextFieldSB.setEnabled(!this.jRadioButtonOutcrop.isSelected());
        this.jLabelSL.setText(this.resources.getString(this.jRadioButtonOutcrop.isSelected() ? "DialogWell.depths.refpoints.datumheight" : "DialogWell.depths.refpoints.rigelevation"));
        if (this.jRadioButtonOutcrop.isSelected()) {
            this.jRadioButtonSL.setText(this.resources.getString("DialogWell.depths.depthdatum.outcrop"));
            this.jRadioButtonSL.setSelected(true);
            this.jRadioButtonRTE.setEnabled(false);
            this.jRadioButtonSB.setEnabled(false);
            this.jTextFieldTD.setToolTipText(null);
            this.jTextFieldKO.setToolTipText(null);
            this.jTextFieldRTE.setToolTipText(null);
            this.jTextFieldSB.setToolTipText(null);
            this.jTextFieldSL.setToolTipText(null);
        } else {
            this.jRadioButtonSL.setText(this.resources.getString("DialogWell.depths.depthdatum.sl"));
            this.jRadioButtonSB.setEnabled(true);
            this.jRadioButtonRTE.setEnabled(true);
            this.jTextFieldTD.setToolTipText(this.resources.getString("DialogWell.jTextFieldTD.toolTipTextWell"));
            this.jTextFieldKO.setToolTipText(this.resources.getString("DialogWell.jTextFieldKO.toolTipTextWell"));
            this.jTextFieldRTE.setToolTipText(this.resources.getString("DialogWell.jTextFieldRTE.toolTipTextWell"));
            this.jTextFieldSB.setToolTipText(this.resources.getString("DialogWell.jTextFieldSB.toolTipTextWell"));
            this.jTextFieldSL.setToolTipText(this.resources.getString("DialogWell.jTextFieldSL.toolTipTextWell"));
        }
    }

    public Well getWell() {
        return this.well;
    }

    private void setCoordinateControls(boolean dms) {
        this.jTextFieldLatDeg.setEnabled(dms);
        this.jTextFieldLatMin.setEnabled(dms);
        this.jTextFieldLatSec.setEnabled(dms);
        this.jComboBoxLat.setEnabled(dms);
        this.jTextFieldLatDec.setEnabled(!dms);
        this.jTextFieldLongDeg.setEnabled(dms);
        this.jTextFieldLongMin.setEnabled(dms);
        this.jTextFieldLongSec.setEnabled(dms);
        this.jComboBoxLong.setEnabled(dms);
        this.jTextFieldLongDec.setEnabled(!dms);
    }

    private static String nullNumber(String s) {
        if ((s = StringUtils.stripToEmpty((String)s)).isEmpty()) {
            s = "0";
        }
        return s;
    }

    private static JTextField buildWellHeaderDepthField() {
        return TextFieldUtils.buildDecimalOnlyTextField(true, 9.9999999999E7, 3);
    }
}

