/*
 * Decompiled with CFR 0.152.
 */
package jsbugs.wells;

import com.stratadata.util.ui.SBDialog;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.SQLException;
import java.util.LinkedList;
import java.util.Objects;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import jsbugs.FrameJsbugs;
import model3.SBRestrictable;
import model3.SBdb;
import org.jdesktop.layout.GroupLayout;
import util.SBException;
import util.SBPermissionException;

public class DialogCasingDiam
extends SBDialog {
    private final TableModelString model = new TableModelString(this);
    private final SBdb db;
    private final LinkedList<String> data;
    String selection = "";
    private JButton jButtonAdd;
    private JButton jButtonCancel;
    private JButton jButtonDelete;
    private JButton jButtonHelp;
    private JButton jButtonInsert;
    private JButton jButtonOK;
    private JScrollPane jScrollPane2;
    private JTable jTableDiam;

    public DialogCasingDiam(JDialog parent, boolean modal, SBdb db) throws SQLException {
        super((Window)parent, modal);
        this.db = db;
        this.data = new LinkedList<String>(db.getCasingDiameters());
        this.initComponents();
        this.init();
    }

    private void init() throws SQLException {
        this.jTableDiam.setSelectionMode(0);
        this.jTableDiam.getTableHeader().getColumnModel().getColumn(0).setHeaderValue("Diameter");
        this.setTitle("Casing Diameters : Edit");
        if (!SBRestrictable.canWrite(this.db)) {
            this.jButtonOK.setEnabled(false);
            this.jButtonOK.setToolTipText(SBRestrictable.getDeniedReason(false));
        } else {
            this.getRootPane().setDefaultButton(this.jButtonOK);
        }
    }

    private void initComponents() {
        this.jButtonAdd = new JButton();
        this.jButtonDelete = new JButton();
        this.jScrollPane2 = new JScrollPane();
        this.jTableDiam = new JTable();
        this.jButtonCancel = new JButton();
        this.jButtonOK = new JButton();
        this.jButtonInsert = new JButton();
        this.jButtonHelp = new JButton();
        this.setDefaultCloseOperation(2);
        this.setMinimumSize(new Dimension(220, 300));
        this.jButtonAdd.setText("Add row");
        this.jButtonAdd.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogCasingDiam this$0;
            {
                DialogCasingDiam dialogCasingDiam = this$0;
                Objects.requireNonNull(dialogCasingDiam);
                this.this$0 = dialogCasingDiam;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonAddActionPerformed(evt);
            }
        });
        this.jButtonDelete.setText("Remove");
        this.jButtonDelete.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogCasingDiam this$0;
            {
                DialogCasingDiam dialogCasingDiam = this$0;
                Objects.requireNonNull(dialogCasingDiam);
                this.this$0 = dialogCasingDiam;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonDeleteActionPerformed(evt);
            }
        });
        this.jTableDiam.setModel(this.model);
        this.jScrollPane2.setViewportView(this.jTableDiam);
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogCasingDiam this$0;
            {
                DialogCasingDiam dialogCasingDiam = this$0;
                Objects.requireNonNull(dialogCasingDiam);
                this.this$0 = dialogCasingDiam;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonCancelActionPerformed(evt);
            }
        });
        this.jButtonOK.setText("OK");
        this.jButtonOK.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogCasingDiam this$0;
            {
                DialogCasingDiam dialogCasingDiam = this$0;
                Objects.requireNonNull(dialogCasingDiam);
                this.this$0 = dialogCasingDiam;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonOKActionPerformed(evt);
            }
        });
        this.jButtonInsert.setText("Insert row");
        this.jButtonInsert.setMargin(new Insets(2, 10, 2, 10));
        this.jButtonInsert.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogCasingDiam this$0;
            {
                DialogCasingDiam dialogCasingDiam = this$0;
                Objects.requireNonNull(dialogCasingDiam);
                this.this$0 = dialogCasingDiam;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonInsertActionPerformed(evt);
            }
        });
        this.jButtonHelp.setText("Help");
        this.jButtonHelp.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogCasingDiam this$0;
            {
                DialogCasingDiam dialogCasingDiam = this$0;
                Objects.requireNonNull(dialogCasingDiam);
                this.this$0 = dialogCasingDiam;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonHelpActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(2, (GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.jScrollPane2, -1, 119, Short.MAX_VALUE).addPreferredGap(1).add((GroupLayout.Group)layout.createParallelGroup(2, false).add((Component)this.jButtonCancel, -1, -1, Short.MAX_VALUE).add((Component)this.jButtonOK, -1, -1, Short.MAX_VALUE).add((Component)this.jButtonAdd, -1, 75, Short.MAX_VALUE).add((Component)this.jButtonInsert, -1, -1, Short.MAX_VALUE).add((Component)this.jButtonDelete, -1, 75, Short.MAX_VALUE).add(1, (Component)this.jButtonHelp, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        layout.linkSize(new Component[]{this.jButtonAdd, this.jButtonDelete, this.jButtonInsert}, 1);
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(2, (GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(2).add(1, (Component)this.jScrollPane2, -1, 394, Short.MAX_VALUE).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jButtonAdd).addPreferredGap(0).add((Component)this.jButtonInsert).addPreferredGap(0).add((Component)this.jButtonDelete).addPreferredGap(0, 232, Short.MAX_VALUE).add((Component)this.jButtonOK).addPreferredGap(0).add((Component)this.jButtonHelp).addPreferredGap(0).add((Component)this.jButtonCancel))).addContainerGap()));
        this.pack();
    }

    private void jButtonInsertActionPerformed(ActionEvent evt) {
        int row = this.jTableDiam.getSelectedRow();
        if (row < 0) {
            JOptionPane.showMessageDialog((Component)((Object)this), "Select a row above which to insert new row", this.getTitle(), 1);
            return;
        }
        this.data.add(row, "");
        this.jTableDiam.updateUI();
    }

    private void jButtonDeleteActionPerformed(ActionEvent evt) {
        int row = this.jTableDiam.getSelectedRow();
        if (row < 0) {
            JOptionPane.showMessageDialog((Component)((Object)this), "Select a row to delete", this.getTitle(), 1);
            return;
        }
        this.data.remove(row);
        this.jTableDiam.clearSelection();
        this.jTableDiam.updateUI();
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void jButtonOKActionPerformed(ActionEvent evt) {
        try {
            if (this.jTableDiam.isEditing()) {
                this.jTableDiam.getCellEditor().stopCellEditing();
            }
            this.db.storeCasingDiameters(this.data);
            this.db.commit();
            this.selection = this.data.get(this.jTableDiam.getSelectedRow());
            this.setOK();
        }
        catch (SBPermissionException pe) {
            JOptionPane.showMessageDialog((Component)((Object)this), pe.getMessage(), this.getTitle(), 2);
        }
        catch (SQLException | SBException sql) {
            this.db.doRollback();
            FrameJsbugs.showStackError("Error", (Exception)sql, this.db);
        }
    }

    private void jButtonAddActionPerformed(ActionEvent evt) {
        this.data.add("");
        this.jTableDiam.updateUI();
        this.jTableDiam.clearSelection();
    }

    private void jButtonHelpActionPerformed(ActionEvent evt) {
        FrameJsbugs.openHelp("dialogcasing.html");
    }

    class TableModelString
    extends AbstractTableModel {
        final /* synthetic */ DialogCasingDiam this$0;

        TableModelString(DialogCasingDiam this$0) {
            DialogCasingDiam dialogCasingDiam = this$0;
            Objects.requireNonNull(dialogCasingDiam);
            this.this$0 = dialogCasingDiam;
        }

        @Override
        public int getColumnCount() {
            return 1;
        }

        @Override
        public int getRowCount() {
            return this.this$0.data.size();
        }

        @Override
        public Object getValueAt(int row, int col) {
            return this.this$0.data.get(row);
        }

        @Override
        public void setValueAt(Object o, int row, int col) {
            this.this$0.data.set(row, (String)o);
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return true;
        }
    }
}

