/*
 * Decompiled with CFR 0.152.
 */
package jsbugs.wells;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.sql.SQLException;
import java.util.List;
import java.util.Objects;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import jsbugs.FrameJsbugs;
import jsbugs.wells.DialogCasingDiam;
import model3.Well;
import org.jdesktop.layout.GroupLayout;
import util.DepthUnits;
import util.DepthUtils;
import util.SB;
import util.SBException;
import util.SBPermissionException;

public class DialogCasingPoint
extends JDialog {
    private final Well well;
    private JButton jButtonCancel;
    private JButton jButtonOK;
    private JButton jButtonSizes;
    private JComboBox jComboBoxDiameter;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabelUnits;
    private JSeparator jSeparator1;
    private JTextField jTextFieldDepth;

    public DialogCasingPoint(JDialog parent, boolean modal, Well well, char units) throws Exception {
        super((Dialog)parent, modal);
        this.well = well;
        this.initComponents();
        this.init();
    }

    private void init() throws SQLException {
        this.loadCombo();
        this.setTitle("Casing Point : Add");
        this.jLabelUnits.setText(DepthUnits.getUnits((char)this.well.getWellUnits()).getAbr());
        if (!this.well.canWrite(this.well.getDataModel(), null)) {
            this.jButtonOK.setEnabled(false);
            this.jButtonOK.setToolTipText(this.well.getDeniedReason(this.well.getDataModel(), "well", false));
            this.getRootPane().setDefaultButton(this.jButtonCancel);
        } else {
            this.getRootPane().setDefaultButton(this.jButtonOK);
        }
    }

    private void loadCombo() throws SQLException {
        DefaultComboBoxModel<String> model = new DefaultComboBoxModel<String>();
        List<String> casingDiameters = this.well.getDataModel().getCasingDiameters();
        for (String d : casingDiameters) {
            model.addElement(d);
        }
        this.jComboBoxDiameter.setModel(model);
        this.jComboBoxDiameter.updateUI();
    }

    private void initComponents() {
        this.jButtonOK = new JButton();
        this.jButtonCancel = new JButton();
        this.jLabel1 = new JLabel();
        this.jTextFieldDepth = new JTextField();
        this.jLabelUnits = new JLabel();
        this.jLabel2 = new JLabel();
        this.jComboBoxDiameter = new JComboBox();
        this.jButtonSizes = new JButton();
        this.jSeparator1 = new JSeparator();
        this.setDefaultCloseOperation(2);
        this.setModal(true);
        this.setResizable(false);
        this.jButtonOK.setText("OK");
        this.jButtonOK.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogCasingPoint this$0;
            {
                DialogCasingPoint dialogCasingPoint = this$0;
                Objects.requireNonNull(dialogCasingPoint);
                this.this$0 = dialogCasingPoint;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonOKActionPerformed(evt);
            }
        });
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogCasingPoint this$0;
            {
                DialogCasingPoint dialogCasingPoint = this$0;
                Objects.requireNonNull(dialogCasingPoint);
                this.this$0 = dialogCasingPoint;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonCancelActionPerformed(evt);
            }
        });
        this.jLabel1.setText("Depth:");
        this.jTextFieldDepth.addKeyListener(new KeyAdapter(this){
            final /* synthetic */ DialogCasingPoint this$0;
            {
                DialogCasingPoint dialogCasingPoint = this$0;
                Objects.requireNonNull(dialogCasingPoint);
                this.this$0 = dialogCasingPoint;
            }

            @Override
            public void keyTyped(KeyEvent evt) {
                this.this$0.jTextFieldDepthKeyTyped(evt);
            }
        });
        this.jLabelUnits.setText("ft");
        this.jLabel2.setText("Diameter:");
        this.jComboBoxDiameter.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.jButtonSizes.setText("...");
        this.jButtonSizes.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogCasingPoint this$0;
            {
                DialogCasingPoint dialogCasingPoint = this$0;
                Objects.requireNonNull(dialogCasingPoint);
                this.this$0 = dialogCasingPoint;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonSizesActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createParallelGroup(2).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jButtonOK).addPreferredGap(0).add((Component)this.jButtonCancel)).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(2).add((Component)this.jLabel2).add((Component)this.jLabel1)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(2, false).add((Component)this.jComboBoxDiameter, 0, -1, Short.MAX_VALUE).add((Component)this.jTextFieldDepth, -2, 73, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jLabelUnits).add((Component)this.jButtonSizes, -2, 27, -2)))).add((Component)this.jSeparator1, -1, 157, Short.MAX_VALUE)).addContainerGap()));
        layout.linkSize(new Component[]{this.jButtonCancel, this.jButtonOK}, 1);
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jTextFieldDepth, -2, -1, -2).add((Component)this.jLabel1).add((Component)this.jLabelUnits)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel2).add((Component)this.jComboBoxDiameter, -2, -1, -2).add((Component)this.jButtonSizes)).addPreferredGap(1).add((Component)this.jSeparator1, -2, 10, -2).add(1, 1, 1).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jButtonCancel).add((Component)this.jButtonOK)).addContainerGap(-1, Short.MAX_VALUE)));
        this.pack();
    }

    private void jButtonOKActionPerformed(ActionEvent evt) {
        if (this.jTextFieldDepth.getText().trim().isEmpty()) {
            JOptionPane.showMessageDialog(this, "Enter a depth", this.getTitle(), 2);
            return;
        }
        try {
            double depth = DepthUtils.convToM((double)Double.parseDouble(this.jTextFieldDepth.getText().trim()), (char)this.well.getWellUnits());
            String diam = (String)this.jComboBoxDiameter.getSelectedItem();
            this.well.addCasingPoint(depth, diam);
            this.well.getDataModel().commit();
            this.well.getCasing().notifyObservers();
            this.dispose();
        }
        catch (SBPermissionException pe) {
            JOptionPane.showMessageDialog(this, pe.getMessage(), this.getTitle(), 2);
        }
        catch (SQLException | SBException sql) {
            this.well.getDataModel().doRollback();
            FrameJsbugs.showStackError("Error", (Exception)sql, this.well.getDataModel());
        }
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void jButtonSizesActionPerformed(ActionEvent evt) {
        try {
            if (!this.well.getDataModel().getHasCasdiam()) {
                if (JOptionPane.showConfirmDialog(this, "Cannot find casing diameter table - do you want to create it?", this.getTitle(), 0, 3) != 0) {
                    return;
                }
                this.well.getDataModel().createCasdiam();
            }
            DialogCasingDiam dialog = new DialogCasingDiam(this, true, this.well.getDataModel());
            dialog.setLocation(this.getLocation().x + 25, this.getLocation().y + 25);
            dialog.setVisible(true);
            if (dialog.isOK()) {
                this.loadCombo();
                if (!dialog.selection.isEmpty()) {
                    this.jComboBoxDiameter.setSelectedItem(dialog.selection);
                }
            }
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(this, ex.getMessage(), this.getTitle(), 0);
            ex.printStackTrace();
        }
    }

    private void jTextFieldDepthKeyTyped(KeyEvent evt) {
        if (SB.floatFieldVal((JTextField)this.jTextFieldDepth, (int)8, (KeyEvent)evt, (boolean)true)) {
            this.getToolkit().beep();
        }
    }
}

