/*
 * Decompiled with CFR 0.152.
 */
package jsbugs.wells;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.sql.SQLException;
import java.util.Objects;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.UIManager;
import jsbugs.FrameJsbugs;
import model3.Audit;
import model3.CoredInterval;
import model3.Cores;
import model3.Well;
import org.jdesktop.layout.GroupLayout;
import util.DepthUnits;
import util.DepthUtils;
import util.SB;
import util.SBException;
import util.SBPermissionException;

public class DialogCoredInterval
extends JDialog {
    private final CoredInterval original;
    private final Cores cores;
    private final Well well;
    private final char units;
    private ButtonGroup buttonGroupRecovery;
    private JButton jButtonCancel;
    private JButton jButtonOK;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabelUnits1;
    private JLabel jLabelUnits2;
    private JLabel jLabelUnits3;
    private JLabel jLabelUnits4;
    private JPanel jPanel2;
    private JRadioButton jRadioButtonRecovered;
    private JRadioButton jRadioButtonUnrecovered;
    private JTextField jTextFieldBaseDepth;
    private JTextField jTextFieldBaseShift;
    private JTextField jTextFieldNumber;
    private JTextField jTextFieldTopDepth;
    private JTextField jTextFieldTopShift;

    public DialogCoredInterval(Dialog parent, boolean modal, Well well, CoredInterval core, char units) throws SQLException, SBException {
        super(parent, modal);
        this.well = well;
        this.cores = well.getCores();
        this.original = core;
        this.units = units;
        this.initComponents();
        this.init();
    }

    private void init() throws SQLException {
        JLabel[] unitsLabes;
        if (this.original == null) {
            this.setTitle("Cored Interval : Add");
        } else {
            Float baseShift;
            this.setTitle("Cored Interval : Edit");
            this.jTextFieldTopDepth.setText("" + DepthUtils.convFromM((double)this.original.getTopDepth(), (char)this.units, (char)this.well.getType()));
            this.jTextFieldBaseDepth.setText("" + DepthUtils.convFromM((double)this.original.getBaseDepth(), (char)this.units, (char)this.well.getType()));
            Float topShift = this.original.getDeltaTop(this.well);
            if (topShift != null) {
                this.jTextFieldTopShift.setText("" + DepthUtils.convFromM((float)topShift.floatValue(), (char)this.units, (char)this.well.getType()));
            }
            if ((baseShift = this.original.getDeltaBase(this.well)) != null) {
                this.jTextFieldBaseShift.setText("" + DepthUtils.convFromM((float)baseShift.floatValue(), (char)this.units, (char)this.well.getType()));
            }
            if (this.original.getRecovered()) {
                this.jRadioButtonRecovered.setSelected(true);
            } else {
                this.jRadioButtonUnrecovered.setSelected(true);
            }
            this.jTextFieldNumber.setText(this.original.getCorenum());
        }
        String unitsLabel = DepthUnits.getUnits((char)this.units).getAbr();
        for (JLabel label : unitsLabes = new JLabel[]{this.jLabelUnits1, this.jLabelUnits2, this.jLabelUnits3, this.jLabelUnits4}) {
            label.setText(unitsLabel);
        }
        if (!this.well.canWrite(this.well.getDataModel(), null)) {
            this.jButtonOK.setEnabled(false);
            this.jButtonOK.setToolTipText(this.well.getDeniedReason(this.well.getDataModel(), "well", false));
            this.getRootPane().setDefaultButton(this.jButtonCancel);
        } else {
            this.getRootPane().setDefaultButton(this.jButtonOK);
        }
    }

    private void initComponents() {
        this.buttonGroupRecovery = new ButtonGroup();
        this.jButtonCancel = new JButton();
        this.jButtonOK = new JButton();
        this.jLabel5 = new JLabel();
        this.jTextFieldNumber = new JTextField();
        this.jPanel2 = new JPanel();
        this.jLabel1 = new JLabel();
        this.jLabelUnits2 = new JLabel();
        this.jTextFieldBaseDepth = new JTextField();
        this.jLabelUnits1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jTextFieldTopDepth = new JTextField();
        this.jLabel3 = new JLabel();
        this.jTextFieldTopShift = new JTextField();
        this.jLabelUnits3 = new JLabel();
        this.jLabelUnits4 = new JLabel();
        this.jTextFieldBaseShift = new JTextField();
        this.jLabel4 = new JLabel();
        this.jRadioButtonRecovered = new JRadioButton();
        this.jRadioButtonUnrecovered = new JRadioButton();
        this.setDefaultCloseOperation(2);
        this.setModal(true);
        this.setResizable(false);
        ResourceBundle bundle = ResourceBundle.getBundle("locale/UiText");
        this.jButtonCancel.setText(bundle.getString("button.cancel"));
        this.jButtonCancel.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogCoredInterval this$0;
            {
                DialogCoredInterval dialogCoredInterval = this$0;
                Objects.requireNonNull(dialogCoredInterval);
                this.this$0 = dialogCoredInterval;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonCancelActionPerformed(evt);
            }
        });
        this.jButtonOK.setText("OK");
        this.jButtonOK.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogCoredInterval this$0;
            {
                DialogCoredInterval dialogCoredInterval = this$0;
                Objects.requireNonNull(dialogCoredInterval);
                this.this$0 = dialogCoredInterval;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonOKActionPerformed(evt);
            }
        });
        this.jLabel5.setHorizontalAlignment(11);
        this.jLabel5.setText(bundle.getString("DialogCoredInterval.label.corenumber"));
        this.jTextFieldNumber.addKeyListener(new KeyAdapter(this){
            final /* synthetic */ DialogCoredInterval this$0;
            {
                DialogCoredInterval dialogCoredInterval = this$0;
                Objects.requireNonNull(dialogCoredInterval);
                this.this$0 = dialogCoredInterval;
            }

            @Override
            public void keyTyped(KeyEvent evt) {
                this.this$0.jTextFieldNumberKeyTyped(evt);
            }
        });
        this.jPanel2.setBorder(BorderFactory.createTitledBorder(null, bundle.getString("panel.depthrange"), 0, 0, UIManager.getFont("TitledBorder.font"), UIManager.getColor("TitledBorder.titleColor")));
        this.jLabel1.setText(bundle.getString("label.top"));
        this.jLabelUnits2.setText("ft");
        this.jTextFieldBaseDepth.addKeyListener(new KeyAdapter(this){
            final /* synthetic */ DialogCoredInterval this$0;
            {
                DialogCoredInterval dialogCoredInterval = this$0;
                Objects.requireNonNull(dialogCoredInterval);
                this.this$0 = dialogCoredInterval;
            }

            @Override
            public void keyTyped(KeyEvent evt) {
                this.this$0.jTextFieldBaseDepthKeyTyped(evt);
            }
        });
        this.jLabelUnits1.setText("ft");
        this.jLabel2.setText(bundle.getString("label.base"));
        this.jTextFieldTopDepth.addKeyListener(new KeyAdapter(this){
            final /* synthetic */ DialogCoredInterval this$0;
            {
                DialogCoredInterval dialogCoredInterval = this$0;
                Objects.requireNonNull(dialogCoredInterval);
                this.this$0 = dialogCoredInterval;
            }

            @Override
            public void keyTyped(KeyEvent evt) {
                this.this$0.jTextFieldTopDepthKeyTyped(evt);
            }
        });
        this.jLabel3.setText("Shift at top:");
        this.jTextFieldTopShift.addKeyListener(new KeyAdapter(this){
            final /* synthetic */ DialogCoredInterval this$0;
            {
                DialogCoredInterval dialogCoredInterval = this$0;
                Objects.requireNonNull(dialogCoredInterval);
                this.this$0 = dialogCoredInterval;
            }

            @Override
            public void keyTyped(KeyEvent evt) {
                this.this$0.jTextFieldTopShiftKeyTyped(evt);
            }
        });
        this.jLabelUnits3.setText("ft");
        this.jLabelUnits4.setText("ft");
        this.jTextFieldBaseShift.addKeyListener(new KeyAdapter(this){
            final /* synthetic */ DialogCoredInterval this$0;
            {
                DialogCoredInterval dialogCoredInterval = this$0;
                Objects.requireNonNull(dialogCoredInterval);
                this.this$0 = dialogCoredInterval;
            }

            @Override
            public void keyTyped(KeyEvent evt) {
                this.this$0.jTextFieldBaseShiftKeyTyped(evt);
            }
        });
        this.jLabel4.setText("Shift at base:");
        GroupLayout jPanel2Layout = new GroupLayout((Container)this.jPanel2);
        this.jPanel2.setLayout((LayoutManager)jPanel2Layout);
        jPanel2Layout.setHorizontalGroup((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel2Layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanel2Layout.createParallelGroup(2).add((Component)this.jLabel2).add((Component)this.jLabel1)).addPreferredGap(0).add((GroupLayout.Group)jPanel2Layout.createParallelGroup(1, false).add((Component)this.jTextFieldBaseDepth).add((Component)this.jTextFieldTopDepth, -1, 68, Short.MAX_VALUE)).addPreferredGap(0).add((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add((Component)this.jLabelUnits2).add((Component)this.jLabelUnits1)).add(18, 18, 18).add((GroupLayout.Group)jPanel2Layout.createParallelGroup(2).add((Component)this.jLabel4).add((Component)this.jLabel3)).addPreferredGap(0).add((GroupLayout.Group)jPanel2Layout.createParallelGroup(1, false).add((Component)this.jTextFieldBaseShift).add((Component)this.jTextFieldTopShift, -2, 68, -2)).addPreferredGap(0).add((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add((Component)this.jLabelUnits4).add((Component)this.jLabelUnits3)).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel2Layout.linkSize(new Component[]{this.jTextFieldBaseShift, this.jTextFieldTopShift}, 1);
        jPanel2Layout.linkSize(new Component[]{this.jTextFieldBaseDepth, this.jTextFieldTopDepth}, 1);
        jPanel2Layout.setVerticalGroup((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add(2, (GroupLayout.Group)jPanel2Layout.createSequentialGroup().add((GroupLayout.Group)jPanel2Layout.createParallelGroup(2).add((GroupLayout.Group)jPanel2Layout.createSequentialGroup().add((GroupLayout.Group)jPanel2Layout.createParallelGroup(3).add((Component)this.jLabel3).add((Component)this.jTextFieldTopShift).add((Component)this.jLabelUnits3)).addPreferredGap(0).add((GroupLayout.Group)jPanel2Layout.createParallelGroup(3).add((Component)this.jLabel4).add((Component)this.jTextFieldBaseShift, -2, -1, -2).add((Component)this.jLabelUnits4))).add((GroupLayout.Group)jPanel2Layout.createSequentialGroup().add((GroupLayout.Group)jPanel2Layout.createParallelGroup(3).add((Component)this.jLabel1).add((Component)this.jTextFieldTopDepth).add((Component)this.jLabelUnits1)).addPreferredGap(0).add((GroupLayout.Group)jPanel2Layout.createParallelGroup(3).add((Component)this.jLabel2).add((Component)this.jTextFieldBaseDepth, -2, -1, -2).add((Component)this.jLabelUnits2)))).addContainerGap()));
        this.buttonGroupRecovery.add(this.jRadioButtonRecovered);
        this.jRadioButtonRecovered.setSelected(true);
        this.jRadioButtonRecovered.setText(bundle.getString("DialogCoredInterval.panel.recovered"));
        this.jRadioButtonRecovered.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jRadioButtonRecovered.setMargin(new Insets(0, 0, 0, 0));
        this.buttonGroupRecovery.add(this.jRadioButtonUnrecovered);
        this.jRadioButtonUnrecovered.setText(bundle.getString("DialogCoredInterval.panel.unrecovered"));
        this.jRadioButtonUnrecovered.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jRadioButtonUnrecovered.setMargin(new Insets(0, 0, 0, 0));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).add((GroupLayout.Group)layout.createParallelGroup(1).add(2, (GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jLabel5, -2, 100, -2).addPreferredGap(0).add((Component)this.jTextFieldNumber, -2, 52, -2).addPreferredGap(1).add((Component)this.jRadioButtonRecovered).addPreferredGap(0).add((Component)this.jRadioButtonUnrecovered).add(18, 18, 18)).add(2, (GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jButtonOK, -2, 61, -2).addPreferredGap(0).add((Component)this.jButtonCancel)).add(2, (Component)this.jPanel2, -2, -1, -2)).addContainerGap()));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(2, (GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jTextFieldNumber, -2, -1, -2).add((Component)this.jLabel5).add((Component)this.jRadioButtonRecovered).add((Component)this.jRadioButtonUnrecovered)).addPreferredGap(1).add((Component)this.jPanel2, -2, -1, -2).addPreferredGap(1).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jButtonOK).add((Component)this.jButtonCancel)).addContainerGap(-1, Short.MAX_VALUE)));
        this.pack();
    }

    private void jButtonOKActionPerformed(ActionEvent evt) {
        if (this.jTextFieldTopDepth.getText().trim().length() == 0) {
            JOptionPane.showMessageDialog(this, "Enter a top depth", this.getTitle(), 2);
            return;
        }
        if (this.jTextFieldBaseDepth.getText().trim().length() == 0) {
            JOptionPane.showMessageDialog(this, "Enter a base depth", this.getTitle(), 2);
            return;
        }
        if (this.buttonGroupRecovery.getSelection() == null) {
            JOptionPane.showMessageDialog(this, "Select core recovery", this.getTitle(), 2);
            return;
        }
        try {
            double topDepth = DepthUtils.convToM((double)Double.parseDouble(this.jTextFieldTopDepth.getText().trim()), (char)this.units);
            double baseDepth = DepthUtils.convToM((double)Double.parseDouble(this.jTextFieldBaseDepth.getText().trim()), (char)this.units);
            if (topDepth > baseDepth) {
                JOptionPane.showMessageDialog(this, "Top depth is greater than base depth", this.getTitle(), 2);
                return;
            }
            if (baseDepth > this.well.getTD()) {
                JOptionPane.showMessageDialog(this, "The core is below well TD", this.getTitle(), 2);
                return;
            }
            boolean recovered = this.jRadioButtonRecovered.isSelected();
            String corenum = this.jTextFieldNumber.getText().trim();
            CoredInterval newCore = new CoredInterval(topDepth, baseDepth, corenum, recovered, new Audit());
            this.cores.checkOverlap(this.original, newCore);
            if (this.original != null) {
                this.well.deleteCoredInterval(this.original);
            }
            newCore.store(this.well.getDataModel(), this.well.getWellID());
            String topShiftString = this.jTextFieldTopShift.getText().trim();
            Float topShift = null;
            if (!topShiftString.isEmpty()) {
                topShift = Float.valueOf(DepthUtils.convToM((float)Float.parseFloat(topShiftString), (char)this.units));
            }
            String baseShiftString = this.jTextFieldBaseShift.getText().trim();
            Float baseShift = null;
            if (!baseShiftString.isEmpty()) {
                baseShift = Float.valueOf(DepthUtils.convToM((float)Float.parseFloat(baseShiftString), (char)this.units));
            }
            this.well.getCoreShift().updateFromCoredInterval(this.well.getWellID(), topDepth, baseDepth, topShift, baseShift);
            this.well.getDataModel().commit();
            this.cores.add(newCore);
            this.cores.notifyObservers();
            this.well.setDataChanged();
            this.well.notifyObservers(newCore);
            this.dispose();
        }
        catch (SBPermissionException pe) {
            JOptionPane.showMessageDialog(this, pe.getMessage(), this.getTitle(), 2);
        }
        catch (SQLException sql) {
            this.well.getDataModel().doRollback();
            FrameJsbugs.showStackError("SQL Error", sql, this.well.getDataModel());
        }
        catch (SBException sbe) {
            this.well.getDataModel().doRollback();
            JOptionPane.showMessageDialog(this, sbe.getMessage(), this.getTitle(), 2);
        }
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void jTextFieldNumberKeyTyped(KeyEvent evt) {
        if (SB.lenField((JTextField)this.jTextFieldNumber, (int)3, (KeyEvent)evt)) {
            this.getToolkit().beep();
        }
    }

    private void jTextFieldBaseDepthKeyTyped(KeyEvent evt) {
        if (SB.floatFieldVal((JTextField)this.jTextFieldBaseDepth, (int)8, (KeyEvent)evt, (boolean)true)) {
            this.getToolkit().beep();
        }
    }

    private void jTextFieldTopDepthKeyTyped(KeyEvent evt) {
        if (SB.floatFieldVal((JTextField)this.jTextFieldTopDepth, (int)8, (KeyEvent)evt, (boolean)true)) {
            this.getToolkit().beep();
        }
    }

    private void jTextFieldTopShiftKeyTyped(KeyEvent evt) {
        if (SB.floatFieldVal((JTextField)this.jTextFieldTopShift, (int)5, (KeyEvent)evt, (boolean)true)) {
            this.getToolkit().beep();
        }
    }

    private void jTextFieldBaseShiftKeyTyped(KeyEvent evt) {
        if (SB.floatFieldVal((JTextField)this.jTextFieldBaseShift, (int)5, (KeyEvent)evt, (boolean)true)) {
            this.getToolkit().beep();
        }
    }
}

