/*
 * Decompiled with CFR 0.152.
 */
package jsbugs.wells;

import com.stratadata.model3.well.SectionType;
import com.stratadata.model3.well.curve.Curve;
import com.stratadata.util.depth.DepthUnits;
import com.stratadata.util.depth.DepthUtils;
import com.stratadata.util.ui.SBDialog;
import com.stratadata.util.ui.table.TableUtils;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumnModel;
import jsbugs.uiutil.TextFieldUtils;
import org.jdesktop.layout.GroupLayout;

public class DialogCurve
extends SBDialog {
    private static final int COMMENT_LENGTH = 255;
    private final TableModelCurve model = new TableModelCurve(this);
    private final Curve curve;
    private final DepthUnits wellUnits;
    private final SectionType wellSectionType;
    private static final String[] COL_TITLES = new String[]{"Depth", "Value"};
    private static final int[] COL_WIDTHS = new int[]{30, 30};
    private JButton jButtonCancel;
    private JButton jButtonDelete;
    private JButton jButtonOK;
    private JLabel jLabel1;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JTable jTableCurve;
    private JTextArea jTextAreaComment;

    public DialogCurve(Dialog parent, boolean modal, Curve curve, DepthUnits wellUnits, SectionType wellSectionType) {
        super((Window)parent, modal);
        this.curve = curve;
        this.wellUnits = wellUnits;
        this.wellSectionType = wellSectionType;
        this.initComponents();
        this.init();
    }

    private void init() {
        this.setTitle("Edit Wireline Log");
        this.getRootPane().setDefaultButton(this.jButtonOK);
        this.jTextAreaComment.setText(this.curve.getComments());
        this.setupTable();
    }

    private void setupTable() {
        TableUtils.setTableHeaderBold((JTable)this.jTableCurve);
        TableColumnModel columnModel = this.jTableCurve.getTableHeader().getColumnModel();
        for (int i = 0; i < this.model.getColumnCount(); ++i) {
            columnModel.getColumn(i).setHeaderValue(COL_TITLES[i]);
            columnModel.getColumn(i).setWidth(COL_WIDTHS[i]);
        }
        this.jTableCurve.updateUI();
    }

    public void disableEditing(String deniedReason) {
        this.jButtonDelete.setEnabled(false);
        this.jButtonOK.setEnabled(false);
        this.jButtonOK.setToolTipText(deniedReason);
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.jTableCurve = new JTable();
        this.jButtonDelete = new JButton();
        this.jButtonCancel = new JButton();
        this.jScrollPane2 = new JScrollPane();
        this.jTextAreaComment = TextFieldUtils.buildLimitedLengthTextArea(255);
        this.jButtonOK = new JButton();
        this.jLabel1 = new JLabel();
        this.setDefaultCloseOperation(2);
        this.setMinimumSize(new Dimension(250, 300));
        this.jTableCurve.setModel(this.model);
        this.jScrollPane1.setViewportView(this.jTableCurve);
        this.jButtonDelete.setText("Delete");
        this.jButtonDelete.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogCurve this$0;
            {
                DialogCurve dialogCurve = this$0;
                Objects.requireNonNull(dialogCurve);
                this.this$0 = dialogCurve;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonDeleteActionPerformed(evt);
            }
        });
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogCurve this$0;
            {
                DialogCurve dialogCurve = this$0;
                Objects.requireNonNull(dialogCurve);
                this.this$0 = dialogCurve;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonCancelActionPerformed(evt);
            }
        });
        this.jTextAreaComment.setColumns(10);
        this.jTextAreaComment.setFont(this.jTextAreaComment.getFont());
        this.jTextAreaComment.setLineWrap(true);
        this.jTextAreaComment.setRows(4);
        this.jTextAreaComment.setWrapStyleWord(true);
        this.jScrollPane2.setViewportView(this.jTextAreaComment);
        this.jButtonOK.setText("OK");
        this.jButtonOK.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogCurve this$0;
            {
                DialogCurve dialogCurve = this$0;
                Objects.requireNonNull(dialogCurve);
                this.this$0 = dialogCurve;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonOKActionPerformed(evt);
            }
        });
        this.jLabel1.setText("Comments:");
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jLabel1).add(243, 243, 243)).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(1).add(2, (GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jScrollPane1, -2, 0, Short.MAX_VALUE).add(10, 10, 10).add((Component)this.jButtonDelete)).add((Component)this.jScrollPane2)).addContainerGap()))).add(2, (GroupLayout.Group)layout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).add((Component)this.jButtonOK, -2, 65, -2).addPreferredGap(0).add((Component)this.jButtonCancel, -1, -1, Short.MAX_VALUE).addContainerGap()));
        layout.linkSize(new Component[]{this.jButtonCancel, this.jButtonDelete}, 1);
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jButtonDelete).add(0, 181, Short.MAX_VALUE)).add((Component)this.jScrollPane1, -2, 0, Short.MAX_VALUE)).addPreferredGap(1).add((Component)this.jLabel1).addPreferredGap(0).add((Component)this.jScrollPane2, -2, 84, -2).addPreferredGap(1).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jButtonOK).add((Component)this.jButtonCancel)).addContainerGap()));
        this.pack();
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void jButtonDeleteActionPerformed(ActionEvent evt) {
        if (this.jTableCurve.getSelectedRow() < 0) {
            return;
        }
        List trace = this.curve.getTrace();
        List<Curve.CurveValue> toDelete = Arrays.stream(this.jTableCurve.getSelectedRows()).mapToObj(index -> (Curve.CurveValue)trace.get(index)).toList();
        this.curve.deleteValues(toDelete);
        this.model.fireTableDataChanged();
    }

    private void jButtonOKActionPerformed(ActionEvent evt) {
        this.curve.setComments(this.jTextAreaComment.getText());
        this.setOK();
    }

    private class TableModelCurve
    extends AbstractTableModel {
        final /* synthetic */ DialogCurve this$0;

        private TableModelCurve(DialogCurve dialogCurve) {
            DialogCurve dialogCurve2 = dialogCurve;
            Objects.requireNonNull(dialogCurve2);
            this.this$0 = dialogCurve2;
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public int getRowCount() {
            if (this.this$0.curve == null) {
                return 0;
            }
            return this.this$0.curve.getSize();
        }

        @Override
        public Object getValueAt(int row, int col) {
            Curve.CurveValue curveValue = (Curve.CurveValue)this.this$0.curve.getTrace().get(row);
            return switch (col) {
                case 0 -> DepthUtils.depthString((double)curveValue.depth(), (DepthUnits)this.this$0.wellUnits, (int)2, (SectionType)this.this$0.wellSectionType);
                case 1 -> "" + curveValue.value();
                default -> "";
            };
        }

        @Override
        public Class<?> getColumnClass(int c) {
            return String.class;
        }
    }
}

