/*
 * Decompiled with CFR 0.152.
 */
package jsbugs.wells;

import com.stratadata.util.ui.HelpUtils;
import com.stratadata.util.ui.SBDialog;
import com.stratadata.util.ui.table.ColumnSortResetHandler;
import com.stratadata.util.ui.table.TableUtils;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.Objects;
import java.util.Set;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableRowSorter;
import jsbugs.DialogFilePreview;
import jsbugs.DialogLogDefs;
import jsbugs.FrameJsbugs;
import jsbugs.table.ComboRenderer;
import jsbugs.table.LogDefComboEditor;
import jsbugs.userconnect.SbugsExceptionHandler;
import model3.LogDef;
import model3.LogFile;
import model3.Well;
import org.jdesktop.layout.GroupLayout;
import util.SB;

public class DialogCurveReader
extends SBDialog {
    private static final String[] TITLES = new String[]{"Column", "Abr", "Type", "Comment", "Import?"};
    private static final int[] WIDTHS = new int[]{30, 30, 60, 80, 30};
    private final JComboBox logDefComboBox = new JComboBox();
    private final TableModelCurves model = new TableModelCurves(this);
    private static final int COMMENT_LENGTH = 255;
    private final DefaultComboBoxModel logDefModel = new DefaultComboBoxModel();
    private final LogFile file;
    private final Well well;
    LogDef[] logDef;
    String[] comment;
    boolean[] getCurve;
    char units;
    float depthFilter;
    private ButtonGroup buttonGroupInputUnits;
    private JButton jButtonCancel;
    private JButton jButtonHelp;
    private JButton jButtonLogDef;
    private JButton jButtonOK;
    private JButton jButtonView;
    private JLabel jLabel1;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JRadioButton jRadioButtonFeet;
    private JRadioButton jRadioButtonMetres;
    private JScrollPane jScrollPane2;
    private JTable jTableCurves;
    private JTextField jTextFieldDepthFilter;
    private JTextField jTextFieldFileName;

    public DialogCurveReader(JDialog parent, boolean modal, Well well, LogFile logFile) throws SQLException {
        super((Window)parent, modal);
        this.file = logFile;
        this.well = well;
        this.initComponents();
        this.init();
    }

    private void init() throws SQLException {
        this.logDef = new LogDef[this.file.getNcurves()];
        this.comment = new String[this.file.getNcurves()];
        this.getCurve = new boolean[this.file.getNcurves()];
        this.setTitle("Wireline Log Curve Reader : " + this.well.getWellName());
        this.model.setupTable(this.jTableCurves);
        this.model.initLogDefEditor();
        this.jTableCurves.setRowSorter(new TableRowSorter<TableModelCurves>(this.model));
        new ColumnSortResetHandler(this.jTableCurves).attach();
        this.getRootPane().setDefaultButton(this.jButtonOK);
        this.jTextFieldFileName.setText(this.file.getPath());
        if (this.file.getDepthUnits() > '\u0000') {
            if (this.file.getDepthUnits() == 'M') {
                this.jRadioButtonMetres.setSelected(true);
            } else {
                this.jRadioButtonFeet.setSelected(true);
            }
        }
        Iterator<LogFile.CurveHeader> it = this.file.getCurveHeaders();
        int i = 0;
        while (it.hasNext()) {
            LogFile.CurveHeader c = it.next();
            try {
                this.logDef[i] = this.well.getDataModel().getLogDef(c.getMnem());
                this.getCurve[i] = false;
                ++i;
            }
            catch (SQLException sql) {
                FrameJsbugs.showStackError("SQL Error", sql, this.well.getDataModel());
            }
        }
        this.model.fireTableDataChanged();
    }

    private void initComponents() {
        this.buttonGroupInputUnits = new ButtonGroup();
        this.jLabel1 = new JLabel();
        this.jTextFieldFileName = new JTextField();
        this.jButtonCancel = new JButton();
        this.jButtonOK = new JButton();
        this.jTextFieldDepthFilter = new JTextField();
        this.jLabel4 = new JLabel();
        this.jButtonHelp = new JButton();
        this.jButtonView = new JButton();
        this.jButtonLogDef = new JButton();
        this.jLabel5 = new JLabel();
        this.jRadioButtonMetres = new JRadioButton();
        this.jRadioButtonFeet = new JRadioButton();
        this.jScrollPane2 = new JScrollPane();
        this.jTableCurves = new JTable();
        this.setDefaultCloseOperation(2);
        this.jLabel1.setText("Filename:");
        this.jTextFieldFileName.setEditable(false);
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogCurveReader this$0;
            {
                DialogCurveReader dialogCurveReader = this$0;
                Objects.requireNonNull(dialogCurveReader);
                this.this$0 = dialogCurveReader;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonCancelActionPerformed(evt);
            }
        });
        this.jButtonOK.setText("OK");
        this.jButtonOK.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogCurveReader this$0;
            {
                DialogCurveReader dialogCurveReader = this$0;
                Objects.requireNonNull(dialogCurveReader);
                this.this$0 = dialogCurveReader;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonOKActionPerformed(evt);
            }
        });
        this.jTextFieldDepthFilter.setText("0.0");
        this.jTextFieldDepthFilter.setToolTipText("<html>This is the minimum depth distance between sucessive depth samples to read from the file<br/>Increase this value to make file reading faster</html>");
        this.jTextFieldDepthFilter.addKeyListener(new KeyAdapter(this){
            final /* synthetic */ DialogCurveReader this$0;
            {
                DialogCurveReader dialogCurveReader = this$0;
                Objects.requireNonNull(dialogCurveReader);
                this.this$0 = dialogCurveReader;
            }

            @Override
            public void keyTyped(KeyEvent evt) {
                this.this$0.jTextFieldDepthFilterKeyTyped(evt);
            }
        });
        this.jLabel4.setText("Depth filter value:");
        this.jButtonHelp.setText("Help");
        this.jButtonHelp.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogCurveReader this$0;
            {
                DialogCurveReader dialogCurveReader = this$0;
                Objects.requireNonNull(dialogCurveReader);
                this.this$0 = dialogCurveReader;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonHelpActionPerformed(evt);
            }
        });
        this.jButtonView.setText("View...");
        this.jButtonView.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogCurveReader this$0;
            {
                DialogCurveReader dialogCurveReader = this$0;
                Objects.requireNonNull(dialogCurveReader);
                this.this$0 = dialogCurveReader;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonViewActionPerformed(evt);
            }
        });
        this.jButtonLogDef.setText("Edit defaults...");
        this.jButtonLogDef.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogCurveReader this$0;
            {
                DialogCurveReader dialogCurveReader = this$0;
                Objects.requireNonNull(dialogCurveReader);
                this.this$0 = dialogCurveReader;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonLogDefActionPerformed(evt);
            }
        });
        this.jLabel5.setText("Input units:");
        this.buttonGroupInputUnits.add(this.jRadioButtonMetres);
        this.jRadioButtonMetres.setText("Metres");
        this.jRadioButtonMetres.setToolTipText("");
        this.buttonGroupInputUnits.add(this.jRadioButtonFeet);
        this.jRadioButtonFeet.setText("Feet");
        this.jTableCurves.setModel(this.model);
        this.jScrollPane2.setViewportView(this.jTableCurves);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jScrollPane2).add(2, (GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jLabel1).addPreferredGap(0).add((Component)this.jTextFieldFileName, -1, 340, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.jButtonView)).add(2, (GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jButtonLogDef).addPreferredGap(0, -1, Short.MAX_VALUE).add((Component)this.jButtonOK).addPreferredGap(0).add((Component)this.jButtonHelp).addPreferredGap(0).add((Component)this.jButtonCancel)).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jLabel4).addPreferredGap(0).add((Component)this.jTextFieldDepthFilter, -2, 63, Short.MAX_VALUE).add(18, 18, 18).add((Component)this.jLabel5).addPreferredGap(1).add((Component)this.jRadioButtonMetres).addPreferredGap(0).add((Component)this.jRadioButtonFeet).add(128, 128, 128))).addContainerGap()));
        layout.linkSize(new Component[]{this.jButtonCancel, this.jButtonHelp, this.jButtonOK}, 1);
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(2, (GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jTextFieldFileName, -2, -1, -2).add((Component)this.jLabel1).add((Component)this.jButtonView)).addPreferredGap(1).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel4).add((Component)this.jTextFieldDepthFilter, -2, -1, -2).add((Component)this.jRadioButtonMetres).add((Component)this.jRadioButtonFeet).add((Component)this.jLabel5)).addPreferredGap(1).add((Component)this.jScrollPane2, -1, 237, Short.MAX_VALUE).addPreferredGap(1).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jButtonCancel).add((Component)this.jButtonOK).add((Component)this.jButtonHelp).add((Component)this.jButtonLogDef)).addContainerGap()));
        this.pack();
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void jButtonOKActionPerformed(ActionEvent evt) {
        if (this.buttonGroupInputUnits.getSelection() == null) {
            JOptionPane.showMessageDialog((Component)((Object)this), "You must specify depth units.", this.getTitle(), 2);
            return;
        }
        this.units = (char)(this.jRadioButtonFeet.isSelected() ? 70 : 77);
        this.depthFilter = Float.parseFloat(this.jTextFieldDepthFilter.getText());
        boolean hasSelected = false;
        for (int i = 0; i < this.file.getNcurves(); ++i) {
            if (this.comment[i] != null && this.comment[i].length() > 255) {
                JOptionPane.showMessageDialog((Component)((Object)this), "Comment too long on line: " + (i + 1) + ", restricted to: 255", this.getTitle(), 2);
                return;
            }
            if (!this.getCurve[i]) continue;
            hasSelected = true;
        }
        if (!hasSelected) {
            JOptionPane.showMessageDialog((Component)((Object)this), "You have not selected any curves to import.", this.getTitle(), 2);
            return;
        }
        this.setOK();
    }

    private void jTextFieldDepthFilterKeyTyped(KeyEvent evt) {
        if (SB.floatFieldVal((JTextField)this.jTextFieldDepthFilter, (int)4, (KeyEvent)evt, (boolean)false)) {
            this.getToolkit().beep();
        }
    }

    private void jButtonHelpActionPerformed(ActionEvent evt) {
        HelpUtils.openHelp((String)"howtowireline.html");
    }

    private void jButtonLogDefActionPerformed(ActionEvent evt) {
        try {
            DialogLogDefs dialog = new DialogLogDefs((JDialog)((Object)this), true, this.well.getDataModel());
            dialog.setLocationRelativeTo((Component)((Object)this));
            dialog.setVisible(true);
            this.model.initLogDefEditor();
        }
        catch (SQLException sql) {
            SbugsExceptionHandler.showStackError(sql, (Component)((Object)this));
        }
    }

    private void jButtonViewActionPerformed(ActionEvent evt) {
        DialogFilePreview dialog = new DialogFilePreview((JDialog)((Object)this), false, this.file.getPath());
        dialog.setLocationRelativeTo((Component)((Object)this));
        dialog.setVisible(true);
    }

    private class TableModelCurves
    extends AbstractTableModel {
        static final int COL_CURVE = 0;
        static final int COL_ABR = 1;
        static final int COL_TYPE = 2;
        static final int COL_COMMENT = 3;
        static final int COL_GET = 4;
        final /* synthetic */ DialogCurveReader this$0;

        private TableModelCurves(DialogCurveReader dialogCurveReader) {
            DialogCurveReader dialogCurveReader2 = dialogCurveReader;
            Objects.requireNonNull(dialogCurveReader2);
            this.this$0 = dialogCurveReader2;
        }

        @Override
        public int getColumnCount() {
            return TITLES.length;
        }

        @Override
        public int getRowCount() {
            if (this.this$0.file == null) {
                return 0;
            }
            return this.this$0.file.getNcurves();
        }

        @Override
        public Object getValueAt(int row, int col) {
            switch (col) {
                case 0: {
                    return this.this$0.file.getCurveAt(row).getMnem();
                }
                case 1: {
                    if (this.this$0.logDef[row] != null) {
                        return this.this$0.logDef[row].getAbr();
                    }
                    return "";
                }
                case 2: {
                    if (this.this$0.logDef[row] != null) {
                        return this.this$0.logDef[row].getTitle();
                    }
                    return "";
                }
                case 3: {
                    if (this.this$0.comment[row] != null) {
                        return this.this$0.comment[row];
                    }
                    return "";
                }
                case 4: {
                    return this.this$0.getCurve[row];
                }
            }
            return "";
        }

        @Override
        public void setValueAt(Object obj, int row, int col) {
            switch (col) {
                default: {
                    break;
                }
                case 3: {
                    this.this$0.comment[row] = (String)obj;
                    break;
                }
                case 4: {
                    this.this$0.getCurve[row] = (Boolean)obj;
                    if (this.this$0.logDef[row] != null) break;
                    this.this$0.getCurve[row] = false;
                    break;
                }
                case 1: {
                    this.this$0.logDef[row] = (LogDef)obj;
                    this.this$0.getCurve[row] = true;
                }
            }
        }

        public Class getColumnClass(int c) {
            switch (c) {
                default: {
                    return String.class;
                }
                case 4: 
            }
            return Boolean.class;
        }

        @Override
        public boolean isCellEditable(int r, int c) {
            switch (c) {
                case 1: 
                case 3: 
                case 4: {
                    return true;
                }
            }
            return false;
        }

        void setupTable(JTable jTable) {
            TableUtils.setTableHeaderBold((JTable)jTable);
            for (int i = 0; i < TITLES.length; ++i) {
                jTable.getColumnModel().getColumn(i).setHeaderValue(TITLES[i]);
                jTable.getColumnModel().getColumn(i).setPreferredWidth(WIDTHS[i]);
            }
            jTable.getColumnModel().getColumn(1).setCellRenderer(new ComboRenderer());
        }

        void initLogDefEditor() throws SQLException {
            Set<LogDef> logDefs = this.this$0.well.getDataModel().getLogDefs();
            LogDefComboEditor logDefComboEditor = new LogDefComboEditor(new JComboBox(), logDefs, null);
            this.this$0.jTableCurves.getColumnModel().getColumn(1).setCellEditor(logDefComboEditor);
        }
    }
}

