/*
 * Decompiled with CFR 0.152.
 */
package jsbugs.wells;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.sql.SQLException;
import java.util.LinkedList;
import java.util.Objects;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumnModel;
import jsbugs.DialogMatchMarkers;
import jsbugs.FrameJsbugs;
import jsbugs.table.ColourRenderer;
import jsbugs.wells.DialogSeismicMarker;
import jsbugs.wells.ModelessWellInfoDialog;
import model3.Markers;
import model3.SBdb;
import model3.SeismicMarker;
import model3.Well;
import model3.WsWell;
import org.jdesktop.layout.GroupLayout;
import util.DepthUtils;
import util.SB;
import util.SBException;
import util.SBPermissionException;
import util.exception.StackError;

public class DialogMarkers
extends ModelessWellInfoDialog
implements Observer {
    private static final String[] titles = new String[]{"Depth", "Name", "Colour"};
    private static final int[] widths = new int[]{30, 30, 20};
    private final Well well;
    private final TableModelMarkers model = new TableModelMarkers(this);
    char units;
    char type;
    Markers markers;
    private JButton jButtonAdd;
    private JButton jButtonClose;
    private JButton jButtonDelete;
    private JButton jButtonEdit;
    private JButton jButtonHelp;
    private JButton jButtonMatch;
    private JScrollPane jScrollPane1;
    private JTable jTableMarkers;

    public DialogMarkers(Frame parent, boolean modal, Well well) throws SQLException, SBException {
        super(parent, modal);
        this.well = well;
        this.initComponents();
        this.init();
    }

    private void init() throws SQLException {
        SB.setTableHeaderBold((JTable)this.jTableMarkers);
        TableColumnModel columnModel = this.jTableMarkers.getTableHeader().getColumnModel();
        for (int i = 0; i < this.model.getColumnCount(); ++i) {
            columnModel.getColumn(i).setHeaderValue(titles[i]);
            columnModel.getColumn(i).setWidth(widths[i]);
        }
        this.jTableMarkers.setDefaultRenderer(Color.class, new ColourRenderer(true));
        this.setTitle("Seismic Markers : " + this.well.getWellName());
        this.markers = this.well.getMarkers();
        this.model.fireTableDataChanged();
        this.testMaster();
        this.markers.addObserver(this);
        this.getRootPane().setDefaultButton(this.jButtonClose);
        if (!this.well.canWrite(this.well.getDataModel(), null)) {
            this.jButtonDelete.setEnabled(false);
        }
    }

    @Override
    public void update(Observable obs, Object obj) {
        try {
            if (obs == this.well.getMarkers()) {
                this.model.fireTableDataChanged();
            }
        }
        catch (Exception e) {
            System.out.println("Exception in update method: " + String.valueOf(e));
        }
    }

    @Override
    public Well getWell() {
        return this.well;
    }

    @Override
    public void testMaster() {
        try {
            if (!this.well.getDataModel().hasCasingMaster()) {
                this.jButtonMatch.setVisible(false);
            } else if (!this.well.getMarkers().updateFromMaster(this.well.getWellID(), this.well.getWellCode())) {
                JOptionPane.showMessageDialog(this.getParent(), "Master seismic markers table is different: use Match for comparison", "Markers", 2);
            }
        }
        catch (SQLException | SBException | SBPermissionException e) {
            JOptionPane.showMessageDialog(this.getParent(), "Error from casing_master update: " + e.getMessage(), "Markers", 2);
            e.printStackTrace();
        }
    }

    private void initComponents() {
        this.jButtonClose = new JButton();
        this.jButtonDelete = new JButton();
        this.jButtonHelp = new JButton();
        this.jButtonAdd = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.jTableMarkers = new JTable();
        this.jButtonEdit = new JButton();
        this.jButtonMatch = new JButton();
        this.setDefaultCloseOperation(2);
        this.setMinimumSize(new Dimension(237, 285));
        this.addWindowListener(new WindowAdapter(this){
            final /* synthetic */ DialogMarkers this$0;
            {
                DialogMarkers dialogMarkers = this$0;
                Objects.requireNonNull(dialogMarkers);
                this.this$0 = dialogMarkers;
            }

            @Override
            public void windowClosing(WindowEvent evt) {
                this.this$0.formWindowClosing(evt);
            }
        });
        this.jButtonClose.setText("Close");
        this.jButtonClose.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogMarkers this$0;
            {
                DialogMarkers dialogMarkers = this$0;
                Objects.requireNonNull(dialogMarkers);
                this.this$0 = dialogMarkers;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonCloseActionPerformed(evt);
            }
        });
        this.jButtonDelete.setText("Delete");
        this.jButtonDelete.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogMarkers this$0;
            {
                DialogMarkers dialogMarkers = this$0;
                Objects.requireNonNull(dialogMarkers);
                this.this$0 = dialogMarkers;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonDeleteActionPerformed(evt);
            }
        });
        this.jButtonHelp.setText("Help");
        this.jButtonHelp.setMaximumSize(new Dimension(59, 23));
        this.jButtonHelp.setMinimumSize(new Dimension(59, 23));
        this.jButtonHelp.setPreferredSize(new Dimension(59, 23));
        this.jButtonHelp.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogMarkers this$0;
            {
                DialogMarkers dialogMarkers = this$0;
                Objects.requireNonNull(dialogMarkers);
                this.this$0 = dialogMarkers;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonHelpActionPerformed(evt);
            }
        });
        this.jButtonAdd.setText("Add..");
        this.jButtonAdd.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogMarkers this$0;
            {
                DialogMarkers dialogMarkers = this$0;
                Objects.requireNonNull(dialogMarkers);
                this.this$0 = dialogMarkers;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonAddActionPerformed(evt);
            }
        });
        this.jTableMarkers.setModel(this.model);
        this.jTableMarkers.addMouseListener(new MouseAdapter(this){
            final /* synthetic */ DialogMarkers this$0;
            {
                DialogMarkers dialogMarkers = this$0;
                Objects.requireNonNull(dialogMarkers);
                this.this$0 = dialogMarkers;
            }

            @Override
            public void mouseClicked(MouseEvent evt) {
                this.this$0.jTableMarkersMouseClicked(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.jTableMarkers);
        this.jButtonEdit.setText("Edit...");
        this.jButtonEdit.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogMarkers this$0;
            {
                DialogMarkers dialogMarkers = this$0;
                Objects.requireNonNull(dialogMarkers);
                this.this$0 = dialogMarkers;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonEditActionPerformed(evt);
            }
        });
        this.jButtonMatch.setText("Master...");
        this.jButtonMatch.setToolTipText("");
        this.jButtonMatch.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogMarkers this$0;
            {
                DialogMarkers dialogMarkers = this$0;
                Objects.requireNonNull(dialogMarkers);
                this.this$0 = dialogMarkers;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonMatchActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.jScrollPane1, -1, 134, Short.MAX_VALUE).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jButtonAdd, -1, -1, Short.MAX_VALUE).add((Component)this.jButtonDelete, -1, -1, Short.MAX_VALUE).add((Component)this.jButtonHelp, -1, -1, Short.MAX_VALUE).add((Component)this.jButtonClose, -1, -1, Short.MAX_VALUE).add((Component)this.jButtonEdit, -1, -1, Short.MAX_VALUE).add((Component)this.jButtonMatch)).addContainerGap()));
        layout.linkSize(new Component[]{this.jButtonAdd, this.jButtonClose, this.jButtonDelete, this.jButtonEdit, this.jButtonHelp, this.jButtonMatch}, 1);
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jScrollPane1, -1, 263, Short.MAX_VALUE).addContainerGap()).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jButtonAdd).addPreferredGap(0).add((Component)this.jButtonEdit).addPreferredGap(1).add((Component)this.jButtonDelete).addPreferredGap(1).add((Component)this.jButtonMatch).addPreferredGap(0, -1, Short.MAX_VALUE).add((Component)this.jButtonHelp, -2, -1, -2).addPreferredGap(0).add((Component)this.jButtonClose).add(11, 11, 11)))));
        this.pack();
    }

    private void jButtonCloseActionPerformed(ActionEvent evt) {
        this.markers.deleteObserver(this);
        this.dispose();
    }

    private void jButtonDeleteActionPerformed(ActionEvent evt) {
        if (this.jTableMarkers.getSelectedRow() < 0) {
            JOptionPane.showMessageDialog(this, "No row selected", this.getTitle(), 1);
            return;
        }
        LinkedList<SeismicMarker> toDelete = new LinkedList<SeismicMarker>();
        for (int row : this.jTableMarkers.getSelectedRows()) {
            toDelete.add(this.markers.get(row));
        }
        int option = JOptionPane.showConfirmDialog(this, "Really delete " + (String)(toDelete.size() > 1 ? "these " + toDelete.size() + "markers?" : "this marker?"), this.getTitle(), 0, 3);
        if (option != 0) {
            return;
        }
        try {
            this.well.deleteMarkers(toDelete);
            this.well.getDataModel().commit();
            this.well.getMarkers().notifyObservers();
            this.jTableMarkers.clearSelection();
            this.model.fireTableDataChanged();
        }
        catch (SBPermissionException pe) {
            JOptionPane.showMessageDialog(this, pe.getMessage(), this.getTitle(), 2);
        }
        catch (SQLException sql) {
            this.getWell().getDataModel().doRollback();
            FrameJsbugs.showStackError("Error", sql, this.getWell().getDataModel());
        }
    }

    private void jButtonAddActionPerformed(ActionEvent evt) {
        try {
            DialogSeismicMarker dialog = new DialogSeismicMarker(this, true, this.well, this.well.getWellUnits(), null);
            dialog.setLocation(this.getLocation().x + 25, this.getLocation().y + 25);
            dialog.setVisible(true);
            if (dialog.isOK) {
                this.model.fireTableDataChanged();
            }
        }
        catch (SQLException sql) {
            FrameJsbugs.showStackError("SQL Error", sql, this.well.getDataModel());
        }
    }

    private void jButtonHelpActionPerformed(ActionEvent evt) {
        FrameJsbugs.openHelp("dialogmarkers.html");
    }

    private void formWindowClosing(WindowEvent evt) {
        this.jButtonCloseActionPerformed(null);
    }

    private void jButtonEditActionPerformed(ActionEvent evt) {
        if (this.jTableMarkers.getSelectedRowCount() != 1) {
            JOptionPane.showMessageDialog(this, "Please select a single row to edit", this.getTitle(), 1);
            return;
        }
        SeismicMarker marker = this.markers.get(this.jTableMarkers.getSelectedRow());
        try {
            DialogSeismicMarker dialog = new DialogSeismicMarker(this, true, this.well, this.well.getWellUnits(), marker);
            dialog.setLocation(this.getLocation().x + 25, this.getLocation().y + 25);
            dialog.setVisible(true);
            if (dialog.isOK) {
                this.model.fireTableDataChanged();
            }
        }
        catch (SQLException sql) {
            FrameJsbugs.showStackError("SQL Error", sql, this.well.getDataModel());
        }
    }

    private void jTableMarkersMouseClicked(MouseEvent evt) {
        if (evt.getClickCount() > 1) {
            this.jButtonEditActionPerformed(null);
        }
    }

    private void jButtonMatchActionPerformed(ActionEvent evt) {
        try {
            SBdb ws = new SBdb(this.well.getDataModel());
            this.well.loadInterps();
            WsWell wsWell = ws.addWellToWorkspace(this.well);
            DialogMatchMarkers dialog = new DialogMatchMarkers(this, false, ws, wsWell, this.well.getWellUnits());
            dialog.setLocationRelativeTo(this);
            dialog.load();
            dialog.setVisible(true);
            this.model.fireTableDataChanged();
        }
        catch (SQLException | SBException se) {
            StackError.showStackError((Exception)se);
        }
    }

    private class TableModelMarkers
    extends AbstractTableModel {
        final /* synthetic */ DialogMarkers this$0;

        private TableModelMarkers(DialogMarkers dialogMarkers) {
            DialogMarkers dialogMarkers2 = dialogMarkers;
            Objects.requireNonNull(dialogMarkers2);
            this.this$0 = dialogMarkers2;
        }

        @Override
        public int getColumnCount() {
            return titles.length;
        }

        @Override
        public int getRowCount() {
            if (this.this$0.markers == null) {
                return 0;
            }
            return this.this$0.markers.getSize();
        }

        @Override
        public Object getValueAt(int row, int col) {
            SeismicMarker marker = this.this$0.markers.get(row);
            switch (col) {
                case 0: {
                    return SB.getDepthString((double)DepthUtils.convFromM((double)marker.getDepth(), (char)this.this$0.units, (char)this.this$0.type), (char)this.this$0.units, (int)2);
                }
                case 1: {
                    return marker;
                }
                case 2: {
                    return marker.getColour();
                }
            }
            return "";
        }

        @Override
        public void setValueAt(Object obj, int row, int col) {
            switch (col) {
                default: 
            }
        }

        public Class getColumnClass(int c) {
            switch (c) {
                case 0: {
                    return String.class;
                }
                case 1: {
                    return SeismicMarker.class;
                }
                case 2: {
                    return Color.class;
                }
            }
            return Object.class;
        }
    }
}

