/*
 * Decompiled with CFR 0.152.
 */
package jsbugs.wells;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.sql.SQLException;
import java.util.LinkedList;
import java.util.Objects;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import jsbugs.FrameJsbugs;
import model3.SeismicMarker;
import model3.Well;
import org.jdesktop.layout.GroupLayout;
import util.DepthUnits;
import util.DepthUtils;
import util.SB;
import util.SBException;
import util.SBPermissionException;

public class DialogSeismicMarker
extends JDialog {
    static final int LENCOLOUR = 20;
    static final int LENDEPTH = 8;
    Well well;
    char units;
    SeismicMarker orig = null;
    boolean isOK = false;
    private JButton jButtonCancel;
    private JButton jButtonOK;
    private JButton jButtonSelectColour;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabelUnits;
    private JSeparator jSeparator1;
    private JTextField jTextFieldColour;
    private JTextField jTextFieldDepth;
    private JTextField jTextFieldName;

    public DialogSeismicMarker(JDialog parent, boolean modal, Well well, char units, SeismicMarker marker) throws SQLException {
        super((Dialog)parent, modal);
        this.well = well;
        this.units = units;
        this.initComponents();
        this.orig = marker;
        this.init();
    }

    private void init() throws SQLException {
        this.setTitle("Seismic Marker : Add");
        this.jLabelUnits.setText(DepthUnits.getUnits((char)this.units).getAbr());
        if (!this.well.canWrite(this.well.getDataModel(), null)) {
            this.jButtonOK.setEnabled(false);
            this.jButtonOK.setToolTipText(this.well.getDeniedReason(this.well.getDataModel(), "well", false));
            this.getRootPane().setDefaultButton(this.jButtonCancel);
        } else {
            this.getRootPane().setDefaultButton(this.jButtonOK);
        }
        if (this.orig != null) {
            this.jTextFieldName.setText(this.orig.getName());
            this.jTextFieldColour.setBackground(this.orig.getColour());
            this.jTextFieldDepth.setText("" + DepthUtils.convFromM((double)this.orig.getDepth(), (char)this.units, (char)this.well.getType()));
        }
    }

    private void initComponents() {
        this.jButtonCancel = new JButton();
        this.jButtonOK = new JButton();
        this.jSeparator1 = new JSeparator();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jTextFieldName = new JTextField();
        this.jTextFieldDepth = new JTextField();
        this.jLabelUnits = new JLabel();
        this.jLabel3 = new JLabel();
        this.jTextFieldColour = new JTextField();
        this.jButtonSelectColour = new JButton();
        this.setDefaultCloseOperation(2);
        this.setResizable(false);
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.setMargin(new Insets(2, 10, 2, 10));
        this.jButtonCancel.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogSeismicMarker this$0;
            {
                DialogSeismicMarker dialogSeismicMarker = this$0;
                Objects.requireNonNull(dialogSeismicMarker);
                this.this$0 = dialogSeismicMarker;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonCancelActionPerformed(evt);
            }
        });
        this.jButtonOK.setText("OK");
        this.jButtonOK.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogSeismicMarker this$0;
            {
                DialogSeismicMarker dialogSeismicMarker = this$0;
                Objects.requireNonNull(dialogSeismicMarker);
                this.this$0 = dialogSeismicMarker;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonOKActionPerformed(evt);
            }
        });
        this.jLabel1.setText("Depth:");
        this.jLabel2.setText("Name:");
        this.jTextFieldName.setToolTipText("Enter a description of the seismic marker");
        this.jTextFieldName.setPreferredSize(new Dimension(50, 22));
        this.jTextFieldName.addKeyListener(new KeyAdapter(this){
            final /* synthetic */ DialogSeismicMarker this$0;
            {
                DialogSeismicMarker dialogSeismicMarker = this$0;
                Objects.requireNonNull(dialogSeismicMarker);
                this.this$0 = dialogSeismicMarker;
            }

            @Override
            public void keyTyped(KeyEvent evt) {
                this.this$0.jTextFieldNameKeyTyped(evt);
            }
        });
        this.jTextFieldDepth.addKeyListener(new KeyAdapter(this){
            final /* synthetic */ DialogSeismicMarker this$0;
            {
                DialogSeismicMarker dialogSeismicMarker = this$0;
                Objects.requireNonNull(dialogSeismicMarker);
                this.this$0 = dialogSeismicMarker;
            }

            @Override
            public void keyTyped(KeyEvent evt) {
                this.this$0.jTextFieldDepthKeyTyped(evt);
            }
        });
        this.jLabelUnits.setText("ft");
        this.jLabel3.setText("Colour:");
        this.jTextFieldColour.setEditable(false);
        this.jButtonSelectColour.setText("...");
        this.jButtonSelectColour.setToolTipText("More colours");
        this.jButtonSelectColour.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogSeismicMarker this$0;
            {
                DialogSeismicMarker dialogSeismicMarker = this$0;
                Objects.requireNonNull(dialogSeismicMarker);
                this.this$0 = dialogSeismicMarker;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonSelectColourActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jSeparator1).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jLabel3).add((GroupLayout.Group)layout.createParallelGroup(2).add((Component)this.jLabel1).add((Component)this.jLabel2))).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jTextFieldColour, -2, 47, -2).addPreferredGap(1).add((Component)this.jButtonSelectColour, -2, 37, -2)).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jTextFieldDepth, -2, 94, -2).addPreferredGap(0).add((Component)this.jLabelUnits))).add(0, 64, Short.MAX_VALUE)).add((Component)this.jTextFieldName, -1, -1, Short.MAX_VALUE))).add(2, (GroupLayout.Group)layout.createSequentialGroup().add(0, 0, Short.MAX_VALUE).add((Component)this.jButtonOK).addPreferredGap(0).add((Component)this.jButtonCancel))).addContainerGap()));
        layout.linkSize(new Component[]{this.jButtonCancel, this.jButtonOK}, 1);
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel1).add((Component)this.jTextFieldDepth, -2, -1, -2).add((Component)this.jLabelUnits)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel2).add((Component)this.jTextFieldName, -2, -1, -2)).addPreferredGap(1).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel3).add((Component)this.jTextFieldColour, -2, -1, -2).add((Component)this.jButtonSelectColour)).addPreferredGap(0).add((Component)this.jSeparator1, -2, 7, -2).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jButtonCancel).add((Component)this.jButtonOK)).addContainerGap(-1, Short.MAX_VALUE)));
        this.pack();
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void jButtonOKActionPerformed(ActionEvent evt) {
        try {
            String depthString = this.jTextFieldDepth.getText().trim();
            if (depthString.length() == 0) {
                JOptionPane.showMessageDialog(this, "Enter a depth", this.getTitle(), 2);
                return;
            }
            double depth = DepthUtils.convToM((double)Double.parseDouble(depthString), (char)this.units, (char)this.well.getType());
            if (depth < 0.01) {
                JOptionPane.showMessageDialog(this, "No depth specified", this.getTitle(), 2);
                return;
            }
            String name = this.jTextFieldName.getText();
            if (name.length() == 0) {
                JOptionPane.showMessageDialog(this, "Enter a name", this.getTitle(), 2);
                return;
            }
            if (this.orig != null) {
                LinkedList<SeismicMarker> l = new LinkedList<SeismicMarker>();
                l.add(this.orig);
                this.well.deleteMarkers(l);
            }
            this.well.addMarker(depth, name, this.jTextFieldColour.getBackground());
            this.well.getDataModel().commit();
            this.well.getMarkers().notifyObservers();
            this.isOK = true;
            this.dispose();
        }
        catch (SBPermissionException pe) {
            JOptionPane.showMessageDialog(this, pe.getMessage(), this.getTitle(), 2);
        }
        catch (SQLException | SBException sql) {
            FrameJsbugs.showStackError("Error", (Exception)sql, this.well.getDataModel());
        }
    }

    private void jTextFieldNameKeyTyped(KeyEvent evt) {
        if (SB.lenField((JTextField)this.jTextFieldName, (int)20, (KeyEvent)evt)) {
            this.getToolkit().beep();
        }
    }

    private void jTextFieldDepthKeyTyped(KeyEvent evt) {
        if (SB.floatFieldVal((JTextField)this.jTextFieldDepth, (int)8, (KeyEvent)evt, (boolean)true)) {
            this.getToolkit().beep();
        }
    }

    private void jButtonSelectColourActionPerformed(ActionEvent evt) {
        Color newColor = JColorChooser.showDialog(this, "Choose Marker Colour", this.jTextFieldColour.getBackground());
        if (newColor != null) {
            this.jTextFieldColour.setBackground(newColor);
        }
    }
}

