/*
 * Decompiled with CFR 0.152.
 */
package jsbugs.wells;

import com.stratadata.model3.external.SimpleLoginCredentials;
import com.stratadata.model3.external.WebServiceDescription;
import com.stratadata.model3.external.WebServiceDescriptionService;
import com.stratadata.model3.external.WebServiceType;
import com.stratadata.model3.external.WebServices;
import com.stratadata.model3.well.curve.WitsmlCurveHeader;
import com.stratadata.model3.well.curve.WitsmlCurveHeaderService;
import com.stratadata.model3.well.curve.WitsmlException;
import com.stratadata.model3.well.curve.WitsmlHandler;
import com.stratadata.util.depth.DepthUnits;
import com.stratadata.util.ui.SBDialog;
import com.stratadata.util.ui.table.TableUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.LayoutStyle;
import javax.swing.table.AbstractTableModel;
import jsbugs.DialogLogDefs;
import jsbugs.table.ColouredRenderer;
import jsbugs.table.ComboRenderer;
import jsbugs.table.LogDefComboEditor;
import jsbugs.uiutil.DialogCredentials;
import jsbugs.userconnect.SbugsExceptionHandler;
import jsbugs.webservices.DialogWebServices;
import model3.LogDef;
import model3.SBdb;
import model3.Well;
import model3.exception.SuppressedSQLException;
import org.apache.commons.lang3.StringUtils;

public class DialogWitsmlImport
extends SBDialog {
    private static final String[] TITLES = new String[]{"Curve description", "Mnemonic(s)", "Units", "Min", "Max", "Data Type", "Abr", "Type", "Import?"};
    private static final int[] WIDTHS = new int[]{60, 60, 10, 20, 20, 30, 30, 60, 30};
    private static final String DEPTH_INDEX = "Depth index";
    private final ResourceBundle resources = ResourceBundle.getBundle("locale/UiText");
    private static final Logger LOGGER = Logger.getLogger(DialogWitsmlImport.class.getName());
    private static final String SELECT = "<Select>";
    private final TableModelWitsmlCurves model = new TableModelWitsmlCurves(this);
    private final DefaultComboBoxModel serverModel = new DefaultComboBoxModel();
    private final DefaultComboBoxModel wellModel = new DefaultComboBoxModel();
    private final DefaultComboBoxModel wellBoreModel = new DefaultComboBoxModel();
    private final DefaultComboBoxModel logModel = new DefaultComboBoxModel();
    private final ArrayList<CurveTableRow> curveRows = new ArrayList();
    private final SBdb db;
    private final Well well;
    private final WebServiceDescriptionService webServiceProvider;
    WitsmlHandler witsml = null;
    boolean comboActive = true;
    private ButtonGroup buttonGroup1;
    private JButton jButtonCancel;
    private JButton jButtonLogDef;
    private JButton jButtonOK;
    private JButton jButtonServers;
    private JComboBox<String> jComboBoxLog;
    private JComboBox<String> jComboBoxServer;
    private JComboBox<String> jComboBoxWell;
    private JComboBox<String> jComboBoxWellBore;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JRadioButton jRadioButtonF;
    private JRadioButton jRadioButtonM;
    private JScrollPane jScrollPane1;
    private JTable jTableWTCurves;

    public DialogWitsmlImport(JDialog parent, boolean modal, SBdb db, Well well) throws SQLException {
        super((Window)parent, modal);
        this.initComponents();
        this.db = db;
        this.webServiceProvider = db.getWebServiceDescriptionService();
        this.well = well;
        this.setTitle("WITSML Log Curve Selection : " + well.getWellName());
        this.init(parent);
    }

    private void init(JDialog parent) throws SQLException {
        this.model.setupTable();
        WitsmlCurveHeaderService witsmlCurveHeaderService = this.well.getWitsmlCurveHeaderService();
        List<WitsmlCurveHeader> witsmlCurveHeaders = witsmlCurveHeaderService.getWitsmlCurveHeaders();
        if (!witsmlCurveHeaders.isEmpty()) {
            WitsmlCurveHeader sampleHeader = witsmlCurveHeaders.get(0);
            switch (sampleHeader.units()) {
                case F: {
                    this.jRadioButtonF.setSelected(true);
                    break;
                }
                case M: {
                    this.jRadioButtonM.setSelected(true);
                }
            }
            this.initServerModel();
            WebServiceDescription server = (WebServiceDescription)this.webServiceProvider.getServiceDescription(sampleHeader.serverID()).get();
            this.jComboBoxServer.setSelectedItem(server);
            this.initWitsmlServer();
            this.initWellModel(sampleHeader.well_UID(), sampleHeader.wellBore_UID(), sampleHeader.log_UID());
        } else {
            if (DepthUnits.getUnits((char)this.well.getWellUnits()) == DepthUnits.F) {
                this.jRadioButtonF.setSelected(true);
            } else {
                this.jRadioButtonM.setSelected(true);
            }
            List webServiceDetails = this.webServiceProvider.getServiceDescriptions(WebServiceType.WITSML);
            if (webServiceDetails.isEmpty()) {
                DialogWebServices dialog = new DialogWebServices(parent, true, this.db.getWebServiceDescriptionService(), WebServiceType.WITSML);
                dialog.setLocationRelativeTo(parent);
                dialog.setVisible(true);
                if (dialog.getSelection() == null) {
                    return;
                }
            }
            this.initServerModel();
            this.initWitsmlServer();
            if (this.witsml != null) {
                this.initWellModel(null, null, null);
            }
        }
    }

    private void initServerModel() {
        this.comboActive = false;
        this.serverModel.removeAllElements();
        for (WebServiceDescription ws : this.webServiceProvider.getServiceDescriptions(WebServiceType.WITSML)) {
            this.serverModel.addElement(ws);
        }
        if (this.serverModel.getSize() == 1) {
            this.jComboBoxServer.setSelectedIndex(0);
        }
        this.comboActive = true;
    }

    private void initWitsmlServer() {
        Object selectedItem = this.jComboBoxServer.getSelectedItem();
        if (!(selectedItem instanceof WebServiceDescription)) {
            return;
        }
        WebServiceDescription serviceDescription = (WebServiceDescription)selectedItem;
        if (this.witsml != null && this.witsml.getServiceDescription().equals((Object)serviceDescription)) {
            return;
        }
        this.witsml = new WitsmlHandler(serviceDescription);
        if (serviceDescription.requiresCredentials()) {
            SimpleLoginCredentials credentials = WebServices.getCredentials(serviceDescription);
            if (credentials == null) {
                this.requestCredentialsInput(serviceDescription);
            } else {
                this.witsml.setCredentials(credentials);
            }
        }
    }

    private void requestCredentialsInput(WebServiceDescription serviceDescription) {
        DialogCredentials dialog = new DialogCredentials((JDialog)((Object)this), true, "Enter Login Credentials for Service '" + serviceDescription.name() + "'");
        dialog.setLocationRelativeTo((Component)((Object)this));
        dialog.setVisible(true);
        SimpleLoginCredentials credentials = dialog.getCredentials();
        if (credentials != null && credentials.username().isEmpty()) {
            credentials = null;
        }
        WebServices.putCredentials(this.witsml.getServiceDescription(), credentials);
        this.witsml.setCredentials(credentials);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initWellModel(String well_UID, String wellbore_UID, String log_UID) {
        List<WitsmlHandler.WitsmlWellObj> witsmlWells;
        this.setCursor(Cursor.getPredefinedCursor(3));
        while (true) {
            try {
                witsmlWells = this.witsml.getWitsmlWells();
            }
            catch (WitsmlException e) {
                if (e.getServerResponseCode() == 401 && this.witsml.getServiceDescription().requiresCredentials()) {
                    this.requestCredentialsInput(this.witsml.getServiceDescription());
                    if (this.witsml.hasCredentials()) continue;
                    return;
                }
                JOptionPane.showMessageDialog((Component)((Object)this), "Error querying WITSML service: " + e.getMessage(), this.getTitle(), 0);
                LOGGER.log(Level.SEVERE, "Error querying WITSML", e);
                return;
            }
            finally {
                this.setCursor(Cursor.getDefaultCursor());
                continue;
            }
            break;
        }
        this.comboActive = false;
        this.wellModel.removeAllElements();
        WitsmlHandler.WitsmlWellObj selected = null;
        for (WitsmlHandler.WitsmlWellObj witsmlWell : witsmlWells) {
            this.wellModel.addElement(witsmlWell);
            if (well_UID != null) {
                if (!witsmlWell.getUid().equals(well_UID)) continue;
                selected = witsmlWell;
                continue;
            }
            if (!witsmlWell.matchesWellHeader(this.well.getWellCode(), this.well.getWellName(), this.well.getHeader().getWellAltName(true))) continue;
            selected = witsmlWell;
        }
        if (selected != null && wellbore_UID != null) {
            this.jComboBoxWell.setSelectedItem(selected);
            this.initWellboreModel(wellbore_UID, log_UID);
            return;
        }
        this.comboActive = true;
        if (selected == null) {
            this.wellModel.insertElementAt(SELECT, 0);
            this.jComboBoxWell.setSelectedIndex(0);
        } else {
            this.jComboBoxWell.setSelectedItem(selected);
        }
        this.resetTable();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initWellboreModel(String wellbore_UID, String log_UID) {
        List<WitsmlHandler.WitsmlWellboreObj> witsmlWellbores;
        WitsmlHandler.WitsmlWellObj witsmlWell = (WitsmlHandler.WitsmlWellObj)this.jComboBoxWell.getSelectedItem();
        this.setCursor(Cursor.getPredefinedCursor(3));
        try {
            witsmlWellbores = this.witsml.getWitsmlWellbores(witsmlWell);
        }
        catch (WitsmlException e) {
            JOptionPane.showMessageDialog((Component)((Object)this), "Error querying WITSML service: " + e.getMessage(), this.getTitle(), 0);
            LOGGER.log(Level.SEVERE, "Error querying WITSML", e);
            return;
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
        }
        this.comboActive = false;
        this.wellBoreModel.removeAllElements();
        WitsmlHandler.WitsmlWellboreObj selected = null;
        for (WitsmlHandler.WitsmlWellboreObj witsmlWellbore : witsmlWellbores) {
            this.wellBoreModel.addElement(witsmlWellbore);
            if (wellbore_UID != null) {
                if (!witsmlWellbore.getUid().equals(wellbore_UID)) continue;
                selected = witsmlWellbore;
                continue;
            }
            if (!witsmlWellbore.matchesWellHeader(this.well.getWellName(), this.well.getHeader().getWellAltName(true))) continue;
            selected = witsmlWellbore;
        }
        if (this.wellBoreModel.getSize() == 1) {
            selected = (WitsmlHandler.WitsmlWellboreObj)this.wellBoreModel.getElementAt(0);
        }
        if (selected != null && log_UID != null) {
            this.jComboBoxWellBore.setSelectedItem(selected);
            this.initLogModel(log_UID);
            return;
        }
        this.comboActive = true;
        if (selected == null) {
            this.wellBoreModel.insertElementAt(SELECT, 0);
            this.jComboBoxWellBore.setSelectedIndex(0);
        } else {
            this.jComboBoxWellBore.setSelectedItem(selected);
        }
        this.resetTable();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initLogModel(String log_UID) {
        List<WitsmlHandler.WitsmlLogObj> witsmlLogs;
        WitsmlHandler.WitsmlWellboreObj witsmlWellbore = (WitsmlHandler.WitsmlWellboreObj)this.jComboBoxWellBore.getSelectedItem();
        this.setCursor(Cursor.getPredefinedCursor(3));
        try {
            witsmlLogs = this.witsml.getWitsmlLogs(witsmlWellbore);
        }
        catch (WitsmlException e) {
            JOptionPane.showMessageDialog((Component)((Object)this), "Error querying WITSML service: " + e.getMessage(), this.getTitle(), 0);
            LOGGER.log(Level.SEVERE, "Error querying WITSML", e);
            return;
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
        }
        this.comboActive = false;
        this.logModel.removeAllElements();
        WitsmlHandler.WitsmlLogObj selected = null;
        for (WitsmlHandler.WitsmlLogObj witsmlLog : witsmlLogs) {
            this.logModel.addElement(witsmlLog);
            if (log_UID == null || !witsmlLog.getUid().equals(log_UID)) continue;
            selected = witsmlLog;
        }
        if (this.logModel.getSize() > 1) {
            this.logModel.insertElementAt(SELECT, 0);
        }
        this.comboActive = true;
        this.jComboBoxLog.setSelectedItem(selected != null ? selected : (WitsmlHandler.WitsmlLogObj)this.logModel.getElementAt(0));
    }

    private void initCurves() {
        WitsmlHandler.WitsmlLogObj logRec = (WitsmlHandler.WitsmlLogObj)this.jComboBoxLog.getSelectedItem();
        this.curveRows.clear();
        try {
            WitsmlCurveHeaderService witsmlCurveHeaderService = this.well.getWitsmlCurveHeaderService();
            List<WitsmlCurveHeader> witsmlCurveHeaders = witsmlCurveHeaderService.getWitsmlCurveHeaders();
            int i = 0;
            for (WitsmlHandler.WitsmlLogCurveInfo logCurveInfo : logRec.getLogCurveInfo()) {
                Optional<WitsmlCurveHeader> matchingHeader;
                CurveTableRow curveRow = new CurveTableRow(logCurveInfo);
                if (this.isDepthIndex(logCurveInfo.descr()) || this.isDepthIndex(logCurveInfo.mnemonic())) {
                    this.model.depthIndex = i;
                    curveRow.getCurve = true;
                } else {
                    curveRow.logDef = this.db.getLogDef(logCurveInfo.mnemonic());
                    if (curveRow.logDef == null && !logCurveInfo.mnemonicAlias().isEmpty()) {
                        curveRow.logDef = this.db.getLogDef(logCurveInfo.mnemonicAlias());
                    }
                }
                if (!witsmlCurveHeaders.isEmpty() && (matchingHeader = witsmlCurveHeaders.stream().filter(wch -> StringUtils.equalsIgnoreCase((CharSequence)wch.mnemonic(), (CharSequence)logCurveInfo.mnemonic())).findFirst()).isPresent()) {
                    WitsmlCurveHeader header = matchingHeader.get();
                    curveRow.getCurve = true;
                    curveRow.logDef = this.db.getLogDef(header.abr());
                }
                this.curveRows.add(curveRow);
                ++i;
            }
            this.model.fireTableDataChanged();
        }
        catch (SQLException ex) {
            LOGGER.log(Level.SEVERE, null, ex);
        }
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.jLabel2 = new JLabel();
        this.jComboBoxServer = new JComboBox();
        this.jButtonServers = new JButton();
        this.jLabel3 = new JLabel();
        this.jComboBoxWell = new JComboBox();
        this.jLabel4 = new JLabel();
        this.jComboBoxWellBore = new JComboBox();
        this.jLabel5 = new JLabel();
        this.jComboBoxLog = new JComboBox();
        this.jScrollPane1 = new JScrollPane();
        this.jTableWTCurves = new JTable();
        this.jButtonOK = new JButton();
        this.jButtonCancel = new JButton();
        this.jLabel6 = new JLabel();
        this.jRadioButtonM = new JRadioButton();
        this.jRadioButtonF = new JRadioButton();
        this.jButtonLogDef = new JButton();
        this.setDefaultCloseOperation(2);
        this.setMinimumSize(new Dimension(400, 400));
        this.jLabel2.setHorizontalAlignment(11);
        this.jLabel2.setText("Server:");
        this.jComboBoxServer.setModel(this.serverModel);
        this.jComboBoxServer.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogWitsmlImport this$0;
            {
                DialogWitsmlImport dialogWitsmlImport = this$0;
                Objects.requireNonNull(dialogWitsmlImport);
                this.this$0 = dialogWitsmlImport;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jComboBoxServerActionPerformed(evt);
            }
        });
        this.jButtonServers.setText("...");
        this.jButtonServers.setToolTipText("Coonfigure WTISML servers");
        this.jButtonServers.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogWitsmlImport this$0;
            {
                DialogWitsmlImport dialogWitsmlImport = this$0;
                Objects.requireNonNull(dialogWitsmlImport);
                this.this$0 = dialogWitsmlImport;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonServersActionPerformed(evt);
            }
        });
        this.jLabel3.setHorizontalAlignment(11);
        this.jLabel3.setText("Well:");
        this.jComboBoxWell.setModel(this.wellModel);
        this.jComboBoxWell.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogWitsmlImport this$0;
            {
                DialogWitsmlImport dialogWitsmlImport = this$0;
                Objects.requireNonNull(dialogWitsmlImport);
                this.this$0 = dialogWitsmlImport;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jComboBoxWellActionPerformed(evt);
            }
        });
        this.jLabel4.setHorizontalAlignment(11);
        this.jLabel4.setText("Well bore:");
        this.jComboBoxWellBore.setModel(this.wellBoreModel);
        this.jComboBoxWellBore.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogWitsmlImport this$0;
            {
                DialogWitsmlImport dialogWitsmlImport = this$0;
                Objects.requireNonNull(dialogWitsmlImport);
                this.this$0 = dialogWitsmlImport;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jComboBoxWellBoreActionPerformed(evt);
            }
        });
        this.jLabel5.setHorizontalAlignment(11);
        this.jLabel5.setText("Log suite:");
        this.jComboBoxLog.setModel(this.logModel);
        this.jComboBoxLog.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogWitsmlImport this$0;
            {
                DialogWitsmlImport dialogWitsmlImport = this$0;
                Objects.requireNonNull(dialogWitsmlImport);
                this.this$0 = dialogWitsmlImport;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jComboBoxLogActionPerformed(evt);
            }
        });
        this.jTableWTCurves.setModel(this.model);
        this.jScrollPane1.setViewportView(this.jTableWTCurves);
        ResourceBundle bundle = ResourceBundle.getBundle("locale/UiText");
        this.jButtonOK.setText(bundle.getString("button.ok"));
        this.jButtonOK.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogWitsmlImport this$0;
            {
                DialogWitsmlImport dialogWitsmlImport = this$0;
                Objects.requireNonNull(dialogWitsmlImport);
                this.this$0 = dialogWitsmlImport;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonOKActionPerformed(evt);
            }
        });
        this.jButtonCancel.setText(bundle.getString("button.cancel"));
        this.jButtonCancel.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogWitsmlImport this$0;
            {
                DialogWitsmlImport dialogWitsmlImport = this$0;
                Objects.requireNonNull(dialogWitsmlImport);
                this.this$0 = dialogWitsmlImport;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonCancelActionPerformed(evt);
            }
        });
        this.jLabel6.setText("Untis:");
        this.buttonGroup1.add(this.jRadioButtonM);
        this.jRadioButtonM.setText("Metres");
        this.buttonGroup1.add(this.jRadioButtonF);
        this.jRadioButtonF.setText("Feet");
        this.jButtonLogDef.setText("Header defaults...");
        this.jButtonLogDef.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogWitsmlImport this$0;
            {
                DialogWitsmlImport dialogWitsmlImport = this$0;
                Objects.requireNonNull(dialogWitsmlImport);
                this.this$0 = dialogWitsmlImport;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonLogDefActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGap(18, 18, 18).addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jComboBoxServer, 0, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonServers)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(layout.createSequentialGroup().addGap(2, 2, 2).addComponent(this.jLabel5).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jComboBoxLog, 0, -1, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jLabel4).addComponent(this.jLabel3)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jComboBoxWell, 0, -1, Short.MAX_VALUE).addComponent(this.jComboBoxWellBore, 0, -1, Short.MAX_VALUE)))).addGap(1, 1, 1)).addComponent(this.jScrollPane1, GroupLayout.Alignment.TRAILING, -1, 641, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.jLabel6).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jRadioButtonM).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jRadioButtonF)).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.jButtonOK).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonCancel)))).addGroup(layout.createSequentialGroup().addComponent(this.jButtonLogDef).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.jComboBoxServer, -2, -1, -2).addComponent(this.jButtonServers)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jComboBoxWell, -2, -1, -2).addComponent(this.jLabel3)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel4).addComponent(this.jComboBoxWellBore, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jComboBoxLog, -2, -1, -2).addComponent(this.jLabel5)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel6).addComponent(this.jRadioButtonM).addComponent(this.jRadioButtonF)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -1, 281, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButtonCancel).addComponent(this.jButtonOK).addComponent(this.jButtonLogDef)).addContainerGap()));
        this.pack();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void jButtonOKActionPerformed(ActionEvent evt) {
        if (this.curveRows.isEmpty()) {
            JOptionPane.showMessageDialog((Component)((Object)this), "There are no curves to select", this.getTitle(), 1);
            return;
        }
        if (this.model.depthIndex < 0) {
            JOptionPane.showMessageDialog((Component)((Object)this), "You must select a depth index", this.getTitle(), 1);
            return;
        }
        String mnemonics = this.curveRows.stream().filter(curveRow -> curveRow.getCurve).map(curveRow -> curveRow.curveInfo.mnemonic()).collect(Collectors.joining(","));
        if (mnemonics.isEmpty()) {
            JOptionPane.showMessageDialog((Component)((Object)this), "No curves selected", this.getTitle(), 1);
            return;
        }
        WebServiceDescription ws = (WebServiceDescription)this.jComboBoxServer.getSelectedItem();
        WitsmlHandler.WitsmlLogObj witsmlLog = (WitsmlHandler.WitsmlLogObj)this.jComboBoxLog.getSelectedItem();
        List<WitsmlCurveHeader> witsmlCurveHeaders = this.curveRows.stream().filter(row -> row.getCurve).map(row -> new WitsmlCurveHeader(0, this.well.getWellID(), ws.ID(), witsmlLog.getWellUid(), witsmlLog.getWellboreUid(), witsmlLog.getUid(), row.curveInfo.mnemonic(), row.logDef != null ? row.logDef.getAbr() : null, this.getDepthUnits())).toList();
        this.setCursor(Cursor.getPredefinedCursor(3));
        try {
            this.well.getWitsmlCurveHeaderService().storeWitsmlCurveHeaders(witsmlCurveHeaders);
        }
        catch (SQLException | SuppressedSQLException sqlEx) {
            SbugsExceptionHandler.showStackError("Error storing WITSML curve headers", sqlEx);
            return;
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
        }
        this.setOK();
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void jButtonServersActionPerformed(ActionEvent evt) {
        try {
            DialogWebServices dialog = new DialogWebServices((JDialog)((Object)this), true, this.db.getWebServiceDescriptionService(), WebServiceType.WITSML);
            dialog.setLocationRelativeTo((Component)((Object)this));
            dialog.setVisible(true);
            if (dialog.getSelection() == null) {
                return;
            }
            this.initServerModel();
            this.jComboBoxServer.setSelectedIndex(0);
            this.resetTable();
        }
        catch (RuntimeException ex) {
            SbugsExceptionHandler.showDialogStackError(ex, (Component)((Object)this));
        }
    }

    private void jComboBoxServerActionPerformed(ActionEvent evt) {
        if (!this.comboActive) {
            return;
        }
        if (this.jComboBoxServer.getSelectedItem() instanceof String) {
            this.wellModel.removeAllElements();
            this.wellBoreModel.removeAllElements();
            this.logModel.removeAllElements();
            return;
        }
        this.initWitsmlServer();
        this.initWellModel(null, null, null);
    }

    private void jComboBoxWellActionPerformed(ActionEvent evt) {
        if (!this.comboActive || this.witsml == null || this.jComboBoxWell.getSelectedItem() == null) {
            return;
        }
        if (this.jComboBoxWell.getSelectedItem() instanceof String) {
            this.wellBoreModel.removeAllElements();
            this.logModel.removeAllElements();
            return;
        }
        this.initWellboreModel(null, null);
    }

    private void jComboBoxWellBoreActionPerformed(ActionEvent evt) {
        if (!this.comboActive || this.witsml == null || this.jComboBoxWellBore.getSelectedItem() == null) {
            return;
        }
        if (this.jComboBoxWellBore.getSelectedItem() instanceof String) {
            this.logModel.removeAllElements();
            return;
        }
        this.initLogModel(null);
    }

    private void jComboBoxLogActionPerformed(ActionEvent evt) {
        if (!this.comboActive || this.witsml == null || this.jComboBoxLog.getSelectedItem() == null || this.jComboBoxLog.getSelectedItem() instanceof String) {
            return;
        }
        this.initCurves();
    }

    private void jButtonLogDefActionPerformed(ActionEvent evt) {
        try {
            DialogLogDefs dialog = new DialogLogDefs((JDialog)((Object)this), true, this.well.getDataModel());
            dialog.setLocationRelativeTo((Component)((Object)this));
            dialog.setVisible(true);
            this.jTableWTCurves.getColumnModel().getColumn(6).setCellEditor(new LogDefComboEditor(new JComboBox(), this.db.getLogDefs(), DEPTH_INDEX));
        }
        catch (SQLException sql) {
            SbugsExceptionHandler.showStackError(sql, (Component)((Object)this));
        }
    }

    private boolean isDepthIndex(String s) {
        return "MD".equalsIgnoreCase(s) || "Depth".equalsIgnoreCase(s);
    }

    private void resetTable() {
        this.curveRows.clear();
        this.model.fireTableDataChanged();
    }

    private DepthUnits getDepthUnits() {
        if (this.jRadioButtonF.isSelected()) {
            return DepthUnits.F;
        }
        return DepthUnits.M;
    }

    private class TableModelWitsmlCurves
    extends AbstractTableModel {
        int depthIndex;
        static final int COL_CURVE = 0;
        static final int COL_MNEM = 1;
        static final int COL_UNITS = 2;
        static final int COL_MIN = 3;
        static final int COL_MAX = 4;
        static final int COL_DATATYPE = 5;
        static final int COL_ABR = 6;
        static final int COL_TYPE = 7;
        static final int COL_GET = 8;
        final /* synthetic */ DialogWitsmlImport this$0;

        private TableModelWitsmlCurves(DialogWitsmlImport dialogWitsmlImport) {
            DialogWitsmlImport dialogWitsmlImport2 = dialogWitsmlImport;
            Objects.requireNonNull(dialogWitsmlImport2);
            this.this$0 = dialogWitsmlImport2;
            this.depthIndex = -1;
        }

        @Override
        public int getColumnCount() {
            return TITLES.length;
        }

        @Override
        public int getRowCount() {
            return this.this$0.curveRows.size();
        }

        @Override
        public Object getValueAt(int rowIndex, int col) {
            CurveTableRow row = this.this$0.curveRows.get(rowIndex);
            WitsmlHandler.WitsmlLogCurveInfo curveInfo = row.curveInfo;
            switch (col) {
                case 0: {
                    return curveInfo.descr();
                }
                case 1: {
                    return curveInfo.getMnemWithAlias();
                }
                case 2: {
                    return curveInfo.unit();
                }
                case 3: {
                    return curveInfo.min();
                }
                case 4: {
                    return curveInfo.max();
                }
                case 5: {
                    return curveInfo.type();
                }
                case 6: {
                    if (rowIndex == this.depthIndex) {
                        return DialogWitsmlImport.DEPTH_INDEX;
                    }
                    if (row.logDef != null) {
                        return row.logDef.getAbr();
                    }
                    return "";
                }
                case 7: {
                    if (row.logDef != null) {
                        return row.logDef.getTitle() + " : " + row.logDef.getUnits();
                    }
                    return "";
                }
                case 8: {
                    return row.getCurve;
                }
            }
            return "";
        }

        @Override
        public void setValueAt(Object obj, int rowIndex, int col) {
            CurveTableRow row = this.this$0.curveRows.get(rowIndex);
            switch (col) {
                default: {
                    break;
                }
                case 8: {
                    if (rowIndex == this.depthIndex) {
                        return;
                    }
                    row.getCurve = (Boolean)obj;
                    if (row.logDef != null) break;
                    row.getCurve = false;
                    break;
                }
                case 6: {
                    if (obj instanceof String) {
                        if (this.depthIndex >= 0) {
                            this.this$0.curveRows.get((int)this.depthIndex).logDef = null;
                            this.this$0.curveRows.get((int)this.depthIndex).getCurve = false;
                        }
                        this.depthIndex = rowIndex;
                    } else {
                        row.logDef = (LogDef)obj;
                    }
                    row.getCurve = true;
                }
            }
        }

        public Class getColumnClass(int c) {
            if (c == 8) {
                return Boolean.class;
            }
            return String.class;
        }

        @Override
        public boolean isCellEditable(int r, int c) {
            switch (c) {
                case 6: 
                case 8: {
                    return true;
                }
            }
            return false;
        }

        void setupTable() throws SQLException {
            TableUtils.setTableHeaderBold((JTable)this.this$0.jTableWTCurves);
            for (int i = 0; i < TITLES.length; ++i) {
                this.this$0.jTableWTCurves.getColumnModel().getColumn(i).setHeaderValue(TITLES[i]);
                this.this$0.jTableWTCurves.getColumnModel().getColumn(i).setPreferredWidth(WIDTHS[i]);
            }
            this.this$0.jTableWTCurves.getColumnModel().getColumn(6).setCellRenderer(new ComboRenderer(null, new Color(235, 255, 255)));
            this.this$0.jTableWTCurves.getColumnModel().getColumn(6).setCellEditor(new LogDefComboEditor(new JComboBox(), this.this$0.db.getLogDefs(), DialogWitsmlImport.DEPTH_INDEX));
            this.this$0.jTableWTCurves.getColumnModel().getColumn(7).setCellRenderer(new ColouredRenderer(false, ColouredRenderer.GREY));
        }
    }

    private static class CurveTableRow {
        final WitsmlHandler.WitsmlLogCurveInfo curveInfo;
        LogDef logDef;
        boolean getCurve;

        public CurveTableRow(WitsmlHandler.WitsmlLogCurveInfo curveInfo) {
            this.curveInfo = curveInfo;
        }
    }
}

